/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Autonomo;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.DivisaoTcmgoPK;
import br.com.fiorilli.sip.persistence.entity.TomadorObra;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Size;

@Entity
@Table(name="SIPGO_DIVISAO")
@IdClass(value=DivisaoTcmgoPK.class)
@Audited
public class DivisaoTcmgo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="EMPRESA", nullable=false, length=3)
    private String entidadeCodigo;
    @Id
    @Column(name="DIVISAO", nullable=false, length=6)
    private String divisaoCodigo;
    @Column(name="CODIGO_TCMGO")
    private String codigoTcmgo;
    @Basic
    @Column(name="CODIGO_ORGAO", length=2)
    private String codigoOrgao;
    @Basic
    @Column(name="TIPO_ORGAO", length=2)
    private String tipoOrgao;
    @Column(name="DATADOC")
    private Date dataDocumento;
    @Column(name="TIPOLEGAL")
    private Integer tipoLegalDoc;
    @Column(name="NUMDOC")
    @Size(max=16)
    private String numeroDocumento;
    @Column(name="ARQUIVO")
    private Byte[] arquivo;
    @Column(name="NOMEARQ")
    @Size(max=512)
    private String nomeArquivo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA_ORDENADOR_DESP", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO_ORDENADOR_DESP", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Trabalhador trabalhadorOrdenadorDespesa;
    @JoinColumns(value={@JoinColumn(name="EMPRESA_CONTADOR", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO_CONTADOR", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Trabalhador trabalhadorContador;
    @JoinColumns(value={@JoinColumn(name="EMPRESA_CTRL_INTERNO", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO_CTRL_INTERNO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Trabalhador trabalhadorControleInterno;
    @JoinColumns(value={@JoinColumn(name="EMPRESA_ADVOGADO", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO_ADVOGADO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Trabalhador trabalhadorAdvogado;
    @JoinColumns(value={@JoinColumn(name="EMPRESA_CONTADOR", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="AUTONOMO_CONTADOR", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Autonomo autonomoContador;
    @JoinColumns(value={@JoinColumn(name="EMPRESA_ADVOGADO", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="AUTONOMO_ADVOGADO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Autonomo autonomoAdvogado;
    @JoinColumns(value={@JoinColumn(name="EMPRESA_CONTADOR", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="TOMADOROBRA_CONTADOR", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private TomadorObra assessoriaContabil;
    @JoinColumns(value={@JoinColumn(name="EMPRESA_ADVOGADO", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="TOMADOROBRA_ADVOGADO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private TomadorObra assessoriaJudicial;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="DIVISAO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Divisao divisao;

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public String getDivisaoCodigo() {
        return this.divisaoCodigo;
    }

    public String getCodigoTcmgo() {
        return this.codigoTcmgo;
    }

    public String getCodigoOrgao() {
        return this.codigoOrgao;
    }

    public String getTipoOrgao() {
        return this.tipoOrgao;
    }

    public Trabalhador getTrabalhadorOrdenadorDespesa() {
        return this.trabalhadorOrdenadorDespesa;
    }

    public Trabalhador getTrabalhadorContador() {
        return this.trabalhadorContador;
    }

    public Trabalhador getTrabalhadorControleInterno() {
        return this.trabalhadorControleInterno;
    }

    public Trabalhador getTrabalhadorAdvogado() {
        return this.trabalhadorAdvogado;
    }

    public Autonomo getAutonomoContador() {
        return this.autonomoContador;
    }

    public Autonomo getAutonomoAdvogado() {
        return this.autonomoAdvogado;
    }

    public TomadorObra getAssessoriaContabil() {
        return this.assessoriaContabil;
    }

    public TomadorObra getAssessoriaJudicial() {
        return this.assessoriaJudicial;
    }

    public Divisao getDivisao() {
        return this.divisao;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public void setDivisaoCodigo(String divisaoCodigo) {
        this.divisaoCodigo = divisaoCodigo;
    }

    public void setCodigoTcmgo(String codigoTcmgo) {
        this.codigoTcmgo = codigoTcmgo;
    }

    public void setCodigoOrgao(String codigoOrgao) {
        this.codigoOrgao = codigoOrgao;
    }

    public void setTipoOrgao(String tipoOrgao) {
        this.tipoOrgao = tipoOrgao;
    }

    public void setTrabalhadorOrdenadorDespesa(Trabalhador trabalhadorOrdenadorDespesa) {
        this.trabalhadorOrdenadorDespesa = trabalhadorOrdenadorDespesa;
    }

    public void setTrabalhadorContador(Trabalhador trabalhadorContador) {
        this.trabalhadorContador = trabalhadorContador;
    }

    public void setTrabalhadorControleInterno(Trabalhador trabalhadorControleInterno) {
        this.trabalhadorControleInterno = trabalhadorControleInterno;
    }

    public void setTrabalhadorAdvogado(Trabalhador trabalhadorAdvogado) {
        this.trabalhadorAdvogado = trabalhadorAdvogado;
    }

    public void setAutonomoContador(Autonomo autonomoContador) {
        this.autonomoContador = autonomoContador;
    }

    public void setAutonomoAdvogado(Autonomo autonomoAdvogado) {
        this.autonomoAdvogado = autonomoAdvogado;
    }

    public void setAssessoriaContabil(TomadorObra assessoriaContabil) {
        this.assessoriaContabil = assessoriaContabil;
    }

    public void setAssessoriaJudicial(TomadorObra assessoriaJudicial) {
        this.assessoriaJudicial = assessoriaJudicial;
    }

    public void setDivisao(Divisao divisao) {
        this.divisao = divisao;
    }

    public DivisaoTcmgo() {
    }

    public DivisaoTcmgo(String entidadeCodigo, String divisaoCodigo, String codigoTcmgo, String codigoOrgao, String tipoOrgao, Date dataDocumento, Integer tipoLegalDoc, String numeroDocumento, Byte[] arquivo, String nomeArquivo, Trabalhador trabalhadorOrdenadorDespesa, Trabalhador trabalhadorContador, Trabalhador trabalhadorControleInterno, Trabalhador trabalhadorAdvogado, Autonomo autonomoContador, Autonomo autonomoAdvogado, TomadorObra assessoriaContabil, TomadorObra assessoriaJudicial, Divisao divisao) {
        this.entidadeCodigo = entidadeCodigo;
        this.divisaoCodigo = divisaoCodigo;
        this.codigoTcmgo = codigoTcmgo;
        this.codigoOrgao = codigoOrgao;
        this.tipoOrgao = tipoOrgao;
        this.dataDocumento = dataDocumento;
        this.tipoLegalDoc = tipoLegalDoc;
        this.numeroDocumento = numeroDocumento;
        this.arquivo = arquivo;
        this.nomeArquivo = nomeArquivo;
        this.trabalhadorOrdenadorDespesa = trabalhadorOrdenadorDespesa;
        this.trabalhadorContador = trabalhadorContador;
        this.trabalhadorControleInterno = trabalhadorControleInterno;
        this.trabalhadorAdvogado = trabalhadorAdvogado;
        this.autonomoContador = autonomoContador;
        this.autonomoAdvogado = autonomoAdvogado;
        this.assessoriaContabil = assessoriaContabil;
        this.assessoriaJudicial = assessoriaJudicial;
        this.divisao = divisao;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DivisaoTcmgo)) {
            return false;
        }
        DivisaoTcmgo other = (DivisaoTcmgo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$entidadeCodigo = this.getEntidadeCodigo();
        String other$entidadeCodigo = other.getEntidadeCodigo();
        if (this$entidadeCodigo == null ? other$entidadeCodigo != null : !this$entidadeCodigo.equals(other$entidadeCodigo)) {
            return false;
        }
        String this$divisaoCodigo = this.getDivisaoCodigo();
        String other$divisaoCodigo = other.getDivisaoCodigo();
        if (this$divisaoCodigo == null ? other$divisaoCodigo != null : !this$divisaoCodigo.equals(other$divisaoCodigo)) {
            return false;
        }
        String this$codigoTcmgo = this.getCodigoTcmgo();
        String other$codigoTcmgo = other.getCodigoTcmgo();
        return !(this$codigoTcmgo == null ? other$codigoTcmgo != null : !this$codigoTcmgo.equals(other$codigoTcmgo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DivisaoTcmgo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $entidadeCodigo = this.getEntidadeCodigo();
        result = result * 59 + ($entidadeCodigo == null ? 43 : $entidadeCodigo.hashCode());
        String $divisaoCodigo = this.getDivisaoCodigo();
        result = result * 59 + ($divisaoCodigo == null ? 43 : $divisaoCodigo.hashCode());
        String $codigoTcmgo = this.getCodigoTcmgo();
        result = result * 59 + ($codigoTcmgo == null ? 43 : $codigoTcmgo.hashCode());
        return result;
    }

    public String toString() {
        return "DivisaoTcmgo(entidadeCodigo=" + this.getEntidadeCodigo() + ", divisaoCodigo=" + this.getDivisaoCodigo() + ", codigoTcmgo=" + this.getCodigoTcmgo() + ")";
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date dataDocumento) {
        this.dataDocumento = dataDocumento;
    }

    public Integer getTipoLegalDoc() {
        return this.tipoLegalDoc;
    }

    public void setTipoLegalDoc(Integer tipoLegalDoc) {
        this.tipoLegalDoc = tipoLegalDoc;
    }

    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    public void setNumeroDocumento(String numeroDocumento) {
        this.numeroDocumento = numeroDocumento;
    }

    public Byte[] getArquivo() {
        return this.arquivo;
    }

    public void setArquivo(Byte[] arquivo) {
        this.arquivo = arquivo;
    }

    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }
}

