/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.DivisaoPK;
import br.com.fiorilli.sip.persistence.entity.DivisaoTcmgo;
import br.com.fiorilli.sip.persistence.entity.Endereco;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.IdentificadorTipo;
import br.com.fiorilli.sip.persistence.entity.PermissoesPerfilDivisoes;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;

@FilterConfigType(autoFilter=true)
@Entity
@Table(name="DIVISAO")
@Audited
public class Divisao
implements Serializable,
Filterable,
GenericEntity {
    private static final long serialVersionUID = 1L;
    public static final String FIND_FOR_FILTER = "SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo";
    public static final String FIND_BY_ENTIDADE_NOME = "SELECT d FROM Divisao d WHERE (d.divisaoPK.entidade = :entidadeId OR :entidadeId = '000') AND d.nome LIKE :nome)";
    public static final String FIND_RESPONSAVEL = "SELECT d.responsavel FROM Divisao d WHERE d.divisaoPK = :divisaoPK";
    public static final String FIND_BY_CODIGO = "SELECT d FROM Divisao d WHERE d.divisaoPK.codigo = :codigo";
    public static final String FIND_BY_ENTIDADE_CODIGO = "SELECT d FROM Divisao d WHERE (d.divisaoPK.entidade = :entidadeId OR :entidadeId = '000') AND d.divisaoPK.codigo = :codigo";
    @EmbeddedId
    protected DivisaoPK divisaoPK = new DivisaoPK();
    @FilterConfig(label="Nome", order=2)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Embedded
    private Endereco endereco;
    @Column(name="TIPOID")
    private String tipoIdentificador;
    @Size(max=18)
    @Column(name="IDENTIFICADOR")
    private String identificador;
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String responsavelRegistro;
    @Column(name="CODIGO", insertable=false, updatable=false)
    private String codigo;
    @FilterConfig(label="Respons\u00e1vel", order=3)
    @FilterConfigSelect(query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador responsavel;
    @Column(name="SMA_ENTIDADE_AUDESP")
    private Integer codigoEntidadeAudesp;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Entidade entidade;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="divisao", fetch=FetchType.LAZY)
    private List<PermissoesPerfilDivisoes> permissoesPerfilDivisaoList;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CODIGO", referencedColumnName="DIVISAO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private DivisaoTcmgo tcmgo;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DTCRIACAO")
    private Date dataCriacao;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DTEXTINCAO")
    private Date dataExtincao;

    public Divisao() {
        this.divisaoPK = new DivisaoPK();
        this.postLoad();
    }

    @PostLoad
    public void postLoad() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
    }

    public Divisao(DivisaoPK divisaoPK) {
        this.divisaoPK = divisaoPK;
    }

    public Divisao(String entidade, String codigo) {
        this.divisaoPK = new DivisaoPK(entidade, codigo);
    }

    public DivisaoPK getDivisaoPK() {
        return this.divisaoPK;
    }

    public void setDivisaoPK(DivisaoPK divisaoPK) {
        this.divisaoPK = divisaoPK;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Endereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public IdentificadorTipo getTipoIdentificador() {
        return IdentificadorTipo.get(this.tipoIdentificador);
    }

    public void setTipoIdentificador(IdentificadorTipo identificadorTipo) {
        this.tipoIdentificador = identificadorTipo.getCodigo();
    }

    public String getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }

    public Trabalhador getResponsavel() {
        return this.responsavel;
    }

    public void setResponsavel(Trabalhador responsavel) {
        this.responsavelRegistro = responsavel != null ? responsavel.getTrabalhadorPK().getRegistro() : null;
        this.responsavel = responsavel;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.divisaoPK != null ? this.divisaoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Divisao)) {
            return false;
        }
        Divisao other = (Divisao)object;
        return (this.divisaoPK != null || other.divisaoPK == null) && (this.divisaoPK == null || this.divisaoPK.equals(other.divisaoPK));
    }

    public String toString() {
        return "entity.Divisao[ divisaoPK=" + this.divisaoPK + " ]";
    }

    public String getResponsavelRegistro() {
        return this.responsavelRegistro;
    }

    public void setResponsavelRegistro(String responsavelRegistro) {
        this.responsavelRegistro = responsavelRegistro;
    }

    public String getItemId() {
        return this.divisaoPK.getCodigo();
    }

    public String getItemLabel() {
        return this.nome;
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.hashCode());
    }

    public Integer getCodigoEntidadeAudesp() {
        return this.codigoEntidadeAudesp;
    }

    public void setCodigoEntidadeAudesp(Integer codigoEntidadeAudesp) {
        this.codigoEntidadeAudesp = codigoEntidadeAudesp;
    }

    public Entidade getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    public List<PermissoesPerfilDivisoes> getPermissoesPerfilDivisaoList() {
        return this.permissoesPerfilDivisaoList;
    }

    public void setPermissoesPerfilDivisaoList(List<PermissoesPerfilDivisoes> permissoesPerfilDivisaoList) {
        this.permissoesPerfilDivisaoList = permissoesPerfilDivisaoList;
    }

    public String getCodigo() {
        if (this.divisaoPK != null) {
            this.codigo = this.divisaoPK.getCodigo();
        }
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }
}

