/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigEnum;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.DiariaCargo;
import br.com.fiorilli.sip.persistence.entity.DiariaNacionalTipo;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="DIARIA_NACIONAL")
@Audited
public class DiariaNacional
implements Serializable,
GenericEntity {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_CARGO = "SELECT dn FROM DiariaNacional dn JOIN dn.diariaCargo dc JOIN dc.diariaCargoItemList dcl WHERE dcl.diariaCargoItemPK.cargo = :cargo AND dcl.diariaCargoItemPK.entidade = :entidade AND dn.ano = YEAR(CURRENT_DATE))";
    public static final String IF_EXISTS_BY_ANO_CARGO_TIPO = "SELECT CASE WHEN COALESCE(COUNT(dn.id), 0) > 0 THEN TRUE ELSE FALSE END FROM DiariaNacional dn WHERE dn.ano = :ano AND dn.diarioCargoId = :diarioCargoId AND dn.tipoDiaria = :tipoDiaria";
    public static final String COUNT_BY_YEAR = "SELECT COALESCE(COUNT(di.id), 0) FROM DiariaNacional di LEFT JOIN di.diariaCargo dc WHERE di.ano = :ano AND dc.entidade = :entidadeCodigo";
    public static final String FIND_BY_YEAR = "SELECT di FROM DiariaNacional di LEFT JOIN di.diariaCargo dc WHERE di.ano = :ano AND dc.entidade = :entidadeCodigo";
    @Id
    @Column(unique=true, nullable=false)
    private int id;
    @FilterConfig(label="Ano", required=true, requiredMessage="O campo Ano \u00e9 obrigat\u00f3rio")
    @Column(nullable=false, length=4)
    private String ano;
    @FilterConfig(label="Tipo Di\u00e1ria", inputType=FilterInputType.SELECT_ONE_MENU)
    @FilterConfigEnum(enumClass=DiariaNacionalTipo.class, enumId="ordinal", itemLabel="descricao")
    @Enumerated
    @Column(name="TIPO_DIARIA", nullable=false)
    private DiariaNacionalTipo tipoDiaria;
    @Column(name="VALOR")
    private double valor;
    @Column(name="DIARIA_CARGO_ID")
    private Integer diarioCargoId;
    @ManyToOne
    @JoinColumn(name="DIARIA_CARGO_ID", nullable=false, insertable=false, updatable=false)
    private DiariaCargo diariaCargo;

    public DiariaNacional withNextYear() {
        DiariaNacional diaria = new DiariaNacional();
        diaria.ano = String.valueOf(Integer.parseInt(this.ano) + 1);
        diaria.tipoDiaria = this.tipoDiaria;
        diaria.valor = this.valor;
        diaria.diarioCargoId = this.diarioCargoId;
        return diaria;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getAno() {
        return this.ano;
    }

    public void setAno(String ano) {
        this.ano = ano;
    }

    public DiariaNacionalTipo getTipoDiaria() {
        return this.tipoDiaria;
    }

    public void setTipoDiaria(DiariaNacionalTipo tipoDiaria) {
        this.tipoDiaria = tipoDiaria;
    }

    public double getValor() {
        return this.valor;
    }

    public void setValor(double valor) {
        this.valor = valor;
    }

    public DiariaCargo getDiariaCargo() {
        return this.diariaCargo;
    }

    public void setDiariaCargo(DiariaCargo diariaCargo) {
        this.diarioCargoId = diariaCargo != null ? Integer.valueOf(diariaCargo.getId()) : null;
        this.diariaCargo = diariaCargo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiariaNacional other = (DiariaNacional)obj;
        return this.id == other.id;
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.id);
    }

    public Integer getDiarioCargoId() {
        return this.diarioCargoId;
    }

    public void setDiarioCargoId(Integer diarioCargoId) {
        this.diarioCargoId = diarioCargoId;
    }
}

