/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigEnum;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.DiariaInternacional;
import br.com.fiorilli.sip.persistence.entity.DiariaInternacionalMoeda;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="DIARIA_INTERNACIONAL_ANO")
@Audited
public class DiariaInternacionalAno
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String COUNT_BY_YEAR = "SELECT COALESCE(COUNT(dia.id), 0) FROM DiariaInternacionalAno dia WHERE dia.ano = :ano AND dia.entidade = :entidadeCodigo";
    public static final String FIND_BY_YEAR = "SELECT dia FROM DiariaInternacionalAno dia JOIN FETCH dia.diariaInternacionalList WHERE dia.ano = :ano AND dia.entidade = :entidadeCodigo";
    @Id
    @Column(unique=true, nullable=false)
    private int id;
    @Column(name="EMPRESA", nullable=false, length=3)
    private String entidade;
    @FilterConfig(label="Ano", condition=FilterCondition.IGUAL, blockCondition=true, required=true, requiredMessage="O campo Ano \u00e9 obrigat\u00f3rio")
    @Column(nullable=false, length=4)
    private String ano;
    @FilterConfig(label="Descri\u00e7\u00e3o", condition=FilterCondition.COMECE)
    @Column(length=150)
    private String descricao;
    @FilterConfig(label="Moeda", condition=FilterCondition.IGUAL, inputType=FilterInputType.SELECT_ONE_MENU)
    @FilterConfigEnum(itemLabel="descricao")
    @Enumerated
    @Column(name="TIPO_MOEDA", nullable=false)
    private DiariaInternacionalMoeda tipoMoeda;
    @OneToMany(mappedBy="diariaInternacionalAno", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<DiariaInternacional> diariaInternacionalList;

    public DiariaInternacionalAno() {
        this.diariaInternacionalList = new ArrayList<DiariaInternacional>();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getAno() {
        return this.ano;
    }

    public void setAno(String ano) {
        this.ano = ano;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String empresa) {
        this.entidade = empresa;
    }

    public DiariaInternacionalMoeda getTipoMoeda() {
        return this.tipoMoeda;
    }

    public void setTipoMoeda(DiariaInternacionalMoeda tipoMoeda) {
        this.tipoMoeda = tipoMoeda;
    }

    public List<DiariaInternacional> getDiariaInternacionalList() {
        return this.diariaInternacionalList;
    }

    public void setDiariaInternacionalList(List<DiariaInternacional> diariaInternacionals) {
        this.diariaInternacionalList = diariaInternacionals;
    }

    public DiariaInternacional addDiariaInternacional(DiariaInternacional diariaInternacional) {
        this.getDiariaInternacionalList().add(diariaInternacional);
        diariaInternacional.setDiariaInternacionalAno(this);
        return diariaInternacional;
    }

    public DiariaInternacional removeDiariaInternacional(DiariaInternacional diariaInternacional) {
        this.getDiariaInternacionalList().remove(diariaInternacional);
        diariaInternacional.setDiariaInternacionalAno(null);
        return diariaInternacional;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiariaInternacionalAno other = (DiariaInternacionalAno)obj;
        return this.id == other.id;
    }

    public DiariaInternacionalAno(int id, String entidade, String ano, String descricao, DiariaInternacionalMoeda tipoMoeda) {
        this.id = id;
        this.entidade = entidade;
        this.ano = ano;
        this.descricao = descricao;
        this.tipoMoeda = tipoMoeda;
        this.diariaInternacionalList = new ArrayList<DiariaInternacional>();
    }

    public DiariaInternacionalAno withNextYear() {
        String nextAno = String.valueOf(Integer.parseInt(this.ano) + 1);
        return new DiariaInternacionalAno(this.id, this.entidade, nextAno, this.descricao, this.tipoMoeda);
    }

    public void addDiaria(DiariaInternacional di) {
        di.setDiariaInternacionalAno(this);
        this.diariaInternacionalList.add(di);
    }
}

