/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.DiariaCargo;
import br.com.fiorilli.sip.persistence.entity.DiariaInternacionalAno;
import br.com.fiorilli.sip.persistence.entity.DiariaInternacionalPais;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="DIARIA_INTERNACIONAL")
@Audited
public class DiariaInternacional
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_CARGO = "SELECT di FROM DiariaInternacional di JOIN FETCH di.diariaInternacionalAno dia JOIN FETCH di.diariaInternacionalPais dip JOIN di.diariaCargo dc JOIN dc.diariaCargoItemList dcl WHERE dcl.diariaCargoItemPK.cargo = :cargo AND dcl.diariaCargoItemPK.entidade = :entidade";
    public static final String GET_FETCHED = "SELECT di FROM DiariaInternacional di JOIN FETCH di.diariaInternacionalPais JOIN FETCH di.diariaCargo JOIN FETCH di.diariaInternacionalAno WHERE di.diariaInternacionalAno.id = :diariaInternacionalAnoId";
    public static final String GET_BY_ID = "SELECT di FROM DiariaInternacional di JOIN FETCH di.diariaInternacionalPais JOIN FETCH di.diariaCargo JOIN FETCH di.diariaInternacionalAno WHERE di.id = :id";
    @Id
    @Column(unique=true, nullable=false)
    private int id;
    private double valor;
    @Column(name="DIARIA_INTERNACIONAL_ANO_ID")
    private Integer diariaInternacionalAnoId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="DIARIA_INTERNACIONAL_ANO_ID", insertable=false, updatable=false)
    private DiariaInternacionalAno diariaInternacionalAno;
    @Column(name="DIARIA_CARGO_ID")
    private Integer diariaCargoId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="DIARIA_CARGO_ID", insertable=false, updatable=false)
    private DiariaCargo diariaCargo;
    @Column(name="DIARIA_INTERNACIONAL_PAIS_ID")
    private Integer diariaInternacionalPaisId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="DIARIA_INTERNACIONAL_PAIS_ID", insertable=false, updatable=false)
    private DiariaInternacionalPais diariaInternacionalPais;

    public DiariaInternacional() {
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public double getValor() {
        return this.valor;
    }

    public void setValor(double valor) {
        this.valor = valor;
    }

    public DiariaCargo getDiariaCargo() {
        return this.diariaCargo;
    }

    public void setDiariaCargo(DiariaCargo diariaCargo) {
        this.diariaCargoId = diariaCargo != null ? Integer.valueOf(diariaCargo.getId()) : null;
        this.diariaCargo = diariaCargo;
    }

    public DiariaInternacionalAno getDiariaInternacionalAno() {
        return this.diariaInternacionalAno;
    }

    public void setDiariaInternacionalAno(DiariaInternacionalAno diariaInternacionalAno) {
        this.diariaInternacionalAnoId = diariaInternacionalAno != null ? Integer.valueOf(diariaInternacionalAno.getId()) : null;
        this.diariaInternacionalAno = diariaInternacionalAno;
    }

    public DiariaInternacionalPais getDiariaInternacionalPais() {
        return this.diariaInternacionalPais;
    }

    public void setDiariaInternacionalPais(DiariaInternacionalPais diariaInternacionalPais) {
        this.diariaInternacionalPaisId = diariaInternacionalPais != null ? Integer.valueOf(diariaInternacionalPais.getId()) : null;
        this.diariaInternacionalPais = diariaInternacionalPais;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiariaInternacional other = (DiariaInternacional)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "DiariaInternacional [id=" + this.id + "]";
    }

    public Integer getDiariaInternacionalAnoId() {
        return this.diariaInternacionalAnoId;
    }

    public void setDiariaInternacionalAnoId(Integer diariaInternacionalAnoId) {
        this.diariaInternacionalAnoId = diariaInternacionalAnoId;
    }

    public Integer getDiariaCargoId() {
        return this.diariaCargoId;
    }

    public void setDiariaCargoId(Integer diariaCargoId) {
        this.diariaCargoId = diariaCargoId;
    }

    public Integer getDiariaInternacionalPaisId() {
        return this.diariaInternacionalPaisId;
    }

    public void setDiariaInternacionalPaisId(Integer diariaInternacionalPaisId) {
        this.diariaInternacionalPaisId = diariaInternacionalPaisId;
    }

    private DiariaInternacional(int id, double valor, Integer diariaCargoId, Integer diariaInternacionalPaisId) {
        this.id = id;
        this.valor = valor;
        this.diariaCargoId = diariaCargoId;
        this.diariaInternacionalPaisId = diariaInternacionalPaisId;
    }

    public DiariaInternacional withId(int newId) {
        return new DiariaInternacional(newId, this.valor, this.diariaCargoId, this.diariaInternacionalPaisId);
    }
}

