/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.DiariaCargo;
import br.com.fiorilli.sip.persistence.entity.DiariaCargoItemPK;
import java.io.Serializable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="DIARIA_CARGO_ITENS")
@Audited
public class DiariaCargoItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_DIARIA_CARGO_ID = "SELECT it FROM DiariaCargoItem it JOIN FETCH it.cargo WHERE it.diariaCargoItemPK.diariaCargoId = :diariaCargoId ORDER BY it.cargo.cargoPK.codigo";
    @EmbeddedId
    private DiariaCargoItemPK diariaCargoItemPK = new DiariaCargoItemPK();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="DIARIA_CARGO_ID", nullable=false, insertable=false, updatable=false)
    private DiariaCargo diariaCargo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CARGO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Cargo cargo;

    public DiariaCargoItemPK getDiariaCargoItemPK() {
        return this.diariaCargoItemPK;
    }

    public void setDiariaCargoItemPK(DiariaCargoItemPK id) {
        this.diariaCargoItemPK = id;
    }

    public DiariaCargo getDiariaCargo() {
        return this.diariaCargo;
    }

    public void setDiariaCargo(DiariaCargo diariaCargo) {
        this.diariaCargo = diariaCargo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.diariaCargoItemPK == null ? 0 : this.diariaCargoItemPK.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiariaCargoItem other = (DiariaCargoItem)obj;
        return !(this.diariaCargoItemPK == null ? other.diariaCargoItemPK != null : !this.diariaCargoItemPK.equals(other.diariaCargoItemPK));
    }

    public Cargo getCargo() {
        return this.cargo;
    }

    public void setCargo(Cargo cargo) {
        if (cargo != null) {
            this.diariaCargoItemPK.setCargo(cargo.getCargoPK().getCodigo());
            this.diariaCargoItemPK.setEntidade(cargo.getCargoPK().getEntidade());
        } else {
            this.diariaCargoItemPK.setCargo(null);
            this.diariaCargoItemPK.setEntidade(null);
        }
        this.cargo = cargo;
    }
}

