/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.DiariaCargoItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="DIARIA_CARGO")
@Audited
public class DiariaCargo
implements Serializable,
GenericEntity {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="ID", unique=true, nullable=false)
    private int id;
    @FilterConfig(label="Descri\u00e7\u00e3o", condition=FilterCondition.COMECE)
    @Column(length=150)
    private String descricao;
    @Column(name="EMPRESA", nullable=false, length=3)
    private String entidade;
    @OneToMany(mappedBy="diariaCargo", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<DiariaCargoItem> diariaCargoItemList = new ArrayList<DiariaCargoItem>();

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String empresa) {
        this.entidade = empresa;
    }

    public List<DiariaCargoItem> getDiariaCargoItemList() {
        return this.diariaCargoItemList;
    }

    public void setDiariaCargoItemList(List<DiariaCargoItem> diariaCargoItems) {
        this.diariaCargoItemList = diariaCargoItems;
    }

    public DiariaCargoItem addDiariaCargoItem(DiariaCargoItem diariaCargoItem) {
        if (!this.getDiariaCargoItemList().contains(diariaCargoItem)) {
            this.getDiariaCargoItemList().add(diariaCargoItem);
            diariaCargoItem.setDiariaCargo(this);
            return diariaCargoItem;
        }
        return null;
    }

    public DiariaCargoItem removeDiariaCargoItem(DiariaCargoItem diariaCargoItem) {
        this.getDiariaCargoItemList().remove(diariaCargoItem);
        diariaCargoItem.setDiariaCargo(null);
        return diariaCargoItem;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiariaCargo other = (DiariaCargo)obj;
        return this.id == other.id;
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.id);
    }
}

