/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.DiariaClassificacao;
import br.com.fiorilli.sip.persistence.entity.DiariaInternacional;
import br.com.fiorilli.sip.persistence.entity.DiariaInternacionalMoeda;
import br.com.fiorilli.sip.persistence.entity.DiariaPK;
import br.com.fiorilli.sip.persistence.entity.DiariaTipo;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.ReferenciaTipo;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.VeiculoPublicacao;
import br.com.fiorilli.sipweb.vo.ws.DiariaWsVo;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.Size;

@Entity
@Table(name="DIARIAS")
@Audited
public class Diaria
implements Serializable,
Documento {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_POR_ENTIDADE = "SELECT d FROM Diaria d where d.diariaPK.entidade = :entidadeId";
    public static final String GET_FETCHED = "SELECT d FROM Diaria d LEFT JOIN FETCH d.trabalhador LEFT JOIN FETCH d.solicitante LEFT JOIN FETCH d.evento LEFT JOIN FETCH d.tipoLegal LEFT JOIN FETCH d.veiculoPublicacao where d.diariaPK = :diariaPK";
    public static final String QUERY_FIND_BY_TRABALHADOR_AND_PERIOD_WS = "SELECT new " + DiariaWsVo.class.getName() + "(d.dataInicio, d.horaInicio, d.dataFim, d.horaTermino, d.tipoDiaria, d.destino, d.motivo, d.dataPagamento, d.valor)" + "FROM Diaria d " + "WHERE d.trabalhador.trabalhadorPK = :trabalhadorPK " + "\tAND d.dataInicio >= :dataInicial AND d.dataFim <= :dataFinal ";
    public static final String GENERATOR = "GEN_DIARIAS";
    @EmbeddedId
    protected DiariaPK diariaPK;
    @Column(name="TIPOLEGAL")
    private Integer tipoLegalCodigo;
    @Size(max=10)
    @Column(name="DOCUMENTO")
    private String numeroDocumento;
    @Column(name="DTDOCUMENTO")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @Column(name="DTPAGTO")
    @Temporal(value=TemporalType.DATE)
    private Date dataPagamento;
    @Column(name="DTINIC")
    @Temporal(value=TemporalType.DATE)
    private Date dataInicio;
    @Column(name="DTFIM")
    @Temporal(value=TemporalType.DATE)
    private Date dataFim;
    @Size(max=50)
    @Column(name="DESTINO")
    private String destino;
    @Size(max=100)
    @Column(name="MOTIVO")
    private String motivo;
    @Column(name="VALOR")
    private Double valor;
    @Column(name="EVENTO")
    private String eventoCodigo;
    @Column(name="VALOR_MOEDA_INTERNACIONAL")
    private Double valorMoedaInternacional;
    @Enumerated
    @Column(name="TIPO_MOEDA")
    private DiariaInternacionalMoeda tipoMoeda;
    @Column(name="TIPO_REFERENCIA")
    private String referenciaTipo;
    @Column(name="TIPO_DIARIA")
    private Integer tipoDiaria;
    @Column(name="DIARIA_NACIONAL_ID")
    private Integer diariaNacionalId;
    @Column(name="DIARIA_INTERNACIONAL_ID")
    @JoinColumn(name="DIARIAINTERNACIONAL", referencedColumnName="ID", insertable=false, updatable=false)
    private Integer diariaInternacionalId;
    @Column(name="DIARIA_CLASSIFICACAO_ID")
    private Integer diariaClassificacaoId;
    @Column(name="VEICULO_PUBLICACAO")
    private Integer veiculoPublicacaoCodigo;
    @FilterConfig(label="Trabalhador", inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @Column(name="REGISTRO_SOLICITANTE")
    private String registroSolicitante;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador solicitante;
    @FilterConfig(label="TipoDocumentoLegal", inputType=FilterInputType.AUTO_COMPLETE)
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;
    @FilterConfig(label="Evento", inputType=FilterInputType.AUTO_COMPLETE)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento evento;
    @JoinColumn(name="VEICULO_PUBLICACAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private VeiculoPublicacao veiculoPublicacao;
    @Transient
    private DiariaInternacional diariaInternacional;
    @Transient
    private DiariaClassificacao diariaClassificacao;
    @Column(name="FOLHA_PUBLICACAO")
    private Integer folhaPublicacao;
    @Column(name="DATA_PUBLICACAO")
    @Temporal(value=TemporalType.DATE)
    private Date dataPublicacao;
    @Column(name="OBS")
    private String obs;
    @Column(name="HORA_INICIO")
    private String horaInicio;
    @Column(name="HORA_TERMINO")
    private String horaTermino;

    public Diaria() {
    }

    public Diaria(DiariaPK diariaPK) {
        this.diariaPK = diariaPK;
    }

    public Diaria(String entidade, String registro, short item) {
        this.diariaPK = new DiariaPK(entidade, registro, item);
    }

    public DiariaPK getDiariaPK() {
        return this.diariaPK;
    }

    public void setDiariaPK(DiariaPK diariaPK) {
        this.diariaPK = diariaPK;
    }

    public Date getDataPagamento() {
        return this.dataPagamento;
    }

    public void setDataPagamento(Date dtpagto) {
        this.dataPagamento = dtpagto;
    }

    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String documento) {
        this.numeroDocumento = documento;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date dtdocumento) {
        this.dataDocumento = dtdocumento;
    }

    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    public String getDestino() {
        return this.destino;
    }

    public void setDestino(String destino) {
        this.destino = destino;
    }

    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dtinic) {
        this.dataInicio = dtinic;
    }

    public Date getDataFim() {
        return this.dataFim;
    }

    public void setDataFim(Date dataFim) {
        this.dataFim = dataFim;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    public void setTipoLegalCodigo(Integer tipolegal) {
        this.tipoLegalCodigo = tipolegal;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        if (evento != null) {
            this.setEventoCodigo(evento.getEventoPK().getCodigo());
        } else {
            this.setEventoCodigo(null);
        }
        this.evento = evento;
    }

    public String getEventoCodigo() {
        return this.eventoCodigo;
    }

    public void setEventoCodigo(String eventoCodigo) {
        this.eventoCodigo = eventoCodigo;
    }

    public Double getValorMoedaInternacional() {
        return this.valorMoedaInternacional;
    }

    public void setValorMoedaInternacional(Double valorMoedaInternacional) {
        this.valorMoedaInternacional = valorMoedaInternacional;
    }

    public DiariaInternacionalMoeda getTipoMoeda() {
        return this.tipoMoeda;
    }

    public void setTipoMoeda(DiariaInternacionalMoeda tipoMoeda) {
        this.tipoMoeda = tipoMoeda;
    }

    public ReferenciaTipo getReferenciaTipo() {
        return ReferenciaTipo.get(this.referenciaTipo);
    }

    public void setReferenciaTipo(ReferenciaTipo referenciaTipo) {
        this.referenciaTipo = referenciaTipo.getCodigo();
    }

    public DiariaTipo getTipoDiaria() {
        return DiariaTipo.get(this.tipoDiaria);
    }

    public void setTipoDiaria(DiariaTipo tipoDiaria) {
        this.tipoDiaria = tipoDiaria.getCodigo();
    }

    public Integer getDiariaNacionalId() {
        return this.diariaNacionalId;
    }

    public void setDiariaNacionalId(Integer diariaNacionalId) {
        this.diariaNacionalId = diariaNacionalId;
    }

    public Integer getDiariaInternacionalId() {
        return this.diariaInternacionalId;
    }

    public void setDiariaInternacionalId(Integer diariaInternacionalId) {
        this.diariaInternacionalId = diariaInternacionalId;
    }

    public Integer getDiariaClassificacaoId() {
        return this.diariaClassificacaoId;
    }

    public void setDiariaClassificacaoId(Integer diariaClassificacaoId) {
        this.diariaClassificacaoId = diariaClassificacaoId;
    }

    public VeiculoPublicacao getVeiculoPublicacao() {
        return this.veiculoPublicacao;
    }

    public void setVeiculoPublicacao(VeiculoPublicacao veiculoPublicacao) {
        if (veiculoPublicacao != null) {
            this.setVeiculoPublicacaoCodigo(veiculoPublicacao.getCodigo());
        } else {
            this.setVeiculoPublicacaoCodigo(null);
        }
        this.veiculoPublicacao = veiculoPublicacao;
    }

    public Trabalhador getSolicitante() {
        return this.solicitante;
    }

    public void setSolicitante(Trabalhador solicitante) {
        if (solicitante != null) {
            this.setRegistroSolicitante(solicitante.getTrabalhadorPK().getRegistro());
        } else {
            this.setRegistroSolicitante(null);
        }
        this.solicitante = solicitante;
    }

    public Integer getFolhaPublicacao() {
        return this.folhaPublicacao;
    }

    public void setFolhaPublicacao(Integer folhaPublicacao) {
        this.folhaPublicacao = folhaPublicacao;
    }

    public Date getDataPublicacao() {
        return this.dataPublicacao;
    }

    public void setDataPublicacao(Date dataPublicacao) {
        this.dataPublicacao = dataPublicacao;
    }

    public String getObs() {
        return this.obs;
    }

    public void setObs(String obs) {
        this.obs = obs;
    }

    public String getRegistroSolicitante() {
        return this.registroSolicitante;
    }

    public void setRegistroSolicitante(String registroSolicitante) {
        this.registroSolicitante = registroSolicitante;
    }

    public Integer getVeiculoPublicacaoCodigo() {
        return this.veiculoPublicacaoCodigo;
    }

    public void setVeiculoPublicacaoCodigo(Integer veiculoPublicacaoCodigo) {
        this.veiculoPublicacaoCodigo = veiculoPublicacaoCodigo;
    }

    public DiariaInternacional getDiariaInternacional() {
        return this.diariaInternacional;
    }

    public DiariaClassificacao getDiariaClassificacao() {
        return this.diariaClassificacao;
    }

    public void setDiariaInternacional(DiariaInternacional diariaInternacional) {
        if (diariaInternacional != null) {
            this.setDiariaInternacionalId(diariaInternacional.getId());
        } else {
            this.setDiariaInternacionalId(null);
        }
        this.diariaInternacional = diariaInternacional;
    }

    public void setDiariaClassificacao(DiariaClassificacao diariaClassificacao) {
        if (diariaClassificacao != null) {
            this.setDiariaClassificacaoId(diariaClassificacao.getDiariaClassificacaoPK().getId());
        } else {
            this.setDiariaClassificacaoId(null);
        }
        this.diariaClassificacao = diariaClassificacao;
    }

    public String getHoraInicio() {
        return this.horaInicio;
    }

    public void setHoraInicio(String horaInicio) {
        this.horaInicio = horaInicio;
    }

    public String getHoraTermino() {
        return this.horaTermino;
    }

    public void setHoraTermino(String horaTermino) {
        this.horaTermino = horaTermino;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal tipoLegal) {
        if (tipoLegal != null) {
            this.setTipoLegalCodigo(tipoLegal.getCodigo());
        } else {
            this.setTipoLegalCodigo(null);
        }
        this.tipoLegal = tipoLegal;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.getDataDocumento();
    }

    @Override
    public void setData(Date value) {
        this.setDataDocumento(value);
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.diariaPK != null ? this.diariaPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Diaria)) {
            return false;
        }
        Diaria other = (Diaria)object;
        return (this.diariaPK != null || other.diariaPK == null) && (this.diariaPK == null || this.diariaPK.equals(other.diariaPK));
    }

    public String toString() {
        return "entity.Diarias[ diariaPK=" + this.diariaPK + " ]";
    }
}

