/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigEnum;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.CertidaoNascimento;
import br.com.fiorilli.sip.persistence.entity.DependenteMotivoFim;
import br.com.fiorilli.sip.persistence.entity.DependenteMotivoInicio;
import br.com.fiorilli.sip.persistence.entity.DependentePK;
import br.com.fiorilli.sip.persistence.entity.Endereco;
import br.com.fiorilli.sip.persistence.entity.EstadoCivil;
import br.com.fiorilli.sip.persistence.entity.Parentesco;
import br.com.fiorilli.sip.persistence.entity.Sexo;
import br.com.fiorilli.sip.persistence.entity.SiprevTipoDependencia;
import br.com.fiorilli.sip.persistence.entity.TelefoneFixo;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.UF;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="DEPENDENTES")
@Audited
public class Dependente
implements Serializable,
Documento {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_TRABALHADOR = "SELECT de FROM Dependente de LEFT JOIN FETCH de.tipoDocumento WHERE de.trabalhador.trabalhadorPK = :trabalhadorPK";
    public static final String FIND_MAX_ITEM = "SELECT COALESCE(MAX(de.dependentePK.item), 0) FROM Dependente de WHERE de.trabalhador.trabalhadorPK = :trabalhadorPK";
    @EmbeddedId
    protected DependentePK dependentePK;
    @FilterConfig(label="Nome", condition=FilterCondition.COMECE)
    @Size(max=120)
    @Column(name="NOME")
    private String nome;
    @Column(name="DTNASC")
    @Temporal(value=TemporalType.DATE)
    private Date dataNascimento;
    @Size(max=30)
    @Column(name="LOCALNASC")
    private String localNascimento;
    @Type(type="BooleanTypeSip")
    @Column(name="IRRF")
    private Boolean irrf;
    @Type(type="BooleanTypeSip")
    @Column(name="DEFICIENTE")
    private Boolean deficiente;
    @Size(max=11)
    @Column(name="CPF")
    private String cpf;
    @Size(max=15)
    @Column(name="RG")
    private String rg;
    @Size(max=10)
    @Column(name="ORGAOESPUF")
    private String orgaoExpedidorUf;
    @Column(name="ESTADOCIVIL")
    private Character estadoCivil;
    @Size(max=120)
    @Column(name="NOMEMAE")
    private String nomeMae;
    @Column(name="DTOBITO")
    @Temporal(value=TemporalType.DATE)
    private Date dataObito;
    @Column(name="DTINICIO")
    @Temporal(value=TemporalType.DATE)
    private Date dataInicio;
    @Column(name="DTFIM")
    @Temporal(value=TemporalType.DATE)
    private Date dataFim;
    @Embedded
    private Endereco endereco;
    @Embedded
    private TelefoneFixo telefone;
    @Size(max=60)
    @Column(name="EMAIL")
    private String email;
    @Size(max=6)
    @Column(name="MATRICULAPENCIONISTA")
    private String matriculaPencionista;
    @Column(name="DTREGISPENCIONISTA")
    @Temporal(value=TemporalType.DATE)
    private Date dataRegistroPencionista;
    @Size(max=7)
    @Column(name="MUNICIPIOSIPREV")
    private String municipioSipRev;
    @Type(type="BooleanTypeSip")
    @Column(name="AUXILIO_EDUCACAO")
    private Boolean auxilioEducacao;
    @Column(name="INI_AUXILIO_EDUCACAO")
    @Temporal(value=TemporalType.DATE)
    private Date dataInicioAuxilioEducacao;
    @Column(name="LIMITE_AUXILIO_EDUCACAO")
    private Short limiteAuxilioEducacao;
    @Column(name="AUXILIO_ESPOSA")
    @Type(type="BooleanTypeSip")
    private Boolean auxilioEsposa;
    @Column(name="INI_AUXILIO_ESPOSA")
    @Temporal(value=TemporalType.DATE)
    private Date dataInicioAuxilioEsposa;
    @Column(name="FIM_AUXILIO_EDUCACAO")
    @Temporal(value=TemporalType.DATE)
    private Date dataFimAuxilioEducacao;
    @Column(name="FIM_AUXILIO_ESPOSA")
    @Temporal(value=TemporalType.DATE)
    private Date dataFimAuxilioEsposa;
    @Type(type="BooleanTypeSip")
    @Column(name="UNIVERSITARIO")
    private Boolean universitario;
    @Column(name="TIPODOC")
    private Integer tipoDocumentoCodigo;
    @JoinColumn(name="TIPODOC", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoDocumento;
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @Size(max=60)
    @Column(name="OBS")
    private String observacao;
    @Type(type="BooleanTypeSip")
    @Column(name="SALFAMILIA")
    private Boolean salarioFamilia;
    @Column(name="INI_IRRF")
    @Temporal(value=TemporalType.DATE)
    private Date dataInicioIrrf;
    @Column(name="FIM_IRRF")
    @Temporal(value=TemporalType.DATE)
    private Date dataFimIrrf;
    @Column(name="INI_SALFAM")
    @Temporal(value=TemporalType.DATE)
    private Date dataIncioSalarioFamilia;
    @Column(name="FIM_SALFAM")
    @Temporal(value=TemporalType.DATE)
    private Date dataFimSalarioFamilia;
    @Size(max=16)
    @Column(name="NUMDOC")
    private String numeroDocumento;
    @Enumerated(value=EnumType.STRING)
    @Column(name="LOCALNASCUF")
    private UF localNacimentoUf;
    @Column(name="DH_REGISTRO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataRegistro;
    @Column(name="ID_CADUNICO")
    private Double cadastroUnicoId;
    @Column(name="IDADE", insertable=false, updatable=false)
    private Short idade;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @FilterConfig(label="Parentesco", inputType=FilterInputType.SELECT_ONE_MENU)
    @FilterConfigEnum(enumClass=Parentesco.class, enumId="codigo", itemLabel="descricao")
    @Column(name="PARENTESCO")
    private String parentesco;
    @Column(name="MOTIVOINISIPREV")
    private String motivoInicio;
    @Column(name="MOTIVOFIMSIPREV")
    private String motivoFim;
    @Enumerated(value=EnumType.STRING)
    @Column(name="SEXO")
    private Sexo sexo;
    @Embedded
    private CertidaoNascimento certidaoNascimento;
    @JoinColumns(value={@JoinColumn(name="PARENTESCO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private SiprevTipoDependencia siprevTipoDependencia;

    @PostLoad
    public void postLoad() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
        if (this.certidaoNascimento == null) {
            this.certidaoNascimento = new CertidaoNascimento();
        }
        if (this.telefone == null) {
            this.telefone = new TelefoneFixo();
        }
    }

    public Dependente() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
        if (this.certidaoNascimento == null) {
            this.certidaoNascimento = new CertidaoNascimento();
        }
        if (this.telefone == null) {
            this.telefone = new TelefoneFixo();
        }
    }

    public Dependente(DependentePK dependentePK) {
        this.dependentePK = dependentePK;
    }

    public Dependente(String entidade, String registro, short item) {
        this.dependentePK = new DependentePK(entidade, registro, item);
    }

    public DependentePK getDependentesPK() {
        if (this.dependentePK == null) {
            this.dependentePK = new DependentePK();
        }
        return this.dependentePK;
    }

    public void setDependentesPK(DependentePK dependentePK) {
        this.dependentePK = dependentePK;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Date getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(Date dtnasc) {
        this.dataNascimento = dtnasc;
    }

    public String getLocalNascimento() {
        return this.localNascimento;
    }

    public void setLocalNascimento(String localnasc) {
        this.localNascimento = localnasc;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public String getRg() {
        return this.rg;
    }

    public void setRg(String rg) {
        this.rg = rg;
    }

    public String getOrgaoExpedidorUf() {
        return this.orgaoExpedidorUf;
    }

    public void setOrgaoExpedidorUf(String orgaoespuf) {
        this.orgaoExpedidorUf = orgaoespuf;
    }

    public EstadoCivil getEstadoCivil() {
        return EstadoCivil.of(this.estadoCivil);
    }

    public void setEstadoCivil(EstadoCivil estadoCivil) {
        this.estadoCivil = estadoCivil.getCodigo();
    }

    public String getNomeMae() {
        return this.nomeMae;
    }

    public void setNomeMae(String nomemae) {
        this.nomeMae = nomemae;
    }

    public Date getDataObito() {
        return this.dataObito;
    }

    public void setDataObito(Date dtobito) {
        this.dataObito = dtobito;
    }

    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dtinicio) {
        this.dataInicio = dtinicio;
    }

    public Date getDataFim() {
        return this.dataFim;
    }

    public void setDataFim(Date dataFim) {
        this.dataFim = dataFim;
    }

    public Endereco getEndereco() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public String getMatriculaPencionista() {
        return this.matriculaPencionista;
    }

    public void setMatriculaPencionista(String matriculapencionista) {
        this.matriculaPencionista = matriculapencionista;
    }

    public Date getDataRegistroPencionista() {
        return this.dataRegistroPencionista;
    }

    public void setDataRegistroPencionista(Date dtregispencionista) {
        this.dataRegistroPencionista = dtregispencionista;
    }

    public String getMunicipioSipRev() {
        return this.municipioSipRev;
    }

    public void setMunicipioSipRev(String municipiosiprev) {
        this.municipioSipRev = municipiosiprev;
    }

    public Date getDataInicioAuxilioEducacao() {
        return this.dataInicioAuxilioEducacao;
    }

    public void setDataInicioAuxilioEducacao(Date iniAuxilioEducacao) {
        this.dataInicioAuxilioEducacao = iniAuxilioEducacao;
    }

    public Short getLimiteAuxilioEducacao() {
        return this.limiteAuxilioEducacao;
    }

    public void setLimiteAuxilioEducacao(Short limiteAuxilioEducacao) {
        this.limiteAuxilioEducacao = limiteAuxilioEducacao;
    }

    public Date getDataInicioAuxilioEsposa() {
        return this.dataInicioAuxilioEsposa;
    }

    public void setDataInicioAuxilioEsposa(Date iniAuxilioEsposa) {
        this.dataInicioAuxilioEsposa = iniAuxilioEsposa;
    }

    public Date getDataFimAuxilioEducacao() {
        return this.dataFimAuxilioEducacao;
    }

    public void setDataFimAuxilioEducacao(Date fimAuxilioEducacao) {
        this.dataFimAuxilioEducacao = fimAuxilioEducacao;
    }

    public Date getDataFimAuxilioEsposa() {
        return this.dataFimAuxilioEsposa;
    }

    public void setDataFimAuxilioEsposa(Date fimAuxilioEsposa) {
        this.dataFimAuxilioEsposa = fimAuxilioEsposa;
    }

    public Integer getTipoDocumentoCodigo() {
        return this.tipoDocumentoCodigo;
    }

    public void setTipoDocumentoCodigo(Integer tipoDocumentoCodigo) {
        this.tipoDocumentoCodigo = tipoDocumentoCodigo;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date datadoc) {
        this.dataDocumento = datadoc;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String obs) {
        this.observacao = obs;
    }

    public Date getDataInicioIrrf() {
        return this.dataInicioIrrf;
    }

    public void setDataInicioIrrf(Date iniIrrf) {
        this.dataInicioIrrf = iniIrrf;
    }

    public Date getDataFimIrrf() {
        return this.dataFimIrrf;
    }

    public void setDataFimIrrf(Date fimIrrf) {
        this.dataFimIrrf = fimIrrf;
    }

    public Date getDataIncioSalarioFamilia() {
        return this.dataIncioSalarioFamilia;
    }

    public void setDataIncioSalarioFamilia(Date iniSalfam) {
        this.dataIncioSalarioFamilia = iniSalfam;
    }

    public Date getDataFimSalarioFamilia() {
        return this.dataFimSalarioFamilia;
    }

    public void setDataFimSalarioFamilia(Date fimSalfam) {
        this.dataFimSalarioFamilia = fimSalfam;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String numdoc) {
        this.numeroDocumento = numdoc;
    }

    public Date getDataRegistro() {
        return this.dataRegistro;
    }

    public void setDataRegistro(Date dhRegistro) {
        this.dataRegistro = dhRegistro;
    }

    public Double getCadastroUnicoId() {
        return this.cadastroUnicoId;
    }

    public void setCadastroUnicoId(Double idCadunico) {
        this.cadastroUnicoId = idCadunico;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
        if (trabalhador != null) {
            this.dependentePK.setEntidade(trabalhador.getTrabalhadorPK().getEntidade());
            this.dependentePK.setRegistro(trabalhador.getTrabalhadorPK().getRegistro());
        } else {
            this.dependentePK.setEntidade(null);
            this.dependentePK.setRegistro(null);
        }
    }

    public Sexo getSexo() {
        return this.sexo;
    }

    public void setSexo(Sexo sexo) {
        this.sexo = sexo;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.dependentePK != null ? this.dependentePK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Dependente)) {
            return false;
        }
        Dependente other = (Dependente)object;
        return (this.dependentePK != null || other.dependentePK == null) && (this.dependentePK == null || this.dependentePK.equals(other.dependentePK));
    }

    public String toString() {
        return "entity.Dependente[ dependentePK=" + this.dependentePK + " ]";
    }

    public Parentesco getParentesco() {
        return Parentesco.of(this.parentesco);
    }

    public void setParentesco(Parentesco parentesco) {
        this.parentesco = parentesco.getCodigo();
    }

    public Boolean getDeficiente() {
        return this.deficiente;
    }

    public void setDeficiente(Boolean deficiente) {
        this.deficiente = deficiente;
    }

    public CertidaoNascimento getCertidaoNascimento() {
        if (this.certidaoNascimento == null) {
            this.certidaoNascimento = new CertidaoNascimento();
        }
        return this.certidaoNascimento;
    }

    public void setCertidaoNascimento(CertidaoNascimento certidaoNascimento) {
        this.certidaoNascimento = certidaoNascimento;
    }

    public Boolean getIrrf() {
        return this.irrf;
    }

    public void setIrrf(Boolean irrf) {
        this.irrf = irrf;
    }

    public TelefoneFixo getTelefone() {
        if (this.telefone == null) {
            this.telefone = new TelefoneFixo();
        }
        return this.telefone;
    }

    public void setTelefone(TelefoneFixo telefone) {
        this.telefone = telefone;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Boolean getAuxilioEducacao() {
        return this.auxilioEducacao;
    }

    public void setAuxilioEducacao(Boolean auxilioEducacao) {
        this.auxilioEducacao = auxilioEducacao;
    }

    public Boolean getAuxilioEsposa() {
        return this.auxilioEsposa;
    }

    public void setAuxilioEsposa(Boolean auxilioEsposa) {
        this.auxilioEsposa = auxilioEsposa;
    }

    public Boolean getUniversitario() {
        return this.universitario;
    }

    public void setUniversitario(Boolean universitario) {
        this.universitario = universitario;
    }

    public Boolean getSalarioFamilia() {
        return this.salarioFamilia;
    }

    public void setSalarioFamilia(Boolean salarioFamilia) {
        this.salarioFamilia = salarioFamilia;
    }

    public UF getLocalNacimentoUf() {
        return this.localNacimentoUf;
    }

    public void setLocalNacimentoUf(UF localNacimentoUf) {
        this.localNacimentoUf = localNacimentoUf;
    }

    public DependenteMotivoInicio getMotivoInicio() {
        return DependenteMotivoInicio.get(this.motivoInicio);
    }

    public void setMotivoInicio(DependenteMotivoInicio motivoInicio) {
        this.motivoInicio = motivoInicio.getCodigo();
    }

    public DependenteMotivoFim getMotivoFim() {
        return DependenteMotivoFim.get(this.motivoFim);
    }

    public void setMotivoFim(DependenteMotivoFim motivoFimSiprev) {
        this.motivoFim = motivoFimSiprev.getCodigo();
    }

    public SiprevTipoDependencia getSiprevTipoDependencia() {
        return this.siprevTipoDependencia;
    }

    public void setSiprevTipoDependencia(SiprevTipoDependencia siprevTipoDependencia) {
        this.siprevTipoDependencia = siprevTipoDependencia;
        this.parentesco = siprevTipoDependencia != null ? siprevTipoDependencia.getCodigo() : null;
    }

    public Short getIdade() {
        return this.idade;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoDocumento != null ? this.tipoDocumento.getCodigo() : null;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.getDataDocumento();
    }

    @Override
    public void setData(Date value) {
        this.setDataDocumento(value);
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoDocumento;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal tipoDocumento) {
        this.tipoDocumentoCodigo = tipoDocumento != null ? tipoDocumento.getCodigo() : null;
        this.tipoDocumento = tipoDocumento;
    }
}

