/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Curso;
import br.com.fiorilli.sip.persistence.entity.Pessoa;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;

@Entity
@Table(name="TRABCURRICULO_CURSO_EXTRA")
@Audited
public class CursoExtraCurricular
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_CPF = "SELECT c FROM CursoExtraCurricular c WHERE c.cpf = :cpf ORDER BY c.dataConclusao DESC";
    public static final String GENERATOR = "GEN_TRABCURRICULO_CURSO_EXTRA";
    @Id
    private int id;
    @JoinColumn(name="CPF", referencedColumnName="CPF", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Pessoa pessoa;
    @Size(max=11)
    @Column(name="CPF")
    private String cpf;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CONCLUSAO")
    private Date dataConclusao;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DT_ENTREGA_CERTIFICADO")
    private Date dataEntregaCertificado;
    @Column(name="CARGA_HORARIA", nullable=false)
    private Integer cargaHoraria;
    @FilterConfig(label="Curso", condition=FilterCondition.COMECE)
    @Column(name="CURSO", nullable=false, length=256)
    private String curso;
    @FilterConfig(label="Institui\u00e7\u00e3o", condition=FilterCondition.COMECE)
    @Column(name="INSTITUICAO", nullable=false, length=60)
    private String instituicao;
    @Size(max=512)
    @Column(name="OBS")
    private String observacao;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CURSO", referencedColumnName="ID_CURSO", insertable=false, updatable=false)
    private Curso cursoInstituicao;

    public Integer getCargaHoraria() {
        return this.cargaHoraria;
    }

    public void setCargaHoraria(Integer cargaHoraria) {
        this.cargaHoraria = cargaHoraria;
    }

    public String getCurso() {
        return this.curso;
    }

    public void setCurso(String curso) {
        this.curso = curso;
    }

    public String getInstituicao() {
        return this.instituicao;
    }

    public void setInstituicao(String nomeInstituicao) {
        this.instituicao = nomeInstituicao;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public Date getDataConclusao() {
        return this.dataConclusao;
    }

    public void setDataConclusao(Date dataConclusao) {
        this.dataConclusao = dataConclusao;
    }

    public Curso getCursoInstituicao() {
        return this.cursoInstituicao;
    }

    public void setCursoInstituicao(Curso cursoInstituicao) {
        this.cursoInstituicao = cursoInstituicao;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CursoExtraCurricular other = (CursoExtraCurricular)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "CursoExtraCurricular [id=" + this.id + "]";
    }

    public Date getDataEntregaCertificado() {
        return this.dataEntregaCertificado;
    }

    public void setDataEntregaCertificado(Date dataEntregaCertificado) {
        this.dataEntregaCertificado = dataEntregaCertificado;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }
}

