/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Curriculo;
import br.com.fiorilli.sip.persistence.entity.Idioma;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SIPCURRICULO_IDIOMAS")
@Audited
public class CurriculoIdioma
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GET_NEXT_CODIGO = "SELECT COALESCE(MAX(c.codigo), 0) + 1 FROM CurriculoIdioma c";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Type(type="BooleanTypeSip")
    @Column(name="LE")
    private Boolean le;
    @Type(type="BooleanTypeSip")
    @Column(name="ESCREVE")
    private Boolean escreve;
    @Type(type="BooleanTypeSip")
    @Column(name="FALA")
    private Boolean fala;
    @Type(type="BooleanTypeSip")
    @Column(name="ENTENDE")
    private Boolean entende;
    @Column(name="IDIOMA")
    private Integer idioma;
    @Column(name="CPF")
    private String cpf;
    @JoinColumn(name="CPF", referencedColumnName="CPF", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Curriculo curriculo;

    public CurriculoIdioma() {
    }

    public CurriculoIdioma(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public Boolean getLe() {
        return this.le;
    }

    public void setLe(Boolean le) {
        this.le = le;
    }

    public Boolean getEscreve() {
        return this.escreve;
    }

    public void setEscreve(Boolean escreve) {
        this.escreve = escreve;
    }

    public Boolean getFala() {
        return this.fala;
    }

    public void setFala(Boolean fala) {
        this.fala = fala;
    }

    public Boolean getEntende() {
        return this.entende;
    }

    public void setEntende(Boolean entende) {
        this.entende = entende;
    }

    public Idioma getIdioma() {
        return Idioma.get(this.idioma);
    }

    public void setIdioma(Idioma idioma) {
        this.idioma = idioma != null ? Integer.valueOf(idioma.getCodigo()) : null;
    }

    public Curriculo getCurriculo() {
        return this.curriculo;
    }

    public void setCurriculo(Curriculo cpf) {
        this.curriculo = cpf;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CurriculoIdioma)) {
            return false;
        }
        CurriculoIdioma other = (CurriculoIdioma)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.CurriculoIdiomas[ codigo=" + this.codigo + " ]";
    }
}

