/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.CboOcupacao;
import br.com.fiorilli.sip.persistence.entity.Curriculo;
import br.com.fiorilli.sip.persistence.entity.CurriculoSegmento;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SIPCURRICULO_EXP_PROFISSIONAL")
@Audited
public class CurriculoExperienciaProfissional
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GET_NEXT_CODIGO = "SELECT COALESCE(MAX(c.codigo), 0) + 1 FROM CurriculoExperienciaProfissional c";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Size(max=60)
    @Column(name="RAZAO_SOCIAL")
    private String razaoSocial;
    @Size(max=60)
    @Column(name="FUNCAO")
    private String funcao;
    @Type(type="BooleanTypeSip")
    @Column(name="ESTAGIO")
    private Boolean estagio;
    @Basic(optional=false)
    @NotNull
    @Column(name="DATAINICIO")
    @Temporal(value=TemporalType.DATE)
    private Date dataInicio;
    @Column(name="DATAFIM")
    @Temporal(value=TemporalType.DATE)
    private Date dataFim;
    @JoinColumn(name="SEGMENTO")
    private Integer segmento;
    @Column(name="CPF")
    private String cpf;
    @JoinColumn(name="CPF", referencedColumnName="CPF", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Curriculo curriculo;
    @JoinColumn(name="CARGO", referencedColumnName="COD_INT_OCUP")
    @ManyToOne(fetch=FetchType.LAZY)
    private CboOcupacao cboOcupacao;

    public CurriculoExperienciaProfissional() {
    }

    public CurriculoExperienciaProfissional(Integer codigo) {
        this.codigo = codigo;
    }

    public CurriculoExperienciaProfissional(Integer codigo, Date datainicio) {
        this.codigo = codigo;
        this.dataInicio = datainicio;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public void setRazaoSocial(String razaoSocial) {
        this.razaoSocial = razaoSocial;
    }

    public String getFuncao() {
        return this.funcao;
    }

    public void setFuncao(String funcao) {
        this.funcao = funcao;
    }

    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date datainicio) {
        this.dataInicio = datainicio;
    }

    public Date getDataFim() {
        return this.dataFim;
    }

    public void setDataFim(Date datafim) {
        this.dataFim = datafim;
    }

    public CurriculoSegmento getSegmento() {
        return CurriculoSegmento.get(this.segmento);
    }

    public void setSegmento(CurriculoSegmento segmento) {
        this.segmento = segmento != null ? Integer.valueOf(segmento.getCodigo()) : null;
    }

    public Curriculo getCurriculo() {
        return this.curriculo;
    }

    public void setCurriculo(Curriculo cpf) {
        this.curriculo = cpf;
    }

    public CboOcupacao getCboOcupacao() {
        return this.cboOcupacao;
    }

    public void setCboOcupacao(CboOcupacao cargo) {
        this.cboOcupacao = cargo;
    }

    public Boolean getEstagio() {
        return this.estagio;
    }

    public void setEstagio(Boolean estagio) {
        this.estagio = estagio;
    }

    public void setSegmento(Integer segmento) {
        this.segmento = segmento;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CurriculoExperienciaProfissional)) {
            return false;
        }
        CurriculoExperienciaProfissional other = (CurriculoExperienciaProfissional)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.CurriculoExperienciaProfissional[ codigo=" + this.codigo + " ]";
    }
}

