/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Curriculo;
import br.com.fiorilli.sip.persistence.entity.CurriculoEnsinoBasicoInstrucao;
import br.com.fiorilli.sip.persistence.entity.EnsinoSituacao;
import br.com.fiorilli.sip.persistence.entity.Pais;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="SIPCURRICULO_ENS_BASICO")
@Audited
public class CurriculoEnsinoBasico
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GET_NEXT_CODIGO = "SELECT COALESCE(MAX(c.codigo), 0) + 1 FROM CurriculoEnsinoBasico c";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Column(name="INSTRUCAO")
    private String instrucao;
    @Size(max=30)
    @Column(name="CIDADE")
    private String cidade;
    @Size(max=2)
    @Column(name="UF")
    private String uf;
    @Size(max=60)
    @Column(name="NOME_INSTITUICAO")
    private String nomeInstituicao;
    @Column(name="SITUACAO")
    private Integer situacao;
    @JoinColumn(name="PAIS_ORIGEM", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Pais paisOrigem;
    @Column(name="CPF")
    private String cpf;
    @JoinColumn(name="CPF", referencedColumnName="CPF", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Curriculo curriculo;

    public CurriculoEnsinoBasico() {
    }

    public CurriculoEnsinoBasico(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public CurriculoEnsinoBasicoInstrucao getInstrucao() {
        return CurriculoEnsinoBasicoInstrucao.get(this.instrucao);
    }

    public void setInstrucao(CurriculoEnsinoBasicoInstrucao instrucao) {
        this.instrucao = instrucao != null ? instrucao.getCodigo() : null;
    }

    public String getCidade() {
        return this.cidade;
    }

    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    public String getUf() {
        return this.uf;
    }

    public void setUf(String uf) {
        this.uf = uf;
    }

    public String getNomeInstituicao() {
        return this.nomeInstituicao;
    }

    public void setNomeInstituicao(String nomeInstituicao) {
        this.nomeInstituicao = nomeInstituicao;
    }

    public EnsinoSituacao getSituacao() {
        return EnsinoSituacao.get(this.situacao);
    }

    public void setSituacao(EnsinoSituacao situacao) {
        this.situacao = situacao != null ? Integer.valueOf(situacao.getCodigo()) : null;
    }

    public Pais getPaisOrigem() {
        return this.paisOrigem;
    }

    public void setPaisOrigem(Pais paisOrigem) {
        this.paisOrigem = paisOrigem;
    }

    public Curriculo getCurriculo() {
        return this.curriculo;
    }

    public void setCurriculo(Curriculo cpf) {
        this.curriculo = cpf;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CurriculoEnsinoBasico)) {
            return false;
        }
        CurriculoEnsinoBasico other = (CurriculoEnsinoBasico)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.CurriculoEnsinoBasico[ codigo=" + this.codigo + " ]";
    }
}

