/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.CurriculoContatoTipo;
import br.com.fiorilli.sip.persistence.entity.CurriculoCursoExtra;
import br.com.fiorilli.sip.persistence.entity.CurriculoEnsinoBasico;
import br.com.fiorilli.sip.persistence.entity.CurriculoEnsinoProfissionalizante;
import br.com.fiorilli.sip.persistence.entity.CurriculoEnsinoSuperior;
import br.com.fiorilli.sip.persistence.entity.CurriculoExperienciaProfissional;
import br.com.fiorilli.sip.persistence.entity.CurriculoIdioma;
import br.com.fiorilli.sip.persistence.entity.CurriculoMercadoTrababalhoArea;
import br.com.fiorilli.sip.persistence.entity.CurriculoMercadoTrabalhoSituacao;
import br.com.fiorilli.sip.persistence.entity.CurriculoPerfil;
import br.com.fiorilli.sip.persistence.entity.CurriculoPosicaoFamiliar;
import br.com.fiorilli.sip.persistence.entity.CurriculoSegmento;
import br.com.fiorilli.sip.persistence.entity.DeficienciaRais;
import br.com.fiorilli.sip.persistence.entity.Endereco;
import br.com.fiorilli.sip.persistence.entity.Sexo;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SIPCURRICULO")
@Audited
public class Curriculo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FilterConfig(label="CPF")
    @Id
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=11)
    @Column(name="CPF")
    private String cpf;
    @FilterConfig(label="Nome")
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Column(name="ESTADOCIVIL")
    private Character estadoCivil;
    @FilterConfig(label="Data Nascimento", inputType=FilterInputType.CALENDAR, condition=FilterCondition.INTERVALO)
    @Column(name="DTNASC")
    @Temporal(value=TemporalType.DATE)
    private Date dataNascimento;
    @Column(name="QTDE_PESSOAS_CASA")
    private Integer qtdePessoasCasa;
    @Column(name="POSICAO_FAMILIAR")
    private Integer posicaoFamiliar;
    @Type(type="BooleanTypeSip")
    @Column(name="TRABALHOU_CONTAPROPRIA")
    private Boolean trabalhouContaPropria;
    @Size(max=60)
    @Column(name="RAMO_TRABALHO_OUTROS")
    private String ramoTrabalhoOutros;
    @Size(max=60)
    @Column(name="NOMEMAE")
    private String nomeMae;
    @Size(max=60)
    @Column(name="NOMEPAI")
    private String nomePai;
    @Size(max=11)
    @Column(name="TELEFONE")
    private String telefone;
    @Size(max=11)
    @Column(name="CELULAR")
    private String celular;
    @Size(max=11)
    @Column(name="RECADO")
    private String recado;
    @Size(max=60)
    @Column(name="EMAIL")
    private String email;
    @Column(name="CONTATO_POR")
    private Integer contatoPor;
    @Embedded
    private Endereco endereco;
    @Size(max=15)
    @Column(name="RG")
    private String rg;
    @Size(max=6)
    @Column(name="ORGAOESPUF")
    private String orgaoespuf;
    @Column(name="PERFIL")
    private Integer perfil;
    @Type(type="BooleanTypeSip")
    @Column(name="DEFICIENTE")
    private Boolean deficiente;
    @Enumerated
    @Column(name="TIPODEFICIENCIA")
    private DeficienciaRais tipoDeficiencia;
    @Type(type="BooleanTypeSip")
    @Column(name="DISPONIVEL_VIAJAR")
    private Boolean disponivelViajar;
    @Size(max=1024)
    @Column(name="QUALIF_PROFISSIONAL")
    private String qualificacaoProfissional;
    @Column(name="SEGMENTO")
    private Integer segmento;
    @Column(name="SITUACAO_MERCADOTRAB")
    private Integer mercadoTrabalhoSituacao;
    @Column(name="RAMO_TRABALHO")
    private Integer ramoTrabalho;
    @Column(name="SEXO")
    @Enumerated(value=EnumType.STRING)
    private Sexo sexo;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="curriculo", fetch=FetchType.LAZY)
    private List<CurriculoEnsinoBasico> ensinoBasicoList;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="curriculo", fetch=FetchType.LAZY)
    private List<CurriculoExperienciaProfissional> experienciaProfissionalList;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="curriculo", fetch=FetchType.LAZY)
    private List<CurriculoEnsinoSuperior> ensinoSuperiorList;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="curriculo", fetch=FetchType.LAZY)
    private List<CurriculoEnsinoProfissionalizante> ensinoProfissionalizanteList;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="curriculo", fetch=FetchType.LAZY)
    private List<CurriculoIdioma> idiomaList;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="curriculo", fetch=FetchType.LAZY)
    private List<CurriculoCursoExtra> cursoExtraList;

    public Curriculo() {
    }

    public Curriculo(String cpf) {
        this.cpf = cpf;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Character getEstadoCivil() {
        return this.estadoCivil;
    }

    public void setEstadoCivil(Character estadocivil) {
        this.estadoCivil = estadocivil;
    }

    public Date getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(Date dtnasc) {
        this.dataNascimento = dtnasc;
    }

    public Integer getQtdePessoasCasa() {
        return this.qtdePessoasCasa;
    }

    public void setQtdePessoasCasa(Integer qtdePessoasCasa) {
        this.qtdePessoasCasa = qtdePessoasCasa;
    }

    public CurriculoPosicaoFamiliar getPosicaoFamiliar() {
        return CurriculoPosicaoFamiliar.get(this.posicaoFamiliar);
    }

    public void setPosicaoFamiliar(CurriculoPosicaoFamiliar posicaoFamiliar) {
        this.posicaoFamiliar = posicaoFamiliar.getCodigo();
    }

    public String getRamoTrabalhoOutros() {
        return this.ramoTrabalhoOutros;
    }

    public void setRamoTrabalhoOutros(String ramoTrabalhoOutros) {
        this.ramoTrabalhoOutros = ramoTrabalhoOutros;
    }

    public String getNomeMae() {
        return this.nomeMae;
    }

    public void setNomeMae(String nomemae) {
        this.nomeMae = nomemae;
    }

    public String getNomePai() {
        return this.nomePai;
    }

    public void setNomePai(String nomepai) {
        this.nomePai = nomepai;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    public String getCelular() {
        return this.celular;
    }

    public void setCelular(String celular) {
        this.celular = celular;
    }

    public String getRecado() {
        return this.recado;
    }

    public void setRecado(String recado) {
        this.recado = recado;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public CurriculoContatoTipo getContatoPor() {
        return CurriculoContatoTipo.get(this.contatoPor);
    }

    public void setContatoPor(CurriculoContatoTipo contatoPor) {
        this.contatoPor = contatoPor != null ? Integer.valueOf(contatoPor.getCodigo()) : null;
    }

    public Endereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public String getRg() {
        return this.rg;
    }

    public void setRg(String rg) {
        this.rg = rg;
    }

    public String getOrgaoespuf() {
        return this.orgaoespuf;
    }

    public void setOrgaoespuf(String orgaoespuf) {
        this.orgaoespuf = orgaoespuf;
    }

    public CurriculoPerfil getPerfil() {
        return CurriculoPerfil.get(this.perfil);
    }

    public void setPerfil(CurriculoPerfil perfil) {
        this.perfil = perfil.getCodigo();
    }

    public DeficienciaRais getTipoDeficiencia() {
        return this.tipoDeficiencia;
    }

    public void setTipoDeficiencia(DeficienciaRais tipodeficiencia) {
        this.tipoDeficiencia = tipodeficiencia;
    }

    public Boolean getTrabalhouContaPropria() {
        return this.trabalhouContaPropria;
    }

    public void setTrabalhouContaPropria(Boolean trabalhouContapropria) {
        this.trabalhouContaPropria = trabalhouContapropria;
    }

    public Boolean getDeficiente() {
        return this.deficiente;
    }

    public void setDeficiente(Boolean deficiente) {
        this.deficiente = deficiente;
    }

    public Boolean getDisponivelViajar() {
        return this.disponivelViajar;
    }

    public void setDisponivelViajar(Boolean disponivelViajar) {
        this.disponivelViajar = disponivelViajar;
    }

    public String getQualificacaoProfissional() {
        return this.qualificacaoProfissional;
    }

    public void setQualificacaoProfissional(String qualifProfissional) {
        this.qualificacaoProfissional = qualifProfissional;
    }

    public List<CurriculoEnsinoSuperior> getEnsinoSuperiorList() {
        return this.ensinoSuperiorList;
    }

    public void setEnsinoSuperiorList(List<CurriculoEnsinoSuperior> sipcurriculoEnsSuperiorList) {
        this.ensinoSuperiorList = sipcurriculoEnsSuperiorList;
    }

    public List<CurriculoExperienciaProfissional> getExperienciaProfissionalList() {
        return this.experienciaProfissionalList;
    }

    public void setExperienciaProfissionalList(List<CurriculoExperienciaProfissional> sipcurriculoExpProfissionalList) {
        this.experienciaProfissionalList = sipcurriculoExpProfissionalList;
    }

    public List<CurriculoEnsinoProfissionalizante> getEnsinoProfissionalizanteList() {
        return this.ensinoProfissionalizanteList;
    }

    public void setEnsinoProfissionalizanteList(List<CurriculoEnsinoProfissionalizante> sipcurriculoEnsProfissionalizList) {
        this.ensinoProfissionalizanteList = sipcurriculoEnsProfissionalizList;
    }

    public List<CurriculoIdioma> getIdiomaList() {
        return this.idiomaList;
    }

    public void setIdiomaList(List<CurriculoIdioma> sipcurriculoIdiomasList) {
        this.idiomaList = sipcurriculoIdiomasList;
    }

    public List<CurriculoCursoExtra> getCursoExtraList() {
        return this.cursoExtraList;
    }

    public void setCursoExtraList(List<CurriculoCursoExtra> sipcurriculoCursosExtrasList) {
        this.cursoExtraList = sipcurriculoCursosExtrasList;
    }

    public CurriculoSegmento getSegmento() {
        return CurriculoSegmento.get(this.segmento);
    }

    public void setSegmento(CurriculoSegmento segmento) {
        this.segmento = segmento != null ? Integer.valueOf(segmento.getCodigo()) : null;
    }

    public CurriculoMercadoTrabalhoSituacao getMercadoTrabalhoSituacao() {
        return CurriculoMercadoTrabalhoSituacao.get(this.mercadoTrabalhoSituacao);
    }

    public void setSituacaoMercadoTrabalho(CurriculoMercadoTrabalhoSituacao situacaoMercadotrab) {
        this.mercadoTrabalhoSituacao = situacaoMercadotrab != null ? Integer.valueOf(situacaoMercadotrab.getCodigo()) : null;
    }

    public CurriculoMercadoTrababalhoArea getRamoTrabalho() {
        return CurriculoMercadoTrababalhoArea.get(this.ramoTrabalho);
    }

    public void setRamoTrabalho(CurriculoMercadoTrababalhoArea ramoTrabalho) {
        this.ramoTrabalho = ramoTrabalho != null ? Integer.valueOf(ramoTrabalho.getCodigo()) : null;
    }

    public Sexo getSexo() {
        return this.sexo;
    }

    public void setSexo(Sexo sexo) {
        this.sexo = sexo;
    }

    public List<CurriculoEnsinoBasico> getEnsinoBasicoList() {
        return this.ensinoBasicoList;
    }

    public void setEnsinoBasicoList(List<CurriculoEnsinoBasico> sipcurriculoEnsBasicoList) {
        this.ensinoBasicoList = sipcurriculoEnsBasicoList;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.cpf != null ? this.cpf.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Curriculo)) {
            return false;
        }
        Curriculo other = (Curriculo)object;
        return (this.cpf != null || other.cpf == null) && (this.cpf == null || this.cpf.equals(other.cpf));
    }

    public String toString() {
        return "entity.Curriculo[ cpf=" + this.cpf + " ]";
    }
}

