/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Referencia;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CTRL_MARGEM_CONSIGNAVEL")
@Audited
public class CtrlMargemConsignavel
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_AUTENTICACAO = "SELECT m FROM CtrlMargemConsignavel m WHERE m.autenticacao = :codigoAutenticacao";
    public static final String FIND_BY_TRABALHADOR_REFERENCIA = "SELECT m FROM CtrlMargemConsignavel m WHERE m.trabalhador = :trabalhador AND m.referenciaCodigo = :referenciaCodigo ORDER BY m.datahora DESC";
    @FilterConfig(label="Autentica\u00e7\u00e3o")
    @Id
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=16)
    @Column(name="AUTENTICACAO")
    private String autenticacao;
    @Basic(optional=false)
    @NotNull
    @Column(name="DATAHORA")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date datahora;
    @Column(name="BASECALCULO")
    private Double basecalculo;
    @Column(name="PORCENTAGEM")
    private Double porcentagem;
    @Column(name="MARGEM_CONSIGNAVEL")
    private Double margemConsignavel;
    @Column(name="TOTAL_CONSIGNADO")
    private Double totalConsignado;
    @Column(name="DISPONIVEL")
    private Double disponivel;
    @NotNull
    @Column(name="USUARIO")
    private Integer usuarioCodigo;
    @ManyToOne
    @JoinColumn(name="USUARIO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Usuario usuario;
    @Type(type="BooleanTypeSip")
    @Column(name="VERIFICADA")
    private Boolean verificada;
    @Column(name="DATAHORA_VERIFICACAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraVerificacao;
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @FilterConfig(label="Trabalhador", inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo")
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador trabalhador;
    @NotNull
    @Column(name="REFERENCIA")
    private Integer referenciaCodigo;
    @ManyToOne
    @JoinColumn(name="REFERENCIA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Referencia referencia;
    @Transient
    private Double descontoPersonalizado;

    public String getAutenticacao() {
        return this.autenticacao;
    }

    public void setAutenticacao(String autenticacao) {
        this.autenticacao = autenticacao;
    }

    public Date getDatahora() {
        return this.datahora;
    }

    public void setDatahora(Date datahora) {
        this.datahora = datahora;
    }

    public Double getBasecalculo() {
        return this.basecalculo;
    }

    public void setBasecalculo(Double basecalculo) {
        this.basecalculo = basecalculo;
    }

    public Double getPorcentagem() {
        return this.porcentagem;
    }

    public void setPorcentagem(Double porcentagem) {
        this.porcentagem = porcentagem;
    }

    public Double getMargemConsignavel() {
        return this.margemConsignavel;
    }

    public void setMargemConsignavel(Double margemConsignavel) {
        this.margemConsignavel = margemConsignavel;
    }

    public Double getTotalConsignado() {
        return this.totalConsignado;
    }

    public void setTotalConsignado(Double totalConsignado) {
        this.totalConsignado = totalConsignado;
    }

    public Double getDisponivel() {
        if (this.descontoPersonalizado == null) {
            return this.disponivel;
        }
        return this.disponivel > this.descontoPersonalizado ? this.disponivel - this.descontoPersonalizado : 0.0;
    }

    public void setDisponivel(Double disponivel) {
        this.disponivel = disponivel;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuarioCodigo = usuario != null ? usuario.getCodigo() : null;
        this.usuario = usuario;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        if (trabalhador != null) {
            this.registro = trabalhador.getTrabalhadorPK().getRegistro();
            this.entidadeCodigo = trabalhador.getTrabalhadorPK().getEntidade();
        } else {
            this.registro = null;
            this.entidadeCodigo = null;
        }
        this.trabalhador = trabalhador;
    }

    public final Integer getReferenciaCodigo() {
        return this.referenciaCodigo;
    }

    public final void setReferenciaCodigo(Integer referenciaCodigo) {
        this.referenciaCodigo = referenciaCodigo;
    }

    public Referencia getReferencia() {
        return this.referencia;
    }

    public void setReferencia(Referencia referencia) {
        this.referenciaCodigo = referencia != null ? referencia.getCodigo() : null;
        this.referencia = referencia;
    }

    public Boolean getVerificada() {
        return this.verificada;
    }

    public void setVerificada(Boolean verificada) {
        this.verificada = verificada;
        this.dataHoraVerificacao = verificada != false ? new Timestamp(GregorianCalendar.getInstance().getTime().getTime()) : null;
    }

    public Date getDataHoraVerificacao() {
        return this.dataHoraVerificacao;
    }

    public void setDescontoPersonalizado(Double descontoPersonalizado) {
        this.descontoPersonalizado = descontoPersonalizado;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.autenticacao != null ? this.autenticacao.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CtrlMargemConsignavel)) {
            return false;
        }
        CtrlMargemConsignavel other = (CtrlMargemConsignavel)object;
        return (this.autenticacao != null || other.autenticacao == null) && (this.autenticacao == null || this.autenticacao.equals(other.autenticacao));
    }

    public String toString() {
        return "entity.CtrlMargemConsignavel[ autenticacao=" + this.autenticacao + " ]";
    }
}

