/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Banco;
import br.com.fiorilli.sip.persistence.entity.Conta;
import br.com.fiorilli.sip.persistence.entity.ConvenioPK;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@FilterConfigType(query="SELECT $R{[c.nome], [c]} FROM Convenio c LEFT JOIN FETCH c.conta ct LEFT JOIN FETCH ct.agencia ag LEFT JOIN FETCH ag.banco bab WHERE $P{[banco],[c.banco],[:banco]}")
@Entity
@Table(name="CONVENIOS")
@Audited
public class Convenio
implements Serializable,
GenericEntity,
Filterable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_ENTIDADE = "SELECT c FROM Convenio c JOIN FETCH c.banco WHERE c.convenioPK.entidade = :entidadeCodigo";
    public static final String FIND_BY_ENTIDADE_DISPONIVEL_SIPWEB = "SELECT c FROM Convenio c JOIN FETCH c.banco WHERE c.convenioPK.entidade = :entidadeId AND c.disponivelSipweb = 'S'";
    public static final String GET_NEXT_ITEM = "SELECT COALESCE(MAX(c.convenioPK.item), 0) + 1 FROM Convenio c WHERE c.conta.contaPK = :contaPK";
    public static final String FQL = "SELECT $R{[c.nome], [c]} FROM Convenio c LEFT JOIN FETCH c.conta ct LEFT JOIN FETCH ct.agencia ag LEFT JOIN FETCH ag.banco bab WHERE $P{[banco],[c.banco],[:banco]}";
    public static final String FIND_BANCOS_BY_ENTIDADE = "SELECT DISTINCT b FROM Convenio c JOIN c.banco b WHERE c.convenioPK.entidade = :entidadeCodigo";
    @EmbeddedId
    protected ConvenioPK convenioPK;
    @Size(max=30)
    @Column(name="CODCONVENIO")
    private String codconvenio;
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Column(name="SEQUENCIAL")
    private Short sequencial;
    @Size(max=31)
    @Column(name="NUM_CONVENIO_EDO")
    private String numConvenioEdo;
    @Size(max=18)
    @Column(name="CNPJ")
    private String cnpj;
    @Type(type="BooleanTypeSip")
    @Column(name="MARGEM_CONSIGNAVEL_SIPWEB")
    private Boolean disponivelSipweb;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="BANCO", referencedColumnName="BANCO", insertable=false, updatable=false), @JoinColumn(name="ITEMAGENCIA", referencedColumnName="ITEMAGENCIA", insertable=false, updatable=false), @JoinColumn(name="ITEMCONTA", referencedColumnName="ITEM", insertable=false, updatable=false)})
    private Conta conta;
    @Column(name="BANCO", insertable=false, updatable=false)
    private String codigoBanco;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="BANCO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @FilterConfig(blockCondition=true, inputType=FilterInputType.AUTO_COMPLETE, label="Banco")
    @FilterConfigSelect(itemLabel="nome", query="SELECT b FROM Banco b WHERE (b.nome LIKE :param||'%') OR (b.codigo = :param)")
    private Banco banco;

    public Convenio() {
        this.convenioPK = new ConvenioPK();
    }

    public Convenio(ConvenioPK convenioPK) {
        this.convenioPK = convenioPK;
    }

    public Convenio(String entidade, String banco, short itemagencia, short itemconta, short item) {
        this.convenioPK = new ConvenioPK(entidade, banco, itemagencia, itemconta, item);
    }

    public ConvenioPK getConvenioPK() {
        return this.convenioPK;
    }

    public void setConvenioPK(ConvenioPK convenioPK) {
        this.convenioPK = convenioPK;
    }

    public String getCodconvenio() {
        return this.codconvenio;
    }

    public void setCodconvenio(String codconvenio) {
        this.codconvenio = codconvenio;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Short getSequencial() {
        return this.sequencial;
    }

    public void setSequencial(Short sequencial) {
        this.sequencial = sequencial;
    }

    public String getNumConvenioEdo() {
        return this.numConvenioEdo;
    }

    public void setNumConvenioEdo(String numConvenioEdo) {
        this.numConvenioEdo = numConvenioEdo;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    public Boolean getDisponivelSipweb() {
        return this.disponivelSipweb;
    }

    public void setDisponivelSipweb(Boolean disponivelSipweb) {
        this.disponivelSipweb = disponivelSipweb;
    }

    public Conta getConta() {
        return this.conta;
    }

    public void setConta(Conta conta) {
        if (conta != null) {
            this.convenioPK.setBanco(conta.getContaPK().getBanco());
            this.convenioPK.setEntidade(conta.getContaPK().getEntidade());
            this.convenioPK.setItemAgencia(conta.getContaPK().getAgencia());
            this.convenioPK.setItemConta(conta.getContaPK().getItem());
        } else {
            this.convenioPK.setBanco(null);
            this.convenioPK.setEntidade(null);
            this.convenioPK.setItemAgencia(null);
            this.convenioPK.setItemConta(null);
        }
        this.conta = conta;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.convenioPK != null ? this.convenioPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Convenio)) {
            return false;
        }
        Convenio other = (Convenio)object;
        return (this.convenioPK != null || other.convenioPK == null) && (this.convenioPK == null || this.convenioPK.equals(other.convenioPK));
    }

    public String toString() {
        return "entity.Convenio[ conveniosPK=" + this.convenioPK + " ]";
    }

    public Banco getBanco() {
        return this.banco;
    }

    public void setBanco(Banco banco) {
        this.banco = banco;
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.hashCode());
    }

    public String getCodigoBanco() {
        return this.codigoBanco;
    }

    public void setCodigoBanco(String codigoBanco) {
        this.codigoBanco = codigoBanco;
    }

    public String getItemId() {
        return this.codigoBanco;
    }

    public String getItemLabel() {
        return this.nome;
    }
}

