/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Banco;
import br.com.fiorilli.sip.persistence.entity.ContasEntidadePK;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
@Audited
public class ContasEntidade
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private ContasEntidadePK contasEntidadePK;
    @Column(name="CONTATO")
    private String contato;
    @Column(name="EXTENSAO")
    private String extensao;
    @Column(name="NOMEARQ")
    private String nomeArquivo;
    @ManyToOne
    @JoinColumn(columnDefinition="BANCO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @FilterConfig(label="Banco", inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT b FROM Banco b WHERE (b.nome LIKE :param||'%') OR (b.codigo = :param)")
    private Banco banco;

    public ContasEntidadePK getContasEntidadePK() {
        return this.contasEntidadePK;
    }

    public void setContasEntidadePK(ContasEntidadePK id) {
        this.contasEntidadePK = id;
    }

    public String getContato() {
        return this.contato;
    }

    public void setContato(String contato) {
        this.contato = contato;
    }

    public String getExtensao() {
        return this.extensao;
    }

    public void setExtensao(String extensao) {
        this.extensao = extensao;
    }

    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    public void setNomeArquivo(String nomearq) {
        this.nomeArquivo = nomearq;
    }

    public Banco getBanco() {
        return this.banco;
    }

    public void setBanco(Banco banco) {
        this.banco = banco;
    }
}

