/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Catedespesa;
import br.com.fiorilli.sip.persistence.entity.ContabilProventoPK;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.ReferenciaTipo;
import br.com.fiorilli.sip.persistence.entity.ScpiCentrocusto;
import br.com.fiorilli.sip.persistence.entity.ScpiFornecedor;
import br.com.fiorilli.sip.persistence.entity.ScpiPlanocontas;
import br.com.fiorilli.sip.persistence.entity.ScpiVinculo;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CONTABIL_PROV")
@Audited
public class ContabilProvento
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EXISTS_BY_ANO = "SELECT CASE WHEN COALESCE(COUNT(c.contabilProventoPK.departamentoDespesa), 0) > 0 THEN true ELSE false END FROM ContabilProvento c WHERE c.contabilProventoPK.entidade =:entidadeCodigo AND c.contabilProventoPK.ano = :ano";
    public static final String GET_WITH_NEXT_YEAR = "SELECT d FROM ContabilProvento d WHERE d.contabilProventoPK.entidade = :entidadeCodigo AND CAST((CAST(d.contabilProventoPK.ano AS integer) + 1) as string) = :ano AND EXISTS (SELECT 1 FROM Unidade u WHERE u.responsavelEntidade = d.contabilProventoPK.entidade AND u.departamentoDespesa = d.contabilProventoPK.departamentoDespesa AND u.ano = :ano) ORDER BY d.contabilProventoPK.departamentoDespesa, d.contabilProventoPK.evento";
    @EmbeddedId
    protected ContabilProventoPK contabilProventoPK;
    @Column(name="FICHA")
    private Integer ficha;
    @Size(max=21)
    @Column(name="CONTA_CREDITO")
    private String contaCredito;
    @Size(max=21)
    @Column(name="CONTA_DEBITO")
    private String contaDebito;
    @Column(name="UNIDADE")
    private Integer unidadeCodigo;
    @JoinColumn(name="UNIDADE", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Unidade unidade;
    @Size(min=1, max=7)
    @Column(name="VINCULO")
    private String vinculoCodigo;
    @JoinColumn(name="VINCULO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private ScpiVinculo vinculo;
    @Size(min=1, max=18)
    @Column(name="CONTA")
    private String contaCodigo;
    @JoinColumn(name="CONTA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private ScpiPlanocontas conta;
    @Column(name="FORNECEDOR")
    private Integer fornecedorCodigo;
    @JoinColumn(name="FORNECEDOR", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private ScpiFornecedor fornecedor;
    @Size(min=1, max=7)
    @Column(name="CENTROCUSTO")
    private String centroCustoCodigo;
    @JoinColumn(name="CENTROCUSTO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private ScpiCentrocusto centroCusto;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento evento;
    @JoinColumns(value={@JoinColumn(name="CATEGORIA", referencedColumnName="CATEGORIA"), @JoinColumn(name="GRUPO", referencedColumnName="GRUPO"), @JoinColumn(name="MODALIDADE", referencedColumnName="MODALIDADE"), @JoinColumn(name="ELEMENTO", referencedColumnName="ELEMENTO"), @JoinColumn(name="DESDOBRO", referencedColumnName="DESDOBRO"), @JoinColumn(name="SUBDESDOBRO", referencedColumnName="SUBDESDOBRO")})
    @ManyToOne(fetch=FetchType.LAZY)
    private Catedespesa categoriaDespesa;
    @NotNull
    @Column(name="TIPO_REFERENCIA")
    @Type(type="TipoReferencia")
    private ReferenciaTipo tipoReferencia;

    public ContabilProvento() {
    }

    public ContabilProvento(ContabilProventoPK contabilProvPK) {
        this.contabilProventoPK = contabilProvPK;
    }

    public ContabilProvento(String entidade, String depdespesa, String ano, String evento) {
        this.contabilProventoPK = new ContabilProventoPK(entidade, depdespesa, ano, evento);
    }

    public ContabilProventoPK getContabilProventoPK() {
        return this.contabilProventoPK;
    }

    public void setContabilProventoPK(ContabilProventoPK contabilProvPK) {
        this.contabilProventoPK = contabilProvPK;
    }

    public Integer getFicha() {
        return this.ficha;
    }

    public void setFicha(Integer ficha) {
        this.ficha = ficha;
    }

    public String getContaCredito() {
        return this.contaCredito;
    }

    public void setContaCredito(String contaCredito) {
        this.contaCredito = contaCredito;
    }

    public String getContaDebito() {
        return this.contaDebito;
    }

    public void setContaDebito(String contaDebito) {
        this.contaDebito = contaDebito;
    }

    public Unidade getUnidade() {
        return this.unidade;
    }

    public void setUnidade(Unidade unidade) {
        this.unidade = unidade;
    }

    public ScpiVinculo getVinculo() {
        return this.vinculo;
    }

    public void setVinculo(ScpiVinculo vinculo) {
        this.vinculo = vinculo;
    }

    public ScpiPlanocontas getConta() {
        return this.conta;
    }

    public void setConta(ScpiPlanocontas conta) {
        this.conta = conta;
    }

    public ScpiFornecedor getFornecedor() {
        return this.fornecedor;
    }

    public void setFornecedor(ScpiFornecedor fornecedor) {
        this.fornecedor = fornecedor;
    }

    public ScpiCentrocusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(ScpiCentrocusto centrocusto) {
        this.centroCusto = centrocusto;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento eventos) {
        this.evento = eventos;
    }

    public Catedespesa getCategoriaDespesa() {
        return this.categoriaDespesa;
    }

    public void setCategoriaDespesa(Catedespesa catedespesa) {
        this.categoriaDespesa = catedespesa;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.contabilProventoPK != null ? this.contabilProventoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ContabilProvento)) {
            return false;
        }
        ContabilProvento other = (ContabilProvento)object;
        return (this.contabilProventoPK != null || other.contabilProventoPK == null) && (this.contabilProventoPK == null || this.contabilProventoPK.equals(other.contabilProventoPK));
    }

    public String toString() {
        return "entity.ContabilProv[ contabilProvPK=" + this.contabilProventoPK + " ]";
    }

    public Integer getUnidadeCodigo() {
        return this.unidadeCodigo;
    }

    public void setUnidadeCodigo(Integer unidadeCodigo) {
        this.unidadeCodigo = unidadeCodigo;
    }

    public String getVinculoCodigo() {
        return this.vinculoCodigo;
    }

    public void setVinculoCodigo(String vinculoCodigo) {
        this.vinculoCodigo = vinculoCodigo;
    }

    public String getContaCodigo() {
        return this.contaCodigo;
    }

    public void setContaCodigo(String contaCodigo) {
        this.contaCodigo = contaCodigo;
    }

    public Integer getFornecedorCodigo() {
        return this.fornecedorCodigo;
    }

    public void setFornecedorCodigo(Integer fornecedorCodigo) {
        this.fornecedorCodigo = fornecedorCodigo;
    }

    public String getCentroCustoCodigo() {
        return this.centroCustoCodigo;
    }

    public void setCentroCustoCodigo(String centroCustoCodigo) {
        this.centroCustoCodigo = centroCustoCodigo;
    }

    public ReferenciaTipo getTipoReferencia() {
        return this.tipoReferencia;
    }

    public void setTipoReferencia(ReferenciaTipo tipoReferencia) {
        this.tipoReferencia = tipoReferencia;
    }
}

