/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.ContabilDescontoPK;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.ReferenciaTipo;
import br.com.fiorilli.sip.persistence.entity.ScpiCentrocusto;
import br.com.fiorilli.sip.persistence.entity.ScpiFornecedor;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CONTABIL_DESC")
@Audited
public class ContabilDesconto
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EXISTS_BY_ANO = "SELECT CASE WHEN COALESCE(COUNT(c.contabilDescontoPK.departamentoDespesa), 0) > 0 THEN true ELSE false END FROM ContabilDesconto c WHERE c.contabilDescontoPK.entidade =:entidadeCodigo AND c.contabilDescontoPK.ano = :ano";
    public static final String GET_WITH_NEXT_YEAR = "SELECT d FROM ContabilDesconto d WHERE d.contabilDescontoPK.entidade = :entidadeCodigo AND CAST((CAST(d.contabilDescontoPK.ano AS integer) + 1) as string) = :ano AND EXISTS (SELECT 1 FROM Unidade u WHERE u.responsavelEntidade = d.contabilDescontoPK.entidade AND u.departamentoDespesa = d.contabilDescontoPK.departamentoDespesa AND u.ano = :ano) ORDER BY d.contabilDescontoPK.departamentoDespesa, d.contabilDescontoPK.evento";
    @EmbeddedId
    protected ContabilDescontoPK contabilDescontoPK;
    @Column(name="FICHA")
    private Integer ficha;
    @JoinColumn(name="UNIDADE", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Unidade unidade;
    @JoinColumn(name="FORNECEDOR", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private ScpiFornecedor fornecedor;
    @JoinColumn(name="CENTROCUSTO", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private ScpiCentrocusto centroCusto;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento eventos;
    @NotNull
    @Column(name="TIPO_REFERENCIA")
    @Type(type="TipoReferencia")
    private ReferenciaTipo tipoReferencia;

    public ContabilDesconto() {
    }

    public ContabilDesconto(ContabilDescontoPK contabilDescPK) {
        this.contabilDescontoPK = contabilDescPK;
    }

    public ContabilDesconto(String entidade, String depdespesa, String ano, String evento) {
        this.contabilDescontoPK = new ContabilDescontoPK(entidade, depdespesa, ano, evento);
    }

    public ContabilDescontoPK getContabilDescontoPK() {
        return this.contabilDescontoPK;
    }

    public void setContabilDescontoPK(ContabilDescontoPK contabilDescPK) {
        this.contabilDescontoPK = contabilDescPK;
    }

    public Integer getFicha() {
        return this.ficha;
    }

    public void setFicha(Integer ficha) {
        this.ficha = ficha;
    }

    public Unidade getUnidade() {
        return this.unidade;
    }

    public void setUnidade(Unidade unidade) {
        this.unidade = unidade;
    }

    public ScpiFornecedor getFornecedor() {
        return this.fornecedor;
    }

    public void setFornecedor(ScpiFornecedor fornecedor) {
        this.fornecedor = fornecedor;
    }

    public ScpiCentrocusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(ScpiCentrocusto centrocusto) {
        this.centroCusto = centrocusto;
    }

    public Evento getEventos() {
        return this.eventos;
    }

    public void setEventos(Evento eventos) {
        this.eventos = eventos;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.contabilDescontoPK != null ? this.contabilDescontoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ContabilDesconto)) {
            return false;
        }
        ContabilDesconto other = (ContabilDesconto)object;
        return (this.contabilDescontoPK != null || other.contabilDescontoPK == null) && (this.contabilDescontoPK == null || this.contabilDescontoPK.equals(other.contabilDescontoPK));
    }

    public String toString() {
        return "entity.ContabilDesc[ contabilDescPK=" + this.contabilDescontoPK + " ]";
    }

    public ReferenciaTipo getTipoReferencia() {
        return this.tipoReferencia;
    }

    public void setTipoReferencia(ReferenciaTipo tipoReferencia) {
        this.tipoReferencia = tipoReferencia;
    }
}

