/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.ContabilDeducoesPK;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.ReferenciaTipo;
import br.com.fiorilli.sip.persistence.entity.ScpiCentrocusto;
import br.com.fiorilli.sip.persistence.entity.ScpiFornecedor;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CONTABIL_DEDUCOES")
@Audited
public class ContabilDeducoes
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EXISTS_BY_ANO = "SELECT CASE WHEN COALESCE(COUNT(c.contabilDeducoesPK.departamentoDespesa), 0) > 0 THEN true ELSE false END FROM ContabilDeducoes c WHERE c.contabilDeducoesPK.entidade =:entidadeCodigo AND c.contabilDeducoesPK.ano = :ano";
    public static final String GET_WITH_NEXT_YEAR = "SELECT d FROM ContabilDeducoes d WHERE d.contabilDeducoesPK.entidade = :entidadeCodigo AND CAST((CAST(d.contabilDeducoesPK.ano AS integer) + 1) as string) = :ano AND EXISTS (SELECT 1 FROM Unidade u WHERE u.responsavelEntidade = d.contabilDeducoesPK.entidade AND u.departamentoDespesa = d.contabilDeducoesPK.departamentoDespesa AND u.ano = :ano) ORDER BY d.contabilDeducoesPK.departamentoDespesa, d.contabilDeducoesPK.evento";
    @EmbeddedId
    protected ContabilDeducoesPK contabilDeducoesPK;
    @Column(name="FICHA_RECEITA_CLT")
    private Integer fichaReceitaClt;
    @Column(name="FICHA_RECEITA_EST")
    private Integer fichaReceitaEst;
    @Column(name="FORNECEDOR")
    private Integer fornecedorCodigo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FORNECEDOR", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private ScpiFornecedor fornecedor;
    @Column(name="CENTROCUSTO")
    private String centroCustoCodigo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CENTROCUSTO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private ScpiCentrocusto centroCusto;
    @Column(name="EMPRESA_EVENTO")
    private String eventoEntidade;
    @JoinColumns(value={@JoinColumn(name="EMPRESA_EVENTO", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento evento;
    @NotNull
    @Column(name="TIPO_REFERENCIA")
    @Type(type="TipoReferencia")
    private ReferenciaTipo tipoReferencia;

    public ContabilDeducoes() {
    }

    public ContabilDeducoes(ContabilDeducoesPK contabilDeducoesPK) {
        this.contabilDeducoesPK = contabilDeducoesPK;
    }

    public ContabilDeducoes(String entidade, String depdespesa, String ano, String evento) {
        this.contabilDeducoesPK = new ContabilDeducoesPK(entidade, depdespesa, ano, evento);
    }

    public ContabilDeducoesPK getContabilDeducoesPK() {
        return this.contabilDeducoesPK;
    }

    public void setContabilDeducoesPK(ContabilDeducoesPK contabilDeducoesPK) {
        this.contabilDeducoesPK = contabilDeducoesPK;
    }

    public Integer getFichaReceitaClt() {
        return this.fichaReceitaClt;
    }

    public void setFichaReceitaClt(Integer fichaReceitaClt) {
        this.fichaReceitaClt = fichaReceitaClt;
    }

    public Integer getFichaReceitaEst() {
        return this.fichaReceitaEst;
    }

    public void setFichaReceitaEst(Integer fichaReceitaEst) {
        this.fichaReceitaEst = fichaReceitaEst;
    }

    public ScpiFornecedor getFornecedor() {
        return this.fornecedor;
    }

    public void setFornecedor(ScpiFornecedor fornecedor) {
        this.fornecedorCodigo = fornecedor != null ? fornecedor.getCodigo() : null;
        this.fornecedor = fornecedor;
    }

    public ScpiCentrocusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(ScpiCentrocusto centrocusto) {
        this.centroCustoCodigo = centrocusto != null ? centrocusto.getCodigo() : null;
        this.centroCusto = centrocusto;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento eventos) {
        if (eventos != null) {
            this.eventoEntidade = eventos.getEventoPK().getEntidade();
            this.contabilDeducoesPK.setEvento(eventos.getEventoPK().getCodigo());
        } else {
            this.eventoEntidade = null;
            this.contabilDeducoesPK.setEvento(null);
        }
        this.evento = eventos;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.contabilDeducoesPK != null ? this.contabilDeducoesPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ContabilDeducoes)) {
            return false;
        }
        ContabilDeducoes other = (ContabilDeducoes)object;
        return (this.contabilDeducoesPK != null || other.contabilDeducoesPK == null) && (this.contabilDeducoesPK == null || this.contabilDeducoesPK.equals(other.contabilDeducoesPK));
    }

    public String toString() {
        return "entity.ContabilDeducoes[ contabilDeducoesPK=" + this.contabilDeducoesPK + " ]";
    }

    public Integer getFornecedorCodigo() {
        return this.fornecedorCodigo;
    }

    public void setFornecedorCodigo(Integer fornecedorCodigo) {
        this.fornecedorCodigo = fornecedorCodigo;
    }

    public String getCentroCustoCodigo() {
        return this.centroCustoCodigo;
    }

    public void setCentroCustoCodigo(String centroCustoCodigo) {
        this.centroCustoCodigo = centroCustoCodigo;
    }

    public String getEventoEntidade() {
        return this.eventoEntidade;
    }

    public void setEventoEntidade(String eventoEntidade) {
        this.eventoEntidade = eventoEntidade;
    }

    public ReferenciaTipo getTipoReferencia() {
        return this.tipoReferencia;
    }

    public void setTipoReferencia(ReferenciaTipo tipoReferencia) {
        this.tipoReferencia = tipoReferencia;
    }
}

