/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Agencia;
import br.com.fiorilli.sip.persistence.entity.Banco;
import br.com.fiorilli.sip.persistence.entity.ContaPK;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Size;

@Entity
@Table(name="CONTAS")
@Audited
public class Conta
implements Serializable {
    private static final long serialVersionUID = -630854801135113063L;
    public static final String FIND_BY_NUMERO_BANCO = "SELECT c FROM Conta c LEFT JOIN FETCH c.agencia ag LEFT JOIN FETCH ag.banco ba WHERE c.contaPK.entidade = :entidadeCodigo AND (ba.nome LIKE :valor OR c.numeroConta = :valor) ORDER BY ba.nome";
    @EmbeddedId
    protected ContaPK contaPK;
    @Size(max=15)
    @Column(name="CONTA")
    private String numeroConta;
    @Size(max=2)
    @Column(name="DVCONTA")
    private String dvconta;
    @Size(max=2)
    @Column(name="TIPO")
    private String tipo;
    @Size(max=12)
    @Column(name="NOMEARQ")
    private String nomeArquivo;
    @Size(max=3)
    @Column(name="EXTENSAO")
    private String extensao;
    @Transient
    @FilterConfig(label="Banco", inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT b FROM Banco b WHERE (b.nome LIKE :param||'%') OR (b.codigo = :param)")
    private Banco banco;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="BANCO", referencedColumnName="BANCO", insertable=false, updatable=false), @JoinColumn(name="ITEMAGENCIA", referencedColumnName="ITEM", insertable=false, updatable=false)})
    private Agencia agencia;

    public Conta() {
    }

    public Conta(ContaPK contaPK) {
        this.contaPK = contaPK;
    }

    public Conta(String entidade, String banco, short itemagencia, short item) {
        this.contaPK = new ContaPK(entidade, banco, itemagencia, item);
    }

    public ContaPK getContaPK() {
        return this.contaPK;
    }

    public void setContaPK(ContaPK contaPK) {
        this.contaPK = contaPK;
    }

    public String getNumeroConta() {
        return this.numeroConta;
    }

    public void setNumeroConta(String numeroConta) {
        this.numeroConta = numeroConta;
    }

    public String getDvconta() {
        return this.dvconta;
    }

    public void setDvconta(String dvconta) {
        this.dvconta = dvconta;
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }

    public String getExtensao() {
        return this.extensao;
    }

    public void setExtensao(String extensao) {
        this.extensao = extensao;
    }

    public Agencia getAgencia() {
        return this.agencia;
    }

    public void setAgencia(Agencia agencia) {
        if (agencia != null) {
            this.contaPK.setBanco(agencia.getAgenciaPK().getBanco());
            this.contaPK.setEntidade(agencia.getAgenciaPK().getEntidade());
            this.contaPK.setAgencia(agencia.getAgenciaPK().getItem());
        } else {
            this.contaPK.setBanco(null);
            this.contaPK.setEntidade(null);
            this.contaPK.setAgencia((short)0);
        }
        this.agencia = agencia;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.contaPK != null ? this.contaPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Conta)) {
            return false;
        }
        Conta other = (Conta)object;
        return (this.contaPK != null || other.contaPK == null) && (this.contaPK == null || this.contaPK.equals(other.contaPK));
    }

    public String toString() {
        return "entity.Contas[ contasPK=" + this.contaPK + " ]";
    }
}

