/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.ConcursoCargo;
import br.com.fiorilli.sip.persistence.entity.ConcursoConvocado;
import br.com.fiorilli.sip.persistence.entity.ConcursoInscritoSituacao;
import br.com.fiorilli.sip.persistence.entity.Endereco;
import br.com.fiorilli.sip.persistence.entity.Sexo;
import br.com.fiorilli.sip.persistence.entity.TelefoneCelular;
import br.com.fiorilli.sip.persistence.entity.TelefoneFixo;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CONCURSO_INSCRITO")
@Audited
public class ConcursoInscrito
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_CPF_WEB = "SELECT i FROM ConcursoInscrito i JOIN FETCH i.cargoConcurso cc JOIN FETCH cc.concurso c WHERE i.cpf = :cpf";
    public static final String GENERATOR = "GEN_CONCURSOINSCRITO";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Column(name="NUMINSCRICAO")
    private Integer numeroInscricao;
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Size(max=11)
    @Column(name="CPF")
    private String cpf;
    @Type(type="BooleanTypeSip")
    @Column(name="DEFERIDO")
    private Boolean deferido;
    @Type(type="BooleanTypeSip")
    @Column(name="HOMOLOGADO")
    private Boolean homologado;
    @Type(type="BooleanTypeSip")
    @Column(name="APROVADO")
    private Boolean aprovado;
    @Column(name="CLASSIFICACAO")
    private Short classificacao;
    @Type(type="BooleanTypeSip")
    @Column(name="SUBJUDICE")
    private Boolean subjudice;
    @Size(max=16)
    @Column(name="DOCUMENTO")
    private String documento;
    @Size(max=2)
    @Column(name="UF_DOCUMENTO")
    private String documentoUF;
    @Size(max=8)
    @Column(name="ORGAOEMISSOR")
    private String orgaoEmissor;
    @Embedded
    private Endereco endereco;
    @Embedded
    private TelefoneFixo telefone;
    @Embedded
    private TelefoneCelular celular;
    @Size(max=60)
    @Column(name="EMAIL")
    private String email;
    @Column(name="DTNASCIMENTO")
    @Temporal(value=TemporalType.DATE)
    private Date dataNascimento;
    @Column(name="SITUACAO")
    private Integer situacao;
    @Type(type="BooleanTypeSip")
    @Column(name="PORTADOR_DEFICIENCIA")
    private Boolean portadorDeficiencia;
    @Column(name="SEXO")
    @Enumerated(value=EnumType.STRING)
    private Sexo sexo;
    @Column(name="CARGO_CONCURSO")
    private Integer concursoCargoCodigo;
    @JoinColumn(name="CARGO_CONCURSO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false)
    private ConcursoCargo cargoConcurso;
    @OneToOne(cascade={CascadeType.ALL}, mappedBy="concursoInscrito", fetch=FetchType.LAZY)
    private ConcursoConvocado concursoConvocado;
    @Type(type="BooleanTypeSip")
    @Column(name="AFRODESCENDENTE")
    private Boolean afrodescendente;

    public ConcursoInscrito() {
    }

    public ConcursoInscrito(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getNumeroInscricao() {
        return this.numeroInscricao;
    }

    public void setNumeroInscricao(Integer numinscricao) {
        this.numeroInscricao = numinscricao;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public Short getClassificacao() {
        return this.classificacao;
    }

    public void setClassificacao(Short classificacao) {
        this.classificacao = classificacao;
    }

    public String getDocumento() {
        return this.documento;
    }

    public void setDocumento(String documento) {
        this.documento = documento;
    }

    public String getDocumentoUF() {
        return this.documentoUF;
    }

    public void setDocumentoUF(String ufDocumento) {
        this.documentoUF = ufDocumento;
    }

    public String getOrgaoEmissor() {
        return this.orgaoEmissor;
    }

    public void setOrgaoEmissor(String orgaoemissor) {
        this.orgaoEmissor = orgaoemissor;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Date getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(Date dtnascimento) {
        this.dataNascimento = dtnascimento;
    }

    public ConcursoInscritoSituacao getSituacao() {
        return ConcursoInscritoSituacao.toEntity(this.situacao);
    }

    public void setSituacao(ConcursoInscritoSituacao situacao) {
        this.situacao = situacao != null ? situacao.getId() : null;
    }

    public Boolean getDeferido() {
        return this.deferido;
    }

    public void setDeferido(Boolean deferido) {
        this.deferido = deferido;
    }

    public Boolean getHomologado() {
        return this.homologado;
    }

    public void setHomologado(Boolean homologado) {
        this.homologado = homologado;
    }

    public Boolean getAprovado() {
        return this.aprovado;
    }

    public void setAprovado(Boolean aprovado) {
        this.aprovado = aprovado;
    }

    public Boolean getSubjudice() {
        return this.subjudice;
    }

    public void setSubjudice(Boolean subjudice) {
        this.subjudice = subjudice;
    }

    public Boolean getPortadorDeficiencia() {
        return this.portadorDeficiencia;
    }

    public void setPortadorDeficiencia(Boolean portadorDeficiencia) {
        this.portadorDeficiencia = portadorDeficiencia;
    }

    public void setSituacao(Integer situacao) {
        this.situacao = situacao;
    }

    public Sexo getSexo() {
        return this.sexo;
    }

    public void setSexo(Sexo sexo) {
        this.sexo = sexo;
    }

    public ConcursoCargo getCargoConcurso() {
        return this.cargoConcurso;
    }

    public void setCargoConcurso(ConcursoCargo cargoConcurso) {
        this.cargoConcurso = cargoConcurso;
    }

    public ConcursoConvocado getConcursoConvocado() {
        return this.concursoConvocado;
    }

    public void setConcursoConvocado(ConcursoConvocado concursoConvocado) {
        this.concursoConvocado = concursoConvocado;
    }

    public Integer getConcursoCargoCodigo() {
        return this.concursoCargoCodigo;
    }

    public void setConcursoCargoCodigo(Integer concursoCargoCodigo) {
        this.concursoCargoCodigo = concursoCargoCodigo;
    }

    public Endereco getEndereco() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public TelefoneFixo getTelefone() {
        if (this.telefone == null) {
            this.telefone = new TelefoneFixo();
        }
        return this.telefone;
    }

    public void setTelefone(TelefoneFixo telefone) {
        this.telefone = telefone;
    }

    public TelefoneCelular getCelular() {
        if (this.celular == null) {
            this.celular = new TelefoneCelular();
        }
        return this.celular;
    }

    public void setCelular(TelefoneCelular celular) {
        this.celular = celular;
    }

    public Boolean getAfrodescendente() {
        return this.afrodescendente;
    }

    public void setAfrodescendente(Boolean afrodescendente) {
        this.afrodescendente = afrodescendente;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConcursoInscrito)) {
            return false;
        }
        ConcursoInscrito other = (ConcursoInscrito)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.ConcursoInscrito[ codigo=" + this.codigo + " ]";
    }
}

