/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Concurso;
import br.com.fiorilli.sip.persistence.entity.ConcursoEditalTipo;
import br.com.fiorilli.sip.persistence.entity.DocumentoDigital;
import br.com.fiorilli.sip.persistence.entity.DocumentoDigitalPDF;
import br.com.fiorilli.sip.persistence.entity.LocalPublicacao;
import br.com.fiorilli.sip.persistence.entity.VeiculoPublicacao;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="CONCURSO_EDITAL")
@Audited
public class ConcursoEdital
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_CONCURSOEDITAL";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Size(max=16)
    @Column(name="NUMEDITAL")
    private String numeroEdital;
    @Column(name="DATAPUBEDITAL")
    @Temporal(value=TemporalType.DATE)
    private Date dataPublicacaoEdital;
    @Enumerated
    @Column(name="TIPOEDITAL")
    private ConcursoEditalTipo tipoEdital;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=4)
    @Column(name="ANO")
    private String ano;
    @Size(max=255)
    @Column(name="MOTIVO")
    private String motivo;
    @Column(name="DTVALIDADE")
    @Temporal(value=TemporalType.DATE)
    private Date dataValidade;
    @Column(name="DATAEDITAL")
    @Temporal(value=TemporalType.DATE)
    private Date dataEdital;
    @Column(name="VEICULO_PUBLICACAO")
    private Integer veiculoPublicacaoCodigo;
    @JoinColumn(name="VEICULO_PUBLICACAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.EAGER)
    private VeiculoPublicacao veiculoPublicacao;
    @Column(name="LOCAL_PUBLICACAO")
    private Integer localPublicacaoCodigo;
    @JoinColumn(name="LOCAL_PUBLICACAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.EAGER)
    private LocalPublicacao localPublicacao;
    @Column(name="CONCURSO")
    private Integer concursoCodigo;
    @JoinColumn(name="CONCURSO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Concurso concurso;
    @Column(name="DOCDIGITALPDF")
    private Integer documentoDigitalPDFCodigo;
    @JoinColumn(name="DOCDIGITALPDF", referencedColumnName="IDPDF", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private DocumentoDigitalPDF documentoDigitalPdf;
    @JoinColumn(name="DOCDIGITAL", referencedColumnName="IDDOCDIGITAL", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private DocumentoDigital documentoDigital;

    public ConcursoEdital() {
    }

    public ConcursoEdital(Integer codigo) {
        this.codigo = codigo;
    }

    public ConcursoEdital(Integer codigo, String ano) {
        this.codigo = codigo;
        this.ano = ano;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getNumeroEdital() {
        return this.numeroEdital;
    }

    public void setNumeroEdital(String numedital) {
        this.numeroEdital = numedital;
    }

    public Date getDataPublicacaoEdital() {
        return this.dataPublicacaoEdital;
    }

    public void setDataPublicacaoEdital(Date datapubedital) {
        this.dataPublicacaoEdital = datapubedital;
    }

    public ConcursoEditalTipo getTipoEdital() {
        return this.tipoEdital;
    }

    public void setTipoEdital(ConcursoEditalTipo tipoedital) {
        this.tipoEdital = tipoedital;
    }

    public String getAno() {
        return this.ano;
    }

    public void setAno(String ano) {
        this.ano = ano;
    }

    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    public Date getDataValidade() {
        return this.dataValidade;
    }

    public void setDataValidade(Date dtvalidade) {
        this.dataValidade = dtvalidade;
    }

    public Date getDataEdital() {
        return this.dataEdital;
    }

    public void setDataEdital(Date dataedital) {
        this.dataEdital = dataedital;
    }

    public VeiculoPublicacao getVeiculoPublicacao() {
        return this.veiculoPublicacao;
    }

    public void setVeiculoPublicacao(VeiculoPublicacao veiculoPublicacao) {
        this.veiculoPublicacaoCodigo = veiculoPublicacao != null ? veiculoPublicacao.getCodigo() : null;
        this.veiculoPublicacao = veiculoPublicacao;
    }

    public LocalPublicacao getLocalPublicacao() {
        return this.localPublicacao;
    }

    public void setLocalPublicacao(LocalPublicacao localPublicacao) {
        this.localPublicacaoCodigo = localPublicacao != null ? localPublicacao.getCodigo() : null;
        this.localPublicacao = localPublicacao;
    }

    public Concurso getConcurso() {
        return this.concurso;
    }

    public void setConcurso(Concurso concurso) {
        this.concurso = concurso;
    }

    public Integer getVeiculoPublicacaoCodigo() {
        return this.veiculoPublicacaoCodigo;
    }

    public void setVeiculoPublicacaoCodigo(Integer veiculoPublicacaoCodigo) {
        this.veiculoPublicacaoCodigo = veiculoPublicacaoCodigo;
    }

    public Integer getLocalPublicacaoCodigo() {
        return this.localPublicacaoCodigo;
    }

    public void setLocalPublicacaoCodigo(Integer localPublicacaoCodigo) {
        this.localPublicacaoCodigo = localPublicacaoCodigo;
    }

    public Integer getConcursoCodigo() {
        return this.concursoCodigo;
    }

    public void setConcursoCodigo(Integer concursoCodigo) {
        this.concursoCodigo = concursoCodigo;
    }

    public Integer getDocumentoDigitalPDFCodigo() {
        return this.documentoDigitalPDFCodigo;
    }

    public void setDocumentoDigitalPDFCodigo(Integer documentoDigitalPDFCodigo) {
        this.documentoDigitalPDFCodigo = documentoDigitalPDFCodigo;
    }

    public DocumentoDigitalPDF getDocumentoDigitalPdf() {
        return this.documentoDigitalPdf;
    }

    public void setDocumentoDigitalPdf(DocumentoDigitalPDF documentoDigitalPdf) {
        this.documentoDigitalPdf = documentoDigitalPdf;
    }

    public DocumentoDigital getDocumentoDigital() {
        return this.documentoDigital;
    }

    public void setDocumentoDigital(DocumentoDigital documentoDigital) {
        this.documentoDigital = documentoDigital;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConcursoEdital)) {
            return false;
        }
        ConcursoEdital other = (ConcursoEdital)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.ConcursoEdital[ codigo=" + this.codigo + " ]";
    }
}

