/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.ConcursoConvocadoSituacao;
import br.com.fiorilli.sip.persistence.entity.ConcursoConvocadoSituacaoEnum;
import br.com.fiorilli.sip.persistence.entity.ConcursoInscrito;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CONCURSO_CONVOCADO")
@Audited
public class ConcursoConvocado
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="INSCRITO")
    private Integer inscrito;
    @Type(type="BooleanTypeSip")
    @Column(name="SUBJUDICE")
    private Boolean subjudice;
    @Size(max=150)
    @Column(name="JUSTIFICATIVA")
    private String justificativa;
    @JoinColumn(name="INSCRITO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @OneToOne(optional=false, fetch=FetchType.LAZY)
    private ConcursoInscrito concursoInscrito;
    @Column(name="DATAHOMOLOGACAO")
    @Temporal(value=TemporalType.DATE)
    private Date dataHomologacao;
    @Column(name="SITUACAO")
    private Integer situacao;
    @OneToMany(mappedBy="convocado", fetch=FetchType.EAGER)
    private List<ConcursoConvocadoSituacao> situacoes;

    public ConcursoConvocado() {
    }

    public ConcursoConvocado(Integer inscrito) {
        this.inscrito = inscrito;
    }

    public Integer getInscrito() {
        return this.inscrito;
    }

    public void setInscrito(Integer inscrito) {
        this.inscrito = inscrito;
    }

    public Boolean getSubjudice() {
        return this.subjudice;
    }

    public void setSubjudice(Boolean subjudice) {
        this.subjudice = subjudice;
    }

    public String getJustificativa() {
        return this.justificativa;
    }

    public void setJustificativa(String justificativa) {
        this.justificativa = justificativa;
    }

    public ConcursoInscrito getConcursoInscrito() {
        return this.concursoInscrito;
    }

    public void setConcursoInscrito(ConcursoInscrito concursoInscrito) {
        this.concursoInscrito = concursoInscrito;
    }

    public Date getDataHomologacao() {
        return this.dataHomologacao;
    }

    public void setDataHomologacao(Date dataHomologacao) {
        this.dataHomologacao = dataHomologacao;
    }

    public ConcursoConvocadoSituacaoEnum getSituacao() {
        return ConcursoConvocadoSituacaoEnum.getBy(this.situacao);
    }

    public void setSituacao(ConcursoConvocadoSituacaoEnum situacao) {
        this.situacao = situacao != null ? situacao.getCodigo() : null;
    }

    public List<ConcursoConvocadoSituacao> getSituacoes() {
        return this.situacoes;
    }

    public void setSituacoes(List<ConcursoConvocadoSituacao> situacoes) {
        this.situacoes = situacoes;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.inscrito != null ? this.inscrito.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConcursoConvocado)) {
            return false;
        }
        ConcursoConvocado other = (ConcursoConvocado)object;
        return (this.inscrito != null || other.inscrito == null) && (this.inscrito == null || this.inscrito.equals(other.inscrito));
    }

    public String toString() {
        return "entity.ConcursoConvocado[ inscrito=" + this.inscrito + " ]";
    }
}

