/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Concurso;
import br.com.fiorilli.sip.persistence.entity.ConcursoComissaoTipo;
import br.com.fiorilli.sip.persistence.entity.DocumentoDigitalPDF;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.VeiculoPublicacao;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="CONCURSO_COMISSAO")
@Audited
public class ConcursoComissao
implements Serializable,
Documento {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_CONCURSOCOMISSAO";
    @Id
    @Column(name="CODIGO", unique=true, nullable=false)
    private int codigo;
    @Column(name="CPF", length=11)
    private String cpf;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATAPUBATO")
    private Date dataDcumento;
    @Column(name="DOCDIGITALPDF")
    private Integer documentoDigitalPDFCodigo;
    @JoinColumn(name="DOCDIGITALPDF", referencedColumnName="IDPDF", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private DocumentoDigitalPDF documentoDigitalPdf;
    @Column(name="NOME", length=60)
    private String nome;
    @Column(name="NUMATO", length=16)
    private String numeroDocumento;
    @Column(name="ORIGEM_MEMBRO", length=100)
    private String origemMembro;
    @Column(name="TIPOATO")
    private Integer tipoDocumentoCodigo;
    @Column(name="TIPOMEMBRO")
    private Short tipoMembro;
    @Column(name="VEICULO_PUBLICACAO")
    private Integer veiculoPublicacaoCodigo;
    @JoinColumn(name="VEICULO_PUBLICACAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private VeiculoPublicacao veiculoPublicacao;
    @Column(name="CONCURSO", nullable=false)
    private Integer concursoCodigo;
    @JoinColumn(name="CONCURSO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Concurso concurso;
    @JoinColumn(name="TIPOATO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoDocumento;

    public int getCodigo() {
        return this.codigo;
    }

    public void setCodigo(int codigo) {
        this.codigo = codigo;
    }

    public int getConcursoCodigo() {
        return this.concursoCodigo;
    }

    public void setConcursoCodigo(int concurso) {
        this.concursoCodigo = concurso;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public Integer getDocumentoDigitalPDFCodigo() {
        return this.documentoDigitalPDFCodigo;
    }

    public void setDocumentoDigitalPDFCodigo(Integer docdigitalpdf) {
        this.documentoDigitalPDFCodigo = docdigitalpdf;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getOrigemMembro() {
        return this.origemMembro;
    }

    public void setOrigemMembro(String origemMembro) {
        this.origemMembro = origemMembro;
    }

    public ConcursoComissaoTipo getTipoMembro() {
        return ConcursoComissaoTipo.get(this.tipoMembro);
    }

    public void setTipoMembro(ConcursoComissaoTipo tipoMembro) {
        this.tipoMembro = tipoMembro.getCodigo();
    }

    public Integer getVeiculoPublicacaoCodigo() {
        return this.veiculoPublicacaoCodigo;
    }

    public void setVeiculoPublicacaoCodigo(Integer veiculoPublicacaoCodigo) {
        this.veiculoPublicacaoCodigo = veiculoPublicacaoCodigo;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoDocumento;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal value) {
        this.tipoDocumentoCodigo = value != null ? value.getCodigo() : null;
        this.tipoDocumento = value;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoDocumentoCodigo;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String value) {
        this.numeroDocumento = value;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.dataDcumento;
    }

    @Override
    public void setData(Date value) {
        this.dataDcumento = value;
    }

    public VeiculoPublicacao getVeiculoPublicacao() {
        return this.veiculoPublicacao;
    }

    public void setVeiculoPublicacao(VeiculoPublicacao veiculoPublicacao) {
        this.veiculoPublicacaoCodigo = veiculoPublicacao != null ? veiculoPublicacao.getCodigo() : null;
        this.veiculoPublicacao = veiculoPublicacao;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.codigo;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConcursoComissao other = (ConcursoComissao)obj;
        return this.codigo == other.codigo;
    }

    public String toString() {
        return "ConcursoComissao [codigo=" + this.codigo + "]";
    }

    public DocumentoDigitalPDF getDocumentoDigitalPdf() {
        return this.documentoDigitalPdf;
    }

    public void setDocumentoDigitalPdf(DocumentoDigitalPDF documentoDigitalPdf) {
        this.documentoDigitalPdf = documentoDigitalPdf;
    }

    public Concurso getConcurso() {
        return this.concurso;
    }

    public void setConcurso(Concurso concurso) {
        this.concurso = concurso;
    }

    public void setConcursoCodigo(Integer concursoCodigo) {
        this.concursoCodigo = concursoCodigo;
    }
}

