/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.Concurso;
import br.com.fiorilli.sip.persistence.entity.ConcursoCargoAtividade;
import br.com.fiorilli.sip.persistence.entity.ConcursoInscrito;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CONCURSO_CARGOS")
@Audited
public class ConcursoCargo
implements Serializable,
Filterable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_CONCURSOCARGOS";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Basic(optional=false)
    @Column(name="NUMVAGAS")
    private Short numeroVagas;
    @Basic(optional=false)
    @Size(max=150)
    @Column(name="REQUISITO")
    private String requisito;
    @Basic(optional=false)
    @Size(max=150)
    @Column(name="ESPECIALIDADE")
    private String especialidade;
    @Basic(optional=false)
    @Size(max=60)
    @Column(name="LOCALIDADE")
    private String localidade;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @Basic(optional=false)
    @Size(min=1, max=4)
    @Column(name="CARGO")
    private String cargoCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CARGO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false)
    private Cargo cargo;
    @Column(name="CONCURSO")
    private Integer concursoCodigo;
    @JoinColumn(name="CONCURSO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Concurso concurso;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="cargoConcurso", fetch=FetchType.LAZY)
    private List<ConcursoInscrito> inscritos = new ArrayList<ConcursoInscrito>();
    @Column(name="ATRIBUICAO_PONTO_TITULO")
    @Type(type="BooleanTypeSip")
    private Boolean atribuicaoPontoTitulo;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="cargoConcurso", fetch=FetchType.LAZY)
    private List<ConcursoCargoAtividade> atividades = new ArrayList<ConcursoCargoAtividade>();
    @OneToMany(mappedBy="cargoConcurso", fetch=FetchType.LAZY)
    private List<Trabalhador> trabalhadores = new ArrayList<Trabalhador>();

    public ConcursoCargo() {
    }

    public ConcursoCargo(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public Short getNumeroVagas() {
        return this.numeroVagas;
    }

    public void setNumeroVagas(Short numvagas) {
        this.numeroVagas = numvagas;
    }

    public String getRequisito() {
        return this.requisito;
    }

    public void setRequisito(String requisito) {
        this.requisito = requisito;
    }

    public String getEspecialidade() {
        return this.especialidade;
    }

    public void setEspecialidade(String especialidade) {
        this.especialidade = especialidade;
    }

    public String getLocalidade() {
        return this.localidade;
    }

    public void setLocalidade(String localidade) {
        this.localidade = localidade;
    }

    public Cargo getCargo() {
        return this.cargo;
    }

    public void setCargo(Cargo cargo) {
        if (cargo != null) {
            this.cargoCodigo = cargo.getCargoPK().getCodigo();
        }
        this.cargo = cargo;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public String getCargoCodigo() {
        return this.cargoCodigo;
    }

    public void setCargoCodigo(String cargoCodigo) {
        this.cargoCodigo = cargoCodigo;
    }

    public Concurso getConcurso() {
        return this.concurso;
    }

    public void setConcurso(Concurso concurso) {
        this.concurso = concurso;
    }

    public Integer getConcursoCodigo() {
        return this.concursoCodigo;
    }

    public void setConcursoCodigo(Integer concursoCodigo) {
        this.concursoCodigo = concursoCodigo;
    }

    public List<ConcursoInscrito> getInscritos() {
        return this.inscritos;
    }

    public void setInscritos(List<ConcursoInscrito> inscritos) {
        this.inscritos = inscritos;
    }

    public Boolean getAtribuicaoPontoTitulo() {
        return this.atribuicaoPontoTitulo;
    }

    public void setAtribuicaoPontoTitulo(Boolean atribuicaoPontoTitulo) {
        this.atribuicaoPontoTitulo = atribuicaoPontoTitulo;
    }

    public List<ConcursoCargoAtividade> getAtividades() {
        return this.atividades;
    }

    public void setAtividades(List<ConcursoCargoAtividade> atividades) {
        this.atividades = atividades;
    }

    public List<Trabalhador> getTrabalhadores() {
        return this.trabalhadores;
    }

    public void setTrabalhadores(List<Trabalhador> trabalhadores) {
        this.trabalhadores = trabalhadores;
    }

    public void addInscrito(ConcursoInscrito inscrito) {
        if (this.getInscritos().contains(inscrito)) {
            this.getInscritos().remove(inscrito);
            this.getInscritos().add(inscrito);
            inscrito.setCargoConcurso(this);
        } else {
            this.getInscritos().add(inscrito);
            inscrito.setCargoConcurso(this);
        }
    }

    public void removeInscrito(ConcursoInscrito inscrito) {
        this.getInscritos().remove(inscrito);
        inscrito.setCargoConcurso(this);
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConcursoCargo)) {
            return false;
        }
        ConcursoCargo other = (ConcursoCargo)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.ConcursoCargos[ codigo=" + this.codigo + " ]";
    }

    public String getItemId() {
        return String.valueOf(this.cargoCodigo);
    }

    public String getItemLabel() {
        return this.cargo.getNome();
    }
}

