/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.ConcursoCargo;
import br.com.fiorilli.sip.persistence.entity.ConcursoComissao;
import br.com.fiorilli.sip.persistence.entity.ConcursoEdital;
import br.com.fiorilli.sip.persistence.entity.ConcursoFase;
import br.com.fiorilli.sip.persistence.entity.ConcursoModalidade;
import br.com.fiorilli.sip.persistence.entity.DocumentoCriacaoConcurso;
import br.com.fiorilli.sip.persistence.entity.DocumentoDigital;
import br.com.fiorilli.sip.persistence.entity.DocumentoProrrogacaoConcurso;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.RegimeJuridico;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CONCURSO")
@FilterConfigType(autoFilter=true)
@Audited
public class Concurso
implements Serializable,
Filterable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_FOR_FILTER = "SELECT c FROM Concurso c WHERE UPPER(c.descricao) LIKE UPPER('%'||:param||'%') ORDER BY c.descricao";
    public static final String GENERATOR = "GEN_CONCURSO";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @FilterConfig(label="Descri\u00e7\u00e3o", condition=FilterCondition.COMECE, inputType=FilterInputType.TEXT, order=2)
    @Size(max=150)
    @Column(name="DESCRICAO")
    private String descricao;
    @FilterConfig(label="N\u00famero", condition=FilterCondition.COMECE, inputType=FilterInputType.TEXT, order=1)
    @Size(max=16)
    @Column(name="NUMCONCURSO")
    private String numeroConcurso;
    @FilterConfig(label="Data do Concurso", condition=FilterCondition.IGUAL, inputType=FilterInputType.CALENDAR, order=3)
    @Column(name="DTCONCURSO")
    @Temporal(value=TemporalType.DATE)
    private Date dataConcurso;
    @Column(name="PRAZOINICIAL")
    @Temporal(value=TemporalType.DATE)
    private Date prazoInicial;
    @Column(name="PRAZOFINAL")
    @Temporal(value=TemporalType.DATE)
    private Date prazoFinal;
    @Column(name="PRAZOPRORROGADO")
    @Temporal(value=TemporalType.DATE)
    private Date prazoProrrogado;
    @Column(name="MODALIDADE")
    private Integer modalidade;
    @Enumerated
    @Column(name="REGIME_JURIDICO")
    private RegimeJuridico regimeJuridico;
    @Column(name="FASE")
    private Integer fase;
    @Embedded
    private DocumentoCriacaoConcurso documentoCriacao;
    @Embedded
    private DocumentoProrrogacaoConcurso documentoProrrogacao;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Entidade entidade;
    @Column(name="DOCAUTORIZACAO")
    private Integer documentoAutorizacaoCodigo;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @JoinColumn(name="DOCAUTORIZACAO", referencedColumnName="IDDOCDIGITAL", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private DocumentoDigital documentoAutorizacao;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="concurso", fetch=FetchType.LAZY)
    private List<ConcursoEdital> editais = new ArrayList<ConcursoEdital>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="concurso", fetch=FetchType.LAZY)
    private List<ConcursoCargo> cargos = new ArrayList<ConcursoCargo>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="concurso", fetch=FetchType.LAZY)
    private List<ConcursoComissao> comissoes = new ArrayList<ConcursoComissao>();
    @Column(name="PRORROGAVELVALIDADE")
    @Type(type="BooleanTypeSip")
    private Boolean prazoPorrogavel;
    @Column(name="PREVISAO_PRORROGACAO")
    private Date previsaoProrrogacao;
    @Column(name="PERC_VAGAS_AFRODESCENDENTE")
    private Double percentualVagaAfrodescendente;
    @Column(name="PERC_VAGAS_DEFICIENTE")
    private Double percentualVagaDeficiente;
    @Column(name="FATOR_ARREDONDAMENTO_VAGAS")
    private Short fatorArredondamentoVagas;

    public Concurso() {
    }

    public Concurso(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getNumeroConcurso() {
        return this.numeroConcurso;
    }

    public void setNumeroConcurso(String numconcurso) {
        this.numeroConcurso = numconcurso;
    }

    public Date getDataConcurso() {
        return this.dataConcurso;
    }

    public void setDataConcurso(Date dtconcurso) {
        this.dataConcurso = dtconcurso;
    }

    public Date getPrazoInicial() {
        return this.prazoInicial;
    }

    public void setPrazoInicial(Date prazoinicial) {
        this.prazoInicial = prazoinicial;
    }

    public Date getPrazoProrrogado() {
        return this.prazoProrrogado;
    }

    public void setPrazoProrrogado(Date prazoprorrogado) {
        this.prazoProrrogado = prazoprorrogado;
    }

    public ConcursoModalidade getModalidade() {
        return ConcursoModalidade.get(this.modalidade);
    }

    public void setModalidade(ConcursoModalidade modalidade) {
        this.modalidade = modalidade.getCodigo();
    }

    public RegimeJuridico getRegimeJuridico() {
        return this.regimeJuridico;
    }

    public void setRegimeJuridico(RegimeJuridico regimeJuridico) {
        this.regimeJuridico = regimeJuridico;
    }

    public ConcursoFase getFase() {
        return ConcursoFase.get(this.fase);
    }

    public void setFase(ConcursoFase fase) {
        this.fase = fase.getCodigo();
    }

    public List<ConcursoCargo> getCargos() {
        return this.cargos;
    }

    public void setCargos(List<ConcursoCargo> concursoCargosList) {
        this.cargos = concursoCargosList;
    }

    public List<ConcursoEdital> getEditais() {
        return this.editais;
    }

    public void setEditais(List<ConcursoEdital> concursoEditalList) {
        this.editais = concursoEditalList;
    }

    public Entidade getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    public DocumentoDigital getDocumentoAutorizacao() {
        return this.documentoAutorizacao;
    }

    public void setDocumentoAutorizacao(DocumentoDigital documentoAutorizacao) {
        this.documentoAutorizacaoCodigo = documentoAutorizacao != null ? documentoAutorizacao.getId() : null;
        this.documentoAutorizacao = documentoAutorizacao;
    }

    public List<ConcursoComissao> getComissoes() {
        return this.comissoes;
    }

    public void setComissoes(List<ConcursoComissao> concursoComissaoList) {
        this.comissoes = concursoComissaoList;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public Integer getDocumentoAutorizacaoCodigo() {
        return this.documentoAutorizacaoCodigo;
    }

    public void setDocumentoAutorizacaoCodigo(Integer documentoAutorizacaoCodigo) {
        this.documentoAutorizacaoCodigo = documentoAutorizacaoCodigo;
    }

    public Date getPrazoFinal() {
        return this.prazoFinal;
    }

    public void setPrazoFinal(Date prazoFinal) {
        this.prazoFinal = prazoFinal;
    }

    public DocumentoCriacaoConcurso getDocumentoCriacao() {
        if (this.documentoCriacao == null) {
            this.documentoCriacao = new DocumentoCriacaoConcurso();
        }
        return this.documentoCriacao;
    }

    public void setDocumentoCriacao(DocumentoCriacaoConcurso documentoCriacao) {
        this.documentoCriacao = documentoCriacao;
    }

    public DocumentoProrrogacaoConcurso getDocumentoProrrogacao() {
        if (this.documentoProrrogacao == null) {
            this.documentoProrrogacao = new DocumentoProrrogacaoConcurso();
        }
        return this.documentoProrrogacao;
    }

    public void setDocumentoProrrogacao(DocumentoProrrogacaoConcurso documentoProrrogacao) {
        this.documentoProrrogacao = documentoProrrogacao;
    }

    public Boolean getPrazoPorrogavel() {
        return this.prazoPorrogavel;
    }

    public void setPrazoPorrogavel(Boolean prazoPorrogavel) {
        this.prazoPorrogavel = prazoPorrogavel;
    }

    public Date getPrevisaoProrrogacao() {
        return this.previsaoProrrogacao;
    }

    public void setPrevisaoProrrogacao(Date previsaoProrrogacao) {
        this.previsaoProrrogacao = previsaoProrrogacao;
    }

    public Double getPercentualVagaAfrodescendente() {
        return this.percentualVagaAfrodescendente;
    }

    public void setPercentualVagaAfrodescendente(Double percentualVagaAfrodescendente) {
        this.percentualVagaAfrodescendente = percentualVagaAfrodescendente;
    }

    public Double getPercentualVagaDeficiente() {
        return this.percentualVagaDeficiente;
    }

    public void setPercentualVagaDeficiente(Double percentualVagaDeficiente) {
        this.percentualVagaDeficiente = percentualVagaDeficiente;
    }

    public Short getFatorArredondamentoVagas() {
        return this.fatorArredondamentoVagas;
    }

    public void setFatorArredondamentoVagas(Short fatorArredondamentoVagas) {
        this.fatorArredondamentoVagas = fatorArredondamentoVagas;
    }

    public void addEdital(ConcursoEdital edital) {
        if (this.getEditais().contains(edital)) {
            this.getEditais().remove(edital);
            this.getEditais().add(edital);
            edital.setConcurso(this);
        } else {
            this.getEditais().add(edital);
            edital.setConcurso(this);
            edital.setConcursoCodigo(this.codigo);
        }
    }

    public void removeEdital(ConcursoEdital edital) {
        this.getEditais().remove(edital);
        edital.setConcurso(null);
    }

    public void addCargo(ConcursoCargo cargo) {
        if (this.getCargos().contains(cargo)) {
            this.getCargos().remove(cargo);
            this.getCargos().add(cargo);
            cargo.setConcurso(this);
        } else {
            this.getCargos().add(cargo);
            cargo.setConcurso(this);
            cargo.setConcursoCodigo(this.codigo);
        }
    }

    public void removeCargo(ConcursoCargo cargo) {
        this.getCargos().remove(cargo);
        cargo.setConcurso(null);
    }

    public void addComissao(ConcursoComissao comissao) {
        if (this.getComissoes().contains(comissao)) {
            this.getComissoes().remove(comissao);
            this.getComissoes().add(comissao);
            comissao.setConcurso(this);
        } else {
            this.getComissoes().add(comissao);
            comissao.setConcurso(this);
            comissao.setConcursoCodigo(this.codigo);
        }
    }

    public void removeComissao(ConcursoComissao comissao) {
        this.getComissoes().remove(comissao);
        comissao.setConcurso(null);
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Concurso)) {
            return false;
        }
        Concurso other = (Concurso)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.Concurso[ codigo=" + this.codigo + " ]";
    }

    public String getItemId() {
        return String.valueOf(this.hashCode());
    }

    public String getItemLabel() {
        return this.descricao;
    }
}

