/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.commons.util.TimeUtils;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.CompensacaoHorasPK;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

@FilterConfigType(autoFilter=true)
@Entity
@Table(name="HORASCOMPENSACAO")
@Audited
public class CompensacaoHoras
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GET_NEXT_ITEM = "SELECT COALESCE(MAX(c.compensacaoHorasPK.item), 0) + 1 FROM CompensacaoHoras c WHERE c.trabalhador.trabalhadorPK = :trabalhadorPK";
    public static final String GET_FETCHED = "SELECT co FROM CompensacaoHoras co LEFT JOIN FETCH co.trabalhador WHERE co.compensacaoHorasPK = :pk";
    public static final String GET_BY_TRABALHADOR_AND_DATA_COMPENSACAO = "SELECT c FROM CompensacaoHoras c WHERE c.trabalhador.trabalhadorPK = :trabalhadorPK AND c.dataCompensacao = :dataCompensacao \tAND c.compensacaoHorasPK.item <> :item ";
    @EmbeddedId
    protected CompensacaoHorasPK compensacaoHorasPK;
    @FilterConfig(label="Dt. Compensa\u00e7\u00e3o", inputType=FilterInputType.CALENDAR, condition=FilterCondition.INTERVALO)
    @Basic(optional=false)
    @NotNull
    @Column(name="DTCOMPENSACAO")
    @Temporal(value=TemporalType.DATE)
    private Date dataCompensacao;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=5)
    @Column(name="HR_COMPENSA_INI")
    private String horaCompensacaoInicial;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=5)
    @Column(name="HR_COMPENSA_FIM")
    private String horaCompensacaoFinal;
    @FilterConfig(label="Dt. Referente", inputType=FilterInputType.CALENDAR, condition=FilterCondition.INTERVALO)
    @Basic(optional=false)
    @NotNull
    @Column(name="DTREFERENTE")
    @Temporal(value=TemporalType.DATE)
    private Date dataReferente;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=5)
    @Column(name="HR_REFERENTE_INI")
    private String horaReferenteInicial;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=5)
    @Column(name="HR_REFERENTE_FIM")
    private String horaReferenteFinal;
    @Size(max=150)
    @Column(name="MOTIVO")
    private String motivo;
    @FilterConfig(label="Trabalhador", inputType=FilterInputType.AUTO_COMPLETE, blockCondition=true)
    @FilterConfigSelect(query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo", itemLabel="nome")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;

    public CompensacaoHoras() {
        this.compensacaoHorasPK = new CompensacaoHorasPK();
    }

    public CompensacaoHoras(CompensacaoHorasPK compensacaoHorasPK) {
        this.compensacaoHorasPK = compensacaoHorasPK;
    }

    public CompensacaoHoras(CompensacaoHorasPK compensacaoHorasPK, Date dtcompensacao, String hrCompensaIni, String hrCompensaFim, Date dtreferente, String hrReferenteIni, String hrReferenteFim) {
        this.compensacaoHorasPK = compensacaoHorasPK;
        this.dataCompensacao = dtcompensacao;
        this.horaCompensacaoInicial = hrCompensaIni;
        this.horaCompensacaoFinal = hrCompensaFim;
        this.dataReferente = dtreferente;
        this.horaReferenteInicial = hrReferenteIni;
        this.horaReferenteFinal = hrReferenteFim;
    }

    public CompensacaoHoras(String entidade, String registro, short item) {
        this.compensacaoHorasPK = new CompensacaoHorasPK(entidade, registro, item);
    }

    public CompensacaoHorasPK getCompensacaoHorasPK() {
        return this.compensacaoHorasPK;
    }

    public void setCompensacaoHorasPK(CompensacaoHorasPK compensacaoHorasPK) {
        this.compensacaoHorasPK = compensacaoHorasPK;
    }

    public Date getDataCompensacao() {
        return this.dataCompensacao;
    }

    public void setDataCompensacao(Date dtcompensacao) {
        this.dataCompensacao = dtcompensacao;
    }

    public String getHoraCompensacaoInicial() {
        return this.horaCompensacaoInicial;
    }

    public void setHoraCompensacaoInicial(String hrCompensaIni) {
        this.horaCompensacaoInicial = hrCompensaIni;
    }

    public String getHoraCompensacaoFinal() {
        return this.horaCompensacaoFinal;
    }

    public void setHoraCompensacaoFinal(String hrCompensaFim) {
        this.horaCompensacaoFinal = hrCompensaFim;
    }

    public Date getDataReferente() {
        return this.dataReferente;
    }

    public void setDataReferente(Date dtreferente) {
        this.dataReferente = dtreferente;
    }

    public String getHoraReferenteInicial() {
        return this.horaReferenteInicial;
    }

    public void setHoraReferenteInicial(String hrReferenteIni) {
        this.horaReferenteInicial = hrReferenteIni;
    }

    public String getHoraReferenteFinal() {
        return this.horaReferenteFinal;
    }

    public void setHoraReferenteFinal(String hrReferenteFim) {
        this.horaReferenteFinal = hrReferenteFim;
    }

    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        if (trabalhador != null) {
            this.compensacaoHorasPK.setEntidade(trabalhador.trabalhadorPK.getEntidade());
            this.compensacaoHorasPK.setRegistro(trabalhador.trabalhadorPK.getRegistro());
        } else {
            this.compensacaoHorasPK.setEntidade(null);
            this.compensacaoHorasPK.setRegistro(null);
        }
        this.trabalhador = trabalhador;
    }

    public Interval getIntervalOfReferencia() {
        DateTime start = TimeUtils.toDateTime((Date)this.getDataReferente(), (String)this.getHoraReferenteInicial());
        DateTime end = TimeUtils.toDateTime((Date)this.getDataReferente(), (String)this.getHoraReferenteFinal());
        if (start != null && end != null && end.isAfter((ReadableInstant)start)) {
            return new Interval((ReadableInstant)start, (ReadableInstant)end);
        }
        return null;
    }

    public Interval getIntervalOfCompensacao() {
        DateTime start = TimeUtils.toDateTime((Date)this.getDataCompensacao(), (String)this.getHoraCompensacaoInicial());
        DateTime end = TimeUtils.toDateTime((Date)this.getDataCompensacao(), (String)this.getHoraCompensacaoFinal());
        if (start != null && end != null && end.isAfter((ReadableInstant)start)) {
            return new Interval((ReadableInstant)start, (ReadableInstant)end);
        }
        return null;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.compensacaoHorasPK != null ? this.compensacaoHorasPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CompensacaoHoras)) {
            return false;
        }
        CompensacaoHoras other = (CompensacaoHoras)object;
        return (this.compensacaoHorasPK != null || other.compensacaoHorasPK == null) && (this.compensacaoHorasPK == null || this.compensacaoHorasPK.equals(other.compensacaoHorasPK));
    }

    public String toString() {
        return "entity.Horascompensacao[ horascompensacaoPK=" + this.compensacaoHorasPK + " ]";
    }
}

