/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Comissao;
import br.com.fiorilli.sip.persistence.entity.ComissaoMembroPK;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="COMISSAO_MEMBROS")
@Audited
public class ComissaoMembro
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_COMISSAO = "SELECT c FROM ComissaoMembro c JOIN FETCH c.trabalhador WHERE c.comissao.codigo = :comissaoId ORDER BY c.trabalhador.nome";
    @EmbeddedId
    private ComissaoMembroPK id = new ComissaoMembroPK();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="COMISSAO", insertable=false, updatable=false)
    private Comissao comissao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador trabalhador;

    public ComissaoMembroPK getId() {
        return this.id;
    }

    public void setId(ComissaoMembroPK id) {
        this.id = id;
    }

    public Comissao getComissao() {
        return this.comissao;
    }

    public void setComissao(Comissao comissaoBean) {
        if (comissaoBean != null) {
            this.id.setComissaoCodigo(comissaoBean.getCodigo());
        } else {
            this.id.setComissaoCodigo(0);
        }
        this.comissao = comissaoBean;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        if (trabalhador != null) {
            this.id.setRegistro(trabalhador.getTrabalhadorPK().getRegistro());
            this.id.setEntidade(trabalhador.getTrabalhadorPK().getEntidade());
        } else {
            this.id.setRegistro(null);
            this.id.setEntidade(null);
        }
        this.trabalhador = trabalhador;
    }

    public String toString() {
        return "ComissaoMembro [id=" + this.id + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComissaoMembro other = (ComissaoMembro)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

