/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.ComissaoMembro;
import br.com.fiorilli.sip.persistence.entity.ProcedimentoAdministrativo;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="COMISSAO")
@Audited
public class Comissao
implements Serializable,
Filterable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_COMISSAO";
    public static final String FIND_BY_TRABALHADOR = "SELECT DISTINCT c FROM Comissao c JOIN FETCH c.responsavel LEFT JOIN c.membros m WHERE c.responsavel.trabalhadorPK = :trabalhadorPK OR m.trabalhador.trabalhadorPK = :trabalhadorPK ORDER BY c.codigo DESC";
    public static final String GET_FETCHED_BY_ID = "SELECT co FROM Comissao co LEFT JOIN FETCH co.responsavel WHERE co.codigo = :codigo";
    @FilterConfig(label="C\u00f3digo", order=1)
    @Id
    @Column(unique=true, nullable=false)
    private int codigo;
    @FilterConfig(label="Descri\u00e7\u00e3o", order=2)
    @Column(length=150)
    private String descricao;
    @Column(name="EMPRESA", nullable=false, length=3)
    private String entidade;
    @Column(name="obs", length=150)
    private String observacao;
    @Column(nullable=false, length=6)
    private String registro;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="comissao", fetch=FetchType.LAZY, orphanRemoval=true)
    private List<ComissaoMembro> membros = new ArrayList<ComissaoMembro>();
    @OneToMany(mappedBy="comissao", fetch=FetchType.LAZY)
    private List<ProcedimentoAdministrativo> procedimentosAdministrativos;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador responsavel;

    public int getCodigo() {
        return this.codigo;
    }

    public void setCodigo(int codigo) {
        this.codigo = codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String empresa) {
        this.entidade = empresa;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String obs) {
        this.observacao = obs;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public List<ComissaoMembro> getMembros() {
        return this.membros;
    }

    public void setMembros(List<ComissaoMembro> comissaoMembros) {
        this.membros = comissaoMembros;
    }

    public ComissaoMembro addMembro(ComissaoMembro comissaoMembro) {
        this.membros.add(comissaoMembro);
        comissaoMembro.setComissao(this);
        return comissaoMembro;
    }

    public ComissaoMembro removeMembro(ComissaoMembro comissaoMembro) {
        this.membros.remove(comissaoMembro);
        comissaoMembro.setComissao(null);
        return comissaoMembro;
    }

    public List<ProcedimentoAdministrativo> getProcedimentosAdministrativos() {
        return this.procedimentosAdministrativos;
    }

    public void setProcedimentosAdministrativos(List<ProcedimentoAdministrativo> procAdms) {
        this.procedimentosAdministrativos = procAdms;
    }

    public ProcedimentoAdministrativo addProcAdm(ProcedimentoAdministrativo procAdm) {
        this.getProcedimentosAdministrativos().add(procAdm);
        procAdm.setComissao(this);
        return procAdm;
    }

    public ProcedimentoAdministrativo removeProcAdm(ProcedimentoAdministrativo procAdm) {
        this.getProcedimentosAdministrativos().remove(procAdm);
        procAdm.setComissao(null);
        return procAdm;
    }

    public Trabalhador getResponsavel() {
        return this.responsavel;
    }

    public void setResponsavel(Trabalhador trabalhador) {
        if (trabalhador != null) {
            this.entidade = trabalhador.getTrabalhadorPK().getEntidade();
            this.registro = trabalhador.getTrabalhadorPK().getRegistro();
        } else {
            this.entidade = null;
            this.registro = null;
        }
        this.responsavel = trabalhador;
    }

    public String getItemLabel() {
        return this.descricao;
    }

    public String getItemId() {
        return Integer.toString(this.codigo);
    }
}

