/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.ColetorREPHistoricoIncosistencia;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="COLETOR_REP_HIST")
@SequenceGenerator(name="INC_COLETOR_REP_HISTORICO", sequenceName="GEN_COLETOR_REP_HIST", allocationSize=1)
@Audited
public class ColetorRepHistorico
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="ID")
    @GeneratedValue(generator="INC_COLETOR_REP_HISTORICO", strategy=GenerationType.AUTO)
    private Integer id;
    @NotNull
    @Column(name="REP_CONFIG_ID")
    private Integer repConfigId;
    @NotNull
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DH_COLETA")
    private Date dataColeta;
    @Type(type="BooleanTypeSip")
    @Column(name="COLETADO")
    private Boolean coletado;
    @Type(type="BooleanTypeSip")
    @Column(name="IMPORTADO")
    private Boolean importado;
    @Column(name="MSG_ERRO")
    @Size(max=256)
    private String msgErro;
    @Column(name="LAST_NSR")
    private Integer lastNsr;
    @OneToMany(mappedBy="coletorRepHistorico", cascade={CascadeType.PERSIST})
    private List<ColetorREPHistoricoIncosistencia> inconsistencia;

    public ColetorRepHistorico() {
    }

    public ColetorRepHistorico(Builder b) {
        this.repConfigId = b.repConfigId;
        this.dataColeta = b.dataColeta;
        this.coletado = b.coletado;
        this.importado = b.importado;
        this.msgErro = b.msgErro;
        this.inconsistencia = b.inconsistencias;
        this.lastNsr = b.lastNsr;
        if (this.inconsistencia != null) {
            for (ColetorREPHistoricoIncosistencia tmp : this.inconsistencia) {
                tmp.setColetorRepHistorico(this);
            }
        }
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getRepConfigId() {
        return this.repConfigId;
    }

    public void setRepConfigId(Integer repConfigId) {
        this.repConfigId = repConfigId;
    }

    public Date getDataColeta() {
        return this.dataColeta;
    }

    public void setDataColeta(Date dataColeta) {
        this.dataColeta = dataColeta;
    }

    public Boolean getColetado() {
        return this.coletado;
    }

    public void setColetado(Boolean coletado) {
        this.coletado = coletado;
    }

    public Boolean getImportado() {
        return this.importado;
    }

    public void setImportado(Boolean importado) {
        this.importado = importado;
    }

    public String getMsgErro() {
        return this.msgErro;
    }

    public void setMsgErro(String msgErro) {
        this.msgErro = msgErro;
    }

    public List<ColetorREPHistoricoIncosistencia> getInconsistencia() {
        return this.inconsistencia;
    }

    public Integer getLastNsr() {
        return this.lastNsr;
    }

    public void addInconsistencia(ColetorREPHistoricoIncosistencia incosistencia) {
        this.getInconsistencia().add(incosistencia);
        incosistencia.setColetorRepHistorico(this);
    }

    public String toString() {
        return "ColetorRepHistorico [id=" + this.id + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColetorRepHistorico other = (ColetorRepHistorico)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public static class ColetorRepHistoricoSql {
        public static final String GET_BY_ID = "SELECT c FROM ColetorRepHistorico c  LEFT JOIN FETCH c.inconsistencia  WHERE c.repConfigId = :id ORDER BY c.dataColeta desc ";
    }

    public static class Builder {
        private Integer repConfigId;
        private Date dataColeta;
        private boolean coletado = false;
        private boolean importado = false;
        private String msgErro;
        private List<ColetorREPHistoricoIncosistencia> inconsistencias = new ArrayList<ColetorREPHistoricoIncosistencia>();
        private Integer lastNsr = null;

        public ColetorRepHistorico build() {
            return new ColetorRepHistorico(this);
        }

        public Builder(Integer repConfigId, Date dataColeta) {
            this.repConfigId = repConfigId;
            this.dataColeta = dataColeta;
        }

        public Builder coletado(boolean coletado) {
            this.coletado = coletado;
            return this;
        }

        public boolean coletado() {
            return this.coletado;
        }

        public Builder importado(boolean importado) {
            this.importado = importado;
            return this;
        }

        public Builder msgErro(String msgErro) {
            this.msgErro = msgErro;
            return this;
        }

        public Builder defaultMessage(int totalOfExceptions) {
            this.msgErro = String.format("Foram encontradas %d inconsist\u00eancias", totalOfExceptions);
            return this;
        }

        public Builder addInconsistencia(ColetorREPHistoricoIncosistencia inconsistencia) {
            this.inconsistencias.add(inconsistencia);
            return this;
        }

        public Builder data(Date data) {
            this.dataColeta = data;
            return this;
        }

        public Builder lastNsr(Integer lastNsrImportado) {
            this.lastNsr = lastNsrImportado;
            return this;
        }
    }
}

