/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.ArquivoDePontoInconsistenciaTipo;
import br.com.fiorilli.sip.persistence.entity.ColetorRepHistorico;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="COLETOR_REP_HIST_INC")
@SequenceGenerator(name="INC_COLETOR_REP_HISTORICO_INCO", sequenceName="GEN_COLETORREPHISTINC", allocationSize=1)
@Audited
public class ColetorREPHistoricoIncosistencia {
    @Id
    @NotNull
    @GeneratedValue(generator="INC_COLETOR_REP_HISTORICO_INCO", strategy=GenerationType.AUTO)
    private Integer id;
    @Column(name="MENSAGEM", length=256)
    private String mensagem;
    @Enumerated
    @Column(name="TIPO")
    private ArquivoDePontoInconsistenciaTipo tipo;
    @Column(name="LINHA")
    private Integer linha;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="COLETA_ID", referencedColumnName="ID")
    private ColetorRepHistorico coletorRepHistorico;

    public ColetorREPHistoricoIncosistencia() {
    }

    public ColetorREPHistoricoIncosistencia(Builder b) {
        this.mensagem = b.mensagem;
        this.tipo = b.tipo;
        this.linha = b.linha;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getMensagem() {
        return this.mensagem;
    }

    public void setMensagem(String mensagem) {
        this.mensagem = mensagem;
    }

    public ArquivoDePontoInconsistenciaTipo getTipo() {
        return this.tipo;
    }

    public void setTipo(ArquivoDePontoInconsistenciaTipo tipo) {
        this.tipo = tipo;
    }

    public Integer getLinha() {
        return this.linha;
    }

    public void setLinha(Integer linha) {
        this.linha = linha;
    }

    public ColetorRepHistorico getColetorRepHistorico() {
        return this.coletorRepHistorico;
    }

    public void setColetorRepHistorico(ColetorRepHistorico coletorRepHistorico) {
        this.coletorRepHistorico = coletorRepHistorico;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColetorREPHistoricoIncosistencia that = (ColetorREPHistoricoIncosistencia)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public static class Builder {
        private String mensagem;
        private ArquivoDePontoInconsistenciaTipo tipo;
        private Integer linha;

        public ColetorREPHistoricoIncosistencia build() {
            return new ColetorREPHistoricoIncosistencia(this);
        }

        public Builder mensagem(String mensagem) {
            this.mensagem = mensagem;
            return this;
        }

        public Builder tipo(ArquivoDePontoInconsistenciaTipo tipo) {
            this.tipo = tipo;
            return this;
        }

        public Builder linha(Integer linha) {
            this.linha = linha;
            return this;
        }
    }
}

