/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="CODSAQUE")
@Audited
public class CodigoSaque
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=2)
    @Column(name="CODIGO")
    private String codigo;
    @Lob
    @Column(name="DESCRICAO")
    private byte[] nome;

    public CodigoSaque() {
    }

    public CodigoSaque(String codigo) {
        this.codigo = codigo;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getNomeReduzido() {
        return new String(this.nome).substring(0, 50);
    }

    public String getNomeCompleto() {
        return new String(this.nome);
    }

    public byte[] getNome() {
        return this.nome;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CodigoSaque)) {
            return false;
        }
        CodigoSaque other = (CodigoSaque)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.Codsaque[ codigo=" + this.codigo + " ]";
    }
}

