/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.CodigoMovimentoSefipGrupo;
import br.com.fiorilli.sip.persistence.entity.MovimentoSefip;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="CODMOVSEFIP")
@Audited
public class CodigoMovimentoSefip
implements Serializable,
GenericEntity {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_CODIGO_GRUPO = "SELECT c FROM CodigoMovimentoSefip c WHERE c.codigo = :codigo AND c.codigoMovimentoSefipGrupo.codigo = :codigoGrupo";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="ID")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=2)
    @Column(name="CODIGO")
    private String codigo;
    @Size(max=200)
    @Column(name="NOME")
    private String nome;
    @Column(name="TIPO")
    private String tipo;
    @Size(max=2)
    @Column(name="RAIS")
    private String rais;
    @Size(max=2)
    @Column(name="RETORNO")
    private String retorno;
    @JoinColumn(name="ID_GRUPO_CODMOVSEFIP", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private CodigoMovimentoSefipGrupo codigoMovimentoSefipGrupo;
    @OneToMany(mappedBy="codigoMovimentoSefipEntrada", fetch=FetchType.LAZY)
    private List<MovimentoSefip> movtosefipList;
    @OneToMany(mappedBy="codigoMovimentoSefipSaida", fetch=FetchType.LAZY)
    private List<MovimentoSefip> movtosefipList1;

    public CodigoMovimentoSefip() {
    }

    public CodigoMovimentoSefip(Integer id) {
        this.id = id;
    }

    public CodigoMovimentoSefip(Integer id, String codigo) {
        this.id = id;
        this.codigo = codigo;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public String getRais() {
        return this.rais;
    }

    public void setRais(String rais) {
        this.rais = rais;
    }

    public String getRetorno() {
        return this.retorno;
    }

    public void setRetorno(String retorno) {
        this.retorno = retorno;
    }

    public CodigoMovimentoSefipGrupo getCodigoMovimentoSefipGrupo() {
        return this.codigoMovimentoSefipGrupo;
    }

    public void setCodigoMovimentoSefipGrupo(CodigoMovimentoSefipGrupo idGrupoCodmovsefip) {
        this.codigoMovimentoSefipGrupo = idGrupoCodmovsefip;
    }

    public List<MovimentoSefip> getMovtosefipList() {
        return this.movtosefipList;
    }

    public void setMovtosefipList(List<MovimentoSefip> movtosefipList) {
        this.movtosefipList = movtosefipList;
    }

    public List<MovimentoSefip> getMovtosefipList1() {
        return this.movtosefipList1;
    }

    public void setMovtosefipList1(List<MovimentoSefip> movtosefipList1) {
        this.movtosefipList1 = movtosefipList1;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CodigoMovimentoSefip)) {
            return false;
        }
        CodigoMovimentoSefip other = (CodigoMovimentoSefip)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "CodigoMovimentoSefip{id=" + this.id + ", codigo='" + this.codigo + '\'' + ", nome='" + this.nome + '\'' + ", tipo='" + this.tipo + '\'' + ", rais='" + this.rais + '\'' + ", retorno='" + this.retorno + '\'' + '}';
    }

    @Override
    public String getHashId() {
        return this.codigo;
    }

    public static class CodigoMovimentoSefipSql {
        public static final String DOES_EXIST_BY_CODIGO_AND_CODIGOGRUPO = " SELECT COUNT(c.codigo)  FROM CodigoMovimentoSefip c  WHERE c.codigo = :codigo  AND c.codigoMovimentoSefipGrupo.codigo = :codigoGrupo ";
    }
}

