/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Causa;
import br.com.fiorilli.sip.persistence.entity.CodigoAfastamentoSituacaoTcmgo;
import br.com.fiorilli.sip.persistence.entity.FaixaPagamentoBeneficio;
import br.com.fiorilli.sip.persistence.entity.SefipReduzidoPK;
import br.com.fiorilli.sip.persistence.entity.SefipReduzidoTipoLimite;
import br.com.fiorilli.sip.persistence.entity.TipoAfastamentoTceMg;
import br.com.fiorilli.sip.persistence.entity.TipoMovimentoESocial;
import br.gov.sp.tce.persistence.entity.SituacaoLotacaoAudesp;
import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SEFIPREDUZIDO")
@Audited
public class CodigoAfastamento
implements Serializable,
GenericEntity {
    public static final String QUERY_FIND_POR_ENTIDADE = "SELECT r FROM CodigoAfastamento r WHERE r.sefipReduzidoPK.entidade = :entidadeId";
    public static final String QUERY_FIND_ALL = "SELECT r FROM CodigoAfastamento r ";
    public static final String FIND_BY_NOME_ENTIDADE = "SELECT r FROM CodigoAfastamento r WHERE r.nome LIKE '%' || :nome || '%' AND  r.sefipReduzidoPK.entidade = coalesce(:entidadeId, r.sefipReduzidoPK.entidade)";
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected SefipReduzidoPK sefipReduzidoPK;
    @FilterConfig(label="Nome", condition=FilterCondition.COMECE)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Size(max=2)
    @Column(name="SEFIPENT")
    private String sefipEntrada;
    @Size(max=2)
    @Column(name="SEFIPSAI")
    private String sefipSaida;
    @Column(name="DIAS")
    private Short dias;
    @Column(name="DIAS_LIMITE")
    private Short diasLimite;
    @Enumerated
    @Column(name="TIPO_LIMITE")
    private SefipReduzidoTipoLimite tipoLimite;
    @Column(name="ABATE_TEMPOSERVICO")
    @Type(type="BooleanTypeSip")
    private Boolean abateTempoServico;
    @Column(name="ABATE_LICENCAPREMIO")
    @Type(type="BooleanTypeSip")
    private Boolean abateLicencaPremio;
    @Column(name="ABATE_FERIAS")
    @Type(type="BooleanTypeSip")
    private Boolean abateFerias;
    @Column(name="CAUSA", length=2)
    private String causaCodigo;
    @Column(name="CODIGO_AUDESP")
    @Enumerated
    private SituacaoLotacaoAudesp codigoAudesp;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="SITUACAO_TCMGO", referencedColumnName="ID")
    private CodigoAfastamentoSituacaoTcmgo situacaoTcmgo;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="CAUSA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Causa causa;
    @Column(name="TIPO_MOVIMENTO_ESOCIAL")
    private Integer tipoMovimentoESocialId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TIPO_MOVIMENTO_ESOCIAL", referencedColumnName="ID", insertable=false, updatable=false)
    private TipoMovimentoESocial tipoMovimentoESocial;
    @Column(name="TIPO_ONUS_CESSAO")
    private Integer tipoOnusCessao;
    @Column(name="FAIXAS_PAGAMENTO_BENEFICIO")
    @Type(type="BooleanTypeSip")
    private Boolean faixasPagamentoBeneficio;
    @Column(name="GATILHO_GRADE_SUBSTITUICAO")
    @Type(type="BooleanTypeSip")
    private Boolean gatilhogradeSubstituicao;
    @Column(name="VERIFICA_FREQUENCIA")
    @Type(type="BooleanTypeSip")
    private Boolean verificaFrequencia;
    @Size(max=2)
    @Column(name="TIPO_TCEMG")
    private String tipoAfastamentoTceMg;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="afastamento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<FaixaPagamentoBeneficio> faixaPagamentoBeneficioList;

    public CodigoAfastamento() {
        this.sefipReduzidoPK = new SefipReduzidoPK();
    }

    public CodigoAfastamento(SefipReduzidoPK sefipReduzidoPK) {
        this.sefipReduzidoPK = sefipReduzidoPK;
    }

    public CodigoAfastamento(String entidade, int codigo) {
        this.sefipReduzidoPK = new SefipReduzidoPK(entidade, codigo);
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getSefipSaida() {
        return this.sefipSaida;
    }

    public void setSefipSaida(String sefipsai) {
        this.sefipSaida = sefipsai;
    }

    public String getSefipEntrada() {
        return this.sefipEntrada;
    }

    public void setSefipEntrada(String sefipent) {
        this.sefipEntrada = sefipent;
    }

    public Short getDias() {
        return this.dias;
    }

    public void setDias(Short dias) {
        this.dias = dias;
    }

    public SefipReduzidoPK getSefipReduzidoPK() {
        return this.sefipReduzidoPK;
    }

    public void setSefipReduzidoPK(SefipReduzidoPK sefipReduzidoPK) {
        this.sefipReduzidoPK = sefipReduzidoPK;
    }

    public Short getDiasLimite() {
        return this.diasLimite;
    }

    public void setDiasLimite(Short diasLimite) {
        this.diasLimite = diasLimite;
    }

    public SefipReduzidoTipoLimite getTipoLimite() {
        return this.tipoLimite;
    }

    public void setTipoLimite(SefipReduzidoTipoLimite tipoLimite) {
        this.tipoLimite = tipoLimite;
    }

    public Boolean getAbateTempoServico() {
        return this.abateTempoServico;
    }

    public void setAbateTempoServico(Boolean abateTempoServico) {
        this.abateTempoServico = abateTempoServico;
    }

    public Boolean getAbateLicencaPremio() {
        return this.abateLicencaPremio;
    }

    public void setAbateLicencaPremio(Boolean abateLicencaPremio) {
        this.abateLicencaPremio = abateLicencaPremio;
    }

    public Boolean getAbateFerias() {
        return this.abateFerias;
    }

    public void setAbateFerias(Boolean abateFerias) {
        this.abateFerias = abateFerias;
    }

    public List<FaixaPagamentoBeneficio> getFaixaPagamentoBeneficioList() {
        return this.faixaPagamentoBeneficioList;
    }

    public void setFaixaPagamentoBeneficioList(List<FaixaPagamentoBeneficio> faixaPagamentoBeneficioList) {
        this.faixaPagamentoBeneficioList = faixaPagamentoBeneficioList;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.sefipReduzidoPK != null ? this.sefipReduzidoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CodigoAfastamento)) {
            return false;
        }
        CodigoAfastamento other = (CodigoAfastamento)object;
        return (this.sefipReduzidoPK != null || other.sefipReduzidoPK == null) && (this.sefipReduzidoPK == null || this.sefipReduzidoPK.equals(other.sefipReduzidoPK));
    }

    public String toString() {
        return "entity.Sefipreduzido[ sefipreduzidoPK=" + this.sefipReduzidoPK + " ]";
    }

    public String getCausaCodigo() {
        return this.causaCodigo;
    }

    public void setCausaCodigo(String causaCodigo) {
        this.causaCodigo = causaCodigo;
    }

    public Causa getCausa() {
        return this.causa;
    }

    public void setCausa(Causa causa) {
        this.causaCodigo = causa != null ? causa.getCodigo() : null;
        this.causa = causa;
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.hashCode());
    }

    public SituacaoLotacaoAudesp getCodigoAudesp() {
        return this.codigoAudesp;
    }

    public void setCodigoAudesp(SituacaoLotacaoAudesp codigoAudesp) {
        this.codigoAudesp = codigoAudesp;
    }

    public Integer getTipoMovimentoESocialId() {
        return this.tipoMovimentoESocialId;
    }

    public void setTipoMovimentoESocialId(Integer tipoMovimentoESocialId) {
        this.tipoMovimentoESocialId = tipoMovimentoESocialId;
    }

    public TipoMovimentoESocial getTipoMovimentoESocial() {
        return this.tipoMovimentoESocial;
    }

    public void setTipoMovimentoESocial(TipoMovimentoESocial tipoMovimentoESocial) {
        this.tipoMovimentoESocial = tipoMovimentoESocial;
    }

    public Integer getTipoOnusCessao() {
        return this.tipoOnusCessao;
    }

    public void setTipoOnusCessao(Integer tipoOnusCessao) {
        this.tipoOnusCessao = tipoOnusCessao;
    }

    public Boolean getFaixasPagamentoBeneficio() {
        return this.faixasPagamentoBeneficio;
    }

    public void setFaixasPagamentoBeneficio(Boolean faixasPagamentoBeneficio) {
        this.faixasPagamentoBeneficio = faixasPagamentoBeneficio;
    }

    public Boolean getGatilhogradeSubstituicao() {
        return this.gatilhogradeSubstituicao;
    }

    public void setGatilhogradeSubstituicao(Boolean gatilhogradeSubstituicao) {
        this.gatilhogradeSubstituicao = gatilhogradeSubstituicao;
    }

    public Boolean getVerificaFrequencia() {
        return this.verificaFrequencia;
    }

    public void setVerificaFrequencia(Boolean verificaFrequencia) {
        this.verificaFrequencia = verificaFrequencia;
    }

    public TipoAfastamentoTceMg getTipoAfastamentoTceMgBy(Integer ano) {
        return TipoAfastamentoTceMg.of(this.tipoAfastamentoTceMg, ano);
    }

    public void setTipoAfastamentoTceMg(TipoAfastamentoTceMg tipoAfastamentoTceMg) {
        this.tipoAfastamentoTceMg = tipoAfastamentoTceMg == null ? null : tipoAfastamentoTceMg.getCodigo();
    }

    public static class CodigoAfastamentoSql {
        public static final String DOES_EXIST_BY_PK = " SELECT COUNT(c.sefipReduzidoPK.entidade)  FROM CodigoAfastamento c  WHERE c.sefipReduzidoPK = :pk ";
    }
}

