/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.api.SearchCodigo;
import br.com.fiorilli.sip.persistence.api.SearchNome;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@FilterConfigType(rootQueryType=Cnae.class)
@Entity
@Table(name="GR_CNAE")
@Audited
public class Cnae
implements Serializable,
GenericEntity,
Filterable {
    private static final long serialVersionUID = 1L;
    @SearchCodigo
    @FilterConfig(label="C\u00f3digo", order=1)
    @Id
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=7)
    @Column(name="COCNAE")
    private String codigo;
    @SearchNome
    @FilterConfig(label="Nome", order=2, condition=FilterCondition.COMECE)
    @Size(max=200)
    @Column(name="NOCNAE")
    private String nome;
    @FilterConfig(label="Grau de Risco", order=3)
    @Column(name="GRAU_RISCO")
    private Double grauRisco;

    public Cnae() {
        this.grauRisco = 0.0;
    }

    public Cnae(String codigo) {
        this.codigo = codigo;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Double getGrauRisco() {
        return this.grauRisco;
    }

    public void setGrauRisco(Double grauRisco) {
        this.grauRisco = grauRisco;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Cnae)) {
            return false;
        }
        Cnae other = (Cnae)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "Cnae [codigo=" + this.codigo + ", nome=" + this.nome + ", grauRisco=" + this.grauRisco + "]";
    }

    @Override
    public String getHashId() {
        return this.codigo;
    }

    public String getItemId() {
        return this.codigo;
    }

    public String getItemLabel() {
        return this.nome;
    }
}

