/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Mes;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="CESTABASICA")
@Audited
public class CestaBasica
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_CESTABASICA";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Basic(optional=false)
    @NotNull
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATAENTREGA")
    private Date dataentrega;
    @Basic(optional=false)
    @Column(name="OBS")
    private String obs;
    @Basic(optional=false)
    @NotNull
    @Column(name="ANO")
    private String anoCodigo;
    @Basic(optional=false)
    @NotNull
    @Column(name="MES")
    private String mesCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="ANO", referencedColumnName="ANO", insertable=false, updatable=false), @JoinColumn(name="MES", referencedColumnName="MES", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Mes mes;
    @Basic(optional=false)
    @NotNull
    @Column(name="empresa")
    private String entidadeCodigo;
    @Basic(optional=false)
    @NotNull
    @Column(name="registro")
    private String registro;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;

    public CestaBasica() {
    }

    public CestaBasica(Integer codigo) {
        this.codigo = codigo;
    }

    public CestaBasica(Integer codigo, Date dataentrega, String obs) {
        this.codigo = codigo;
        this.dataentrega = dataentrega;
        this.obs = obs;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public Date getDataentrega() {
        return this.dataentrega;
    }

    public void setDataentrega(Date dataentrega) {
        this.dataentrega = dataentrega;
    }

    public String getObs() {
        return this.obs;
    }

    public void setObs(String obs) {
        this.obs = obs;
    }

    public Trabalhador getTrabalhador() {
        if (this.trabalhador == null) {
            this.trabalhador = new Trabalhador();
        }
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codigo == null ? 0 : this.codigo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CestaBasica)) {
            return false;
        }
        CestaBasica other = (CestaBasica)obj;
        return !(this.codigo == null ? other.codigo != null : !this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "CestaBasica [codigo=" + this.codigo + "]";
    }

    public String getAnoCodigo() {
        return this.anoCodigo;
    }

    public void setAnoCodigo(String ano) {
        this.anoCodigo = ano;
    }

    public String getMesCodigo() {
        return this.mesCodigo;
    }

    public void setMesCodigo(String mes) {
        this.mesCodigo = mes;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public Mes getMes() {
        return this.mes;
    }

    public void setMes(Mes mes) {
        if (mes == null) {
            this.anoCodigo = null;
            this.mesCodigo = null;
        } else {
            this.anoCodigo = mes.getMesPK().getAno();
            this.mesCodigo = mes.getMesPK().getMes();
        }
        this.mes = mes;
    }
}

