/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.CausaSituacao;
import br.com.fiorilli.sip.persistence.entity.CodigoSaque;
import br.com.fiorilli.sip.persistence.entity.MotivoAposentadoria;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="CAUSAS")
@Audited
public class Causa
implements Serializable,
GenericEntity {
    private static final long serialVersionUID = 1L;
    public static final String FIND_FOR_FILTER = "SELECT c FROM Causa c WHERE c.nome LIKE '%'||:param||'%'";
    @FilterConfig(label="C\u00f3digo")
    @Id
    @Column(unique=true, nullable=false, length=2)
    private String codigo;
    @FilterConfig(label="Nome", condition=FilterCondition.COMECE)
    @Column(length=201)
    private String nome;
    @FilterConfig(label="C\u00f3digo Saque")
    @Column(name="CODSAQUE", length=2)
    private String codigoSaque;
    @ManyToOne
    @JoinColumn(name="CODSAQUE", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private CodigoSaque saque;
    @OneToMany(mappedBy="causa", fetch=FetchType.LAZY)
    private List<CausaSituacao> causaSituacaoList;
    @OneToMany(mappedBy="causa", fetch=FetchType.LAZY)
    private List<MotivoAposentadoria> motivoAposentadoriaList;

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getCodigoSaque() {
        return this.codigoSaque;
    }

    public void setCodigoSaque(String codsaque) {
        this.codigoSaque = codsaque;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public List<CausaSituacao> getCausaSituacaoList() {
        return this.causaSituacaoList;
    }

    public void setCausaSituacaoList(List<CausaSituacao> causaSituacaoList) {
        this.causaSituacaoList = causaSituacaoList;
    }

    public List<MotivoAposentadoria> getMotivoAposentadoriaList() {
        return this.motivoAposentadoriaList;
    }

    public void setMotivoAposentadoriaList(List<MotivoAposentadoria> motivoAposentadoriaList) {
        this.motivoAposentadoriaList = motivoAposentadoriaList;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codigo == null ? 0 : this.codigo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Causa other = (Causa)obj;
        return !(this.codigo == null ? other.codigo != null : !this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "Causa [codigo=" + this.codigo + ", nome=" + this.nome + ", codsaque=" + this.codigoSaque + "]";
    }

    public CodigoSaque getSaque() {
        return this.saque;
    }

    public void setSaque(CodigoSaque saque) {
        this.codigoSaque = saque != null ? saque.getCodigo() : null;
        this.saque = saque;
    }

    @Override
    public String getHashId() {
        return this.codigo;
    }

    public static class CausaSql {
        public static final String DOES_EXIST_BY_CODIGO = " SELECT COUNT(c.codigo)  FROM Causa c  WHERE c.codigo = :codigo ";
    }
}

