/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.commons.util.SIPNumberUtil;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@FilterConfigType(rootQueryType=CategoriaSefip.class)
@Entity
@Table(name="CATSEFIP")
@Audited
public class CategoriaSefip
implements Serializable,
GenericEntity,
Filterable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_FOR_FILTER = "SELECT c FROM CategoriaSefip c WHERE UPPER(c.nome) LIKE UPPER('%'||:param||'%') ORDER BY c.nome";
    public static final String AGENTE_POLITICO = "19";
    @FilterConfig(label="C\u00f3digo", order=1)
    @Id
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=2)
    @Column(name="CODIGO")
    private String codigo;
    @FilterConfig(label="Nome", order=2)
    @Size(max=230)
    @Column(name="NOME")
    private String nome;
    @Column(name="AUTONOMO_TAXA_CONTRIBUINTE")
    private BigDecimal autonomoTaxaContribuinte;
    @Column(name="AUTONOMO_TETO_CONTRIBUINTE")
    private BigDecimal autonomoTetoContribuinte;
    @Column(name="AUTONOMO_TAXA_EMPRESA")
    private BigDecimal autonomoTaxaEntidade;
    @Column(name="AUTONOMO_TETO_EMPRESA")
    private BigDecimal autonomoTetoEntidade;
    @Type(type="BooleanTypeSip")
    @Column(name="SALARIO13")
    private Boolean salario13;
    @Column(name="AUTONOMO_OUTRA_ENTID_EMPRESA")
    private BigDecimal autonomoOutraEntidade;

    public CategoriaSefip() {
    }

    public CategoriaSefip(String codigo) {
        this.codigo = codigo;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public BigDecimal getAutonomoTaxaContribuinte() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.autonomoTaxaContribuinte);
    }

    public void setAutonomoTaxaContribuinte(BigDecimal autonomoTaxaContribuinte) {
        this.autonomoTaxaContribuinte = autonomoTaxaContribuinte;
    }

    public BigDecimal getAutonomoTetoContribuinte() {
        return this.autonomoTetoContribuinte;
    }

    public void setAutonomoTetoContribuinte(BigDecimal autonomoTetoContribuinte) {
        this.autonomoTetoContribuinte = autonomoTetoContribuinte;
    }

    public BigDecimal getAutonomoTaxaEntidade() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.autonomoTaxaEntidade);
    }

    public void setAutonomoTaxaEntidade(BigDecimal autonomoTaxaEntidade) {
        this.autonomoTaxaEntidade = autonomoTaxaEntidade;
    }

    public BigDecimal getAutonomoTetoEntidade() {
        return this.autonomoTetoEntidade;
    }

    public void setAutonomoTetoEntidade(BigDecimal autonomoTetoEntidade) {
        this.autonomoTetoEntidade = autonomoTetoEntidade;
    }

    public Boolean getSalario13() {
        return this.salario13;
    }

    public void setSalario13(Boolean salario13) {
        this.salario13 = salario13;
    }

    public BigDecimal getAutonomoOutraEntidade() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.autonomoOutraEntidade);
    }

    public void setAutonomoOutraEntidade(BigDecimal autonomoOutraEntidade) {
        this.autonomoOutraEntidade = autonomoOutraEntidade;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CategoriaSefip)) {
            return false;
        }
        CategoriaSefip other = (CategoriaSefip)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public boolean isTransportador() {
        return this.nome.toLowerCase().contains("transp");
    }

    public String toString() {
        return "CategoriaSefip [codigo=" + this.codigo + "]";
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.hashCode());
    }

    public String getItemId() {
        return this.codigo;
    }

    public String getItemLabel() {
        return this.nome;
    }
}

