/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.CategoriaFuncionalPK;
import br.com.fiorilli.sip.persistence.entity.EventosCategoriafuncional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@FilterConfigType(rootQueryType=CategoriaFuncional.class)
@Entity
@Table(name="CATFUNCIONAL")
@Audited
public class CategoriaFuncional
implements Serializable,
Filterable {
    private static final long serialVersionUID = 1L;
    public static final String GET_NEXT_ITEM = "SELECT coalesce(max(c.categoriaFuncionalPK.codigo), 0) + 1 FROM CategoriaFuncional c where c.categoriaFuncionalPK.entidade = :entidadeCodigo";
    public static final String FIND_FOR_FILTER = "SELECT c FROM CategoriaFuncional c where UPPER(c.nome) LIKE UPPER('%'||:param||'%') AND c.categoriaFuncionalPK.entidade = :entidadeCodigo ORDER BY c.nome";
    public static final String GET_FETCHED_BY_ID = "SELECT c FROM CategoriaFuncional c WHERE c.categoriaFuncionalPK = :categoriaFuncionalPK";
    @EmbeddedId
    protected CategoriaFuncionalPK categoriaFuncionalPK;
    @FilterConfig(label="Nome", condition=FilterCondition.COMECE)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Type(type="BooleanTypeSip")
    @Column(name="FALTA_ABONADA")
    private Boolean faltaAbonada;
    @Column(name="QTDEANO_ABONADA")
    private Short qtdeAnoAbonada;
    @Column(name="QTDEMES_ABONADA")
    private Short qtdeMesAbonada;
    @Type(type="BooleanTypeSip")
    @Column(name="ADD_GOZO_FERIAS")
    private boolean gozoferias;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="categoriaFuncional", fetch=FetchType.LAZY, orphanRemoval=true)
    private List<EventosCategoriafuncional> eventos;

    public CategoriaFuncional() {
        this.eventos = new ArrayList<EventosCategoriafuncional>();
    }

    public CategoriaFuncional(CategoriaFuncionalPK categoriaFuncionalPK) {
        this.categoriaFuncionalPK = categoriaFuncionalPK;
    }

    public CategoriaFuncional(String entidade, Integer codigo) {
        this.categoriaFuncionalPK = new CategoriaFuncionalPK(entidade, codigo);
    }

    public CategoriaFuncionalPK getCategoriaFuncionalPK() {
        if (this.categoriaFuncionalPK == null) {
            this.categoriaFuncionalPK = new CategoriaFuncionalPK();
        }
        return this.categoriaFuncionalPK;
    }

    public void setCategoriaFuncionalPK(CategoriaFuncionalPK categoriaFuncionalPK) {
        this.categoriaFuncionalPK = categoriaFuncionalPK;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Boolean getFaltaAbonada() {
        return this.faltaAbonada;
    }

    public void setFaltaAbonada(Boolean faltaAbonada) {
        this.faltaAbonada = faltaAbonada;
    }

    public Short getQtdeAnoAbonada() {
        return this.qtdeAnoAbonada;
    }

    public void setQtdeAnoAbonada(Short qtdeanoAbonada) {
        this.qtdeAnoAbonada = qtdeanoAbonada;
    }

    public Short getQtdeMesAbonada() {
        return this.qtdeMesAbonada;
    }

    public void setQtdeMesAbonada(Short qtdemesAbonada) {
        this.qtdeMesAbonada = qtdemesAbonada;
    }

    public boolean isGozoferias() {
        return this.gozoferias;
    }

    public void setGozoferias(boolean gozoferias) {
        this.gozoferias = gozoferias;
    }

    public List<EventosCategoriafuncional> getEventos() {
        this.eventos.size();
        return this.eventos;
    }

    public void setEventos(List<EventosCategoriafuncional> eventos) {
        this.eventos = eventos;
    }

    public EventosCategoriafuncional addEvento(EventosCategoriafuncional eventosCategoriafuncional) {
        this.eventos.add(eventosCategoriafuncional);
        if (this.getCategoriaFuncionalPK().getCodigo() != null) {
            eventosCategoriafuncional.setCategoriaFuncional(this);
        }
        return eventosCategoriafuncional;
    }

    public EventosCategoriafuncional removeEvento(EventosCategoriafuncional eventosCategoriafuncional) {
        this.eventos.remove(eventosCategoriafuncional);
        eventosCategoriafuncional.setCategoriaFuncional(null);
        return eventosCategoriafuncional;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.categoriaFuncionalPK != null ? this.categoriaFuncionalPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CategoriaFuncional)) {
            return false;
        }
        CategoriaFuncional other = (CategoriaFuncional)object;
        return (this.categoriaFuncionalPK != null || other.categoriaFuncionalPK == null) && (this.categoriaFuncionalPK == null || this.categoriaFuncionalPK.equals(other.categoriaFuncionalPK));
    }

    public String toString() {
        return "entity.CategoriaFuncional[ categoriaFuncionalPK=" + this.categoriaFuncionalPK + " ]";
    }

    public String getItemId() {
        return String.valueOf(this.categoriaFuncionalPK.getCodigo());
    }

    public String getItemLabel() {
        return this.nome;
    }
}

