/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.CatAreaAcidente;
import br.com.fiorilli.sip.persistence.entity.CatFiliacaoINSS;
import br.com.fiorilli.sip.persistence.entity.CatLocalAcidente;
import br.com.fiorilli.sip.persistence.entity.CatPK;
import br.com.fiorilli.sip.persistence.entity.CatTestemunha1Endereco;
import br.com.fiorilli.sip.persistence.entity.CatTestemunha2Endereco;
import br.com.fiorilli.sip.persistence.entity.CatTipo;
import br.com.fiorilli.sip.persistence.entity.Cid;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.Medico;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.UF;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CAT")
@Audited
public class Cat
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GET_NEXT_ITEM = "SELECT COALESCE(MAX(c.catPK.item), 0) + 1 FROM Cat c WHERE c.trabalhador.trabalhadorPK = :trabalhadorPK";
    public static final String GET_FETCHED = "SELECT c FROM Cat c LEFT JOIN FETCH c.medico LEFT JOIN FETCH c.cidMedico LEFT JOIN FETCH c.trabalhador WHERE c.catPK = :catPK";
    @EmbeddedId
    protected CatPK catPK;
    @FilterConfig(label="N\u00famero CAT", order=1)
    @Column(name="NUMCAT")
    private Integer numeroCat;
    @Column(name="DTREGIS")
    @Temporal(value=TemporalType.DATE)
    private Date dataRegistro;
    @Column(name="TIPOCAT")
    private String tipo;
    @Column(name="DTOBITO")
    @Temporal(value=TemporalType.DATE)
    private Date dataObito;
    @Column(name="FILIACAOPREVSOCIAL")
    private String filiacaoINSS;
    @Column(name="AREAACIDENTE")
    private String areaAcidente;
    @Column(name="DTACIDENTE")
    @Temporal(value=TemporalType.DATE)
    private Date dataAcidente;
    @Size(max=5)
    @Column(name="HRACIDENTE")
    private String horaAcidente;
    @Size(max=5)
    @Column(name="APOSQTHORAS")
    private String aposQuantidadeHoras;
    @Type(type="BooleanTypeSip")
    @Column(name="AFASTAMENTO")
    private Boolean afastamento;
    @Column(name="UDIATRAB")
    @Temporal(value=TemporalType.DATE)
    private Date ultimoDiaTrabalhador;
    @Column(name="ACLOCAL")
    private String acidenteLocal;
    @Size(max=18)
    @Column(name="ACCNPJ")
    private String acidenteCnpj;
    @Size(max=30)
    @Column(name="ACCIDADE")
    private String acidenteCidade;
    @Enumerated(value=EnumType.STRING)
    @Column(name="ACUF")
    private UF acidenteUF;
    @Size(max=60)
    @Column(name="ACESPECIFICA")
    private String acidenteEspecificacao;
    @Size(max=80)
    @Column(name="PARTECORPO")
    private String parteCorpo;
    @Size(max=80)
    @Column(name="AGENTECAUSADOR")
    private String agenteCausador;
    @Lob
    @Size(max=0x7FFFFFFF)
    @Column(name="ACDESCRICAO")
    private String acidenteDescricao;
    @Type(type="BooleanTypeSip")
    @Column(name="BO")
    private Boolean bo;
    @Type(type="BooleanTypeSip")
    @Column(name="MORTE")
    private Boolean morte;
    @Size(max=60)
    @Column(name="TES1NOME")
    private String testemunha1Nome;
    @Size(max=11)
    @Column(name="TES1TEL")
    private String testemunha1Telefone;
    @Embedded
    private CatTestemunha1Endereco enderecoTestemunha1;
    @Size(max=60)
    @Column(name="TES2NOME")
    private String testemunha2Nome;
    @Size(max=11)
    @Column(name="TES2TEL")
    private String testemunha2Telefone;
    @Embedded
    private CatTestemunha2Endereco enderecoTestemunha2;
    @Size(max=30)
    @Column(name="UNIDADEMEDICA")
    private String unidadeMedica;
    @Column(name="ATESDATA")
    @Temporal(value=TemporalType.DATE)
    private Date dataAtestado;
    @Size(max=5)
    @Column(name="ATESHORA")
    private String horaAtestado;
    @Type(type="BooleanTypeSip")
    @Column(name="INTERNOU")
    private Boolean internou;
    @Column(name="DURACAOTRATA")
    private Short duracaoTratamento;
    @Type(type="BooleanTypeSip")
    @Column(name="DEVEAFASTAR")
    private Boolean deveraAfastar;
    @Lob
    @Size(max=0x7FFFFFFF)
    @Column(name="DESCRICAOLESAO")
    private String descricaoLesao;
    @Lob
    @Size(max=0x7FFFFFFF)
    @Column(name="DIAGNOSTICO")
    private String diagnostico;
    @Lob
    @Size(max=0x7FFFFFFF)
    @Column(name="OBS")
    private String obs;
    @Column(name="TIPOACIDENTE")
    private String tipoAcidente;
    @JoinColumn(name="MEDICO", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Medico medico;
    @FilterConfig(label="Trabalhador", inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @JoinColumn(name="CIDMEDICO", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Cid cidMedico;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Entidade entidade;

    public Cat() {
    }

    public Cat(CatPK catPK) {
        this.catPK = catPK;
    }

    public Cat(String entidade, String registro, short item) {
        this.catPK = new CatPK(entidade, registro, item);
    }

    public CatPK getCatPK() {
        return this.catPK;
    }

    public void setCatPK(CatPK catPK) {
        this.catPK = catPK;
    }

    public Integer getNumeroCat() {
        return this.numeroCat;
    }

    public void setNumeroCat(Integer numcat) {
        this.numeroCat = numcat;
    }

    public Date getDataRegistro() {
        return this.dataRegistro;
    }

    public void setDataRegistro(Date dtregis) {
        this.dataRegistro = dtregis;
    }

    public CatTipo getTipo() {
        return CatTipo.get(this.tipo);
    }

    public void setTipo(CatTipo tipo) {
        this.tipo = tipo.getCodigo();
    }

    public Date getDataObito() {
        return this.dataObito;
    }

    public void setDataObito(Date dtobito) {
        this.dataObito = dtobito;
    }

    public CatFiliacaoINSS getFiliacaoINSS() {
        return CatFiliacaoINSS.get(this.filiacaoINSS);
    }

    public void setFiliacaoINSS(CatFiliacaoINSS filiacaoINSS) {
        this.filiacaoINSS = filiacaoINSS.getCodigo();
    }

    public CatAreaAcidente getAreaAcidente() {
        return CatAreaAcidente.get(this.areaAcidente);
    }

    public void setAreaAcidente(CatAreaAcidente areaAcidente) {
        this.areaAcidente = areaAcidente.getCodigo();
    }

    public Date getDataAcidente() {
        return this.dataAcidente;
    }

    public void setDataAcidente(Date dtacidente) {
        this.dataAcidente = dtacidente;
    }

    public String getHoraAcidente() {
        return this.horaAcidente;
    }

    public void setHoraAcidente(String hracidente) {
        this.horaAcidente = hracidente;
    }

    public String getAposQuantidadeHoras() {
        return this.aposQuantidadeHoras;
    }

    public void setAposQuantidadeHoras(String aposqthoras) {
        this.aposQuantidadeHoras = aposqthoras;
    }

    public Date getUltimoDiaTrabalhador() {
        return this.ultimoDiaTrabalhador;
    }

    public void setUltimoDiaTrabalhador(Date udiatrab) {
        this.ultimoDiaTrabalhador = udiatrab;
    }

    public CatLocalAcidente getAcidenteLocal() {
        return CatLocalAcidente.values()[Integer.parseInt(this.acidenteLocal)];
    }

    public void setAcidenteLocal(CatLocalAcidente acidenteLocal) {
        this.acidenteLocal = String.valueOf(acidenteLocal.ordinal());
    }

    public String getAcidenteCnpj() {
        return this.acidenteCnpj;
    }

    public void setAcidenteCnpj(String accnpj) {
        this.acidenteCnpj = accnpj;
    }

    public String getAcidenteCidade() {
        return this.acidenteCidade;
    }

    public void setAcidenteCidade(String accidade) {
        this.acidenteCidade = accidade;
    }

    public UF getAcidenteUF() {
        return this.acidenteUF;
    }

    public void setAcidenteUF(UF acuf) {
        this.acidenteUF = acuf;
    }

    public String getAcidenteEspecificacao() {
        return this.acidenteEspecificacao;
    }

    public void setAcidenteEspecificacao(String acespecifica) {
        this.acidenteEspecificacao = acespecifica;
    }

    public String getParteCorpo() {
        return this.parteCorpo;
    }

    public void setParteCorpo(String partecorpo) {
        this.parteCorpo = partecorpo;
    }

    public String getAgenteCausador() {
        return this.agenteCausador;
    }

    public void setAgenteCausador(String agentecausador) {
        this.agenteCausador = agentecausador;
    }

    public String getAcidenteDescricao() {
        return this.acidenteDescricao;
    }

    public void setAcidenteDescricao(String acdescricao) {
        this.acidenteDescricao = acdescricao;
    }

    public String getTestemunha1Nome() {
        return this.testemunha1Nome;
    }

    public void setTestemunha1Nome(String tes1nome) {
        this.testemunha1Nome = tes1nome;
    }

    public CatTestemunha1Endereco getEnderecoTestemunha1() {
        return this.enderecoTestemunha1;
    }

    public void setEnderecoTestemunha1(CatTestemunha1Endereco enderecoTestemunha1) {
        this.enderecoTestemunha1 = enderecoTestemunha1;
    }

    public String getTestemunha1Telefone() {
        return this.testemunha1Telefone;
    }

    public void setTestemunha1Telefone(String tes1tel) {
        this.testemunha1Telefone = tes1tel;
    }

    public String getTestemunha2Nome() {
        return this.testemunha2Nome;
    }

    public void setTestemunha2Nome(String tes2nome) {
        this.testemunha2Nome = tes2nome;
    }

    public CatTestemunha2Endereco getEnderecoTestemunha2() {
        return this.enderecoTestemunha2;
    }

    public void setEnderecoTestemunha2(CatTestemunha2Endereco enderecoTestemunha2) {
        this.enderecoTestemunha2 = enderecoTestemunha2;
    }

    public String getTestemunha2Telefone() {
        return this.testemunha2Telefone;
    }

    public void setTestemunha2Telefone(String tes2tel) {
        this.testemunha2Telefone = tes2tel;
    }

    public String getUnidadeMedica() {
        return this.unidadeMedica;
    }

    public void setUnidadeMedica(String unidademedica) {
        this.unidadeMedica = unidademedica;
    }

    public Date getDataAtestado() {
        return this.dataAtestado;
    }

    public void setDataAtestado(Date atesdata) {
        this.dataAtestado = atesdata;
    }

    public String getHoraAtestado() {
        return this.horaAtestado;
    }

    public void setHoraAtestado(String ateshora) {
        this.horaAtestado = ateshora;
    }

    public Short getDuracaoTratamento() {
        return this.duracaoTratamento;
    }

    public void setDuracaoTratamento(Short duracaotrata) {
        this.duracaoTratamento = duracaotrata;
    }

    public String getDescricaoLesao() {
        return this.descricaoLesao;
    }

    public void setDescricaoLesao(String descricaolesao) {
        this.descricaoLesao = descricaolesao;
    }

    public String getDiagnostico() {
        return this.diagnostico;
    }

    public void setDiagnostico(String diagnostico) {
        this.diagnostico = diagnostico;
    }

    public String getObs() {
        return this.obs;
    }

    public void setObs(String obs) {
        this.obs = obs;
    }

    public CatAreaAcidente getTipoAcidente() {
        return CatAreaAcidente.get(this.tipoAcidente);
    }

    public void setTipoAcidente(CatAreaAcidente tipoAcidente) {
        this.tipoAcidente = tipoAcidente.getCodigo();
    }

    public Medico getMedico() {
        return this.medico;
    }

    public void setMedico(Medico medico) {
        this.medico = medico;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public Cid getCidMedico() {
        return this.cidMedico;
    }

    public void setCidMedico(Cid cidmedico) {
        this.cidMedico = cidmedico;
    }

    public Boolean getAfastamento() {
        return this.afastamento;
    }

    public void setAfastamento(Boolean afastamento) {
        this.afastamento = afastamento;
    }

    public Boolean getBo() {
        return this.bo;
    }

    public void setBo(Boolean bo) {
        this.bo = bo;
    }

    public Boolean getMorte() {
        return this.morte;
    }

    public void setMorte(Boolean morte) {
        this.morte = morte;
    }

    public Boolean getInternou() {
        return this.internou;
    }

    public void setInternou(Boolean internou) {
        this.internou = internou;
    }

    public Boolean getDeveraAfastar() {
        return this.deveraAfastar;
    }

    public void setDeveraAfastar(Boolean deveafastar) {
        this.deveraAfastar = deveafastar;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.catPK != null ? this.catPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Cat)) {
            return false;
        }
        Cat other = (Cat)object;
        return (this.catPK != null || other.catPK == null) && (this.catPK == null || this.catPK.equals(other.catPK));
    }

    public String toString() {
        return "entity.Cat[ catPK=" + this.catPK + " ]";
    }
}

