/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.PlanoCargosCargo;
import br.com.fiorilli.sip.persistence.entity.Salario;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="CARGOSAL")
@Audited
public class CargoSalario
implements Serializable,
GenericEntity {
    private static final long serialVersionUID = 1L;
    public static final String FIND_REFERENCIA_SALARIAL_BY_CARGO = "SELECT NEW br.com.fiorilli.sipweb.vo.CargoReferenciaSalarialVo(sa.salarioPK.codigo, sa.nome, sa.valor, cs.nivel) FROM CargoSalario cs JOIN cs.planoCargosCargo pcc JOIN cs.salario sa WHERE pcc.cargo.cargoPK = :cargoPK AND pcc.planoCargo.id = :planoCargoId ORDER BY cs.ordem";
    public static final String FIND_BY_PLANO_CARGOS_CARGO = "SELECT cs FROM CargoSalario cs LEFT JOIN FETCH cs.salario WHERE cs.planoCargosCargo in (:planoCargosCargoList) ORDER BY cs.ordem";
    public static final String FIND_BY_PLANO_CARGOS_CARGO_ID = "SELECT cs FROM CargoSalario cs LEFT JOIN FETCH cs.salario WHERE cs.planoCargosCargoId = :planoCargosCargoID ORDER BY cs.ordem";
    public static final String GENERATOR = "GEN_CARGOSAL";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="IDCARGOSAL")
    private Integer cargoSalarioId;
    @Column(name="ORDEM")
    private Short ordem;
    @Size(max=3)
    @Column(name="NIVEL")
    private String nivel;
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @Size(min=1, max=10)
    @Column(name="REFSAL")
    private String salarioCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REFSAL", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Salario salario;
    @Column(name="IDPLANOCARGOSCARGO")
    private Integer planoCargosCargoId;
    @JoinColumn(name="IDPLANOCARGOSCARGO", referencedColumnName="IDPLANOCARGOSCARGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private PlanoCargosCargo planoCargosCargo;

    public CargoSalario() {
    }

    public CargoSalario(Integer idcargosal) {
        this.cargoSalarioId = idcargosal;
    }

    public Short getOrdem() {
        return this.ordem;
    }

    public void setOrdem(Short ordem) {
        this.ordem = ordem;
    }

    public String getNivel() {
        return this.nivel;
    }

    public void setNivel(String nivel) {
        this.nivel = nivel;
    }

    public Integer getCargoSalarioId() {
        return this.cargoSalarioId;
    }

    public void setCargoSalarioId(Integer idcargosal) {
        this.cargoSalarioId = idcargosal;
    }

    public Salario getSalario() {
        return this.salario;
    }

    public void setSalario(Salario salarios) {
        if (salarios != null) {
            this.salarioCodigo = salarios.getSalarioPK().getCodigo();
            this.entidadeCodigo = salarios.getSalarioPK().getEntidade();
        } else {
            this.salarioCodigo = null;
            this.entidadeCodigo = null;
        }
        this.salario = salarios;
    }

    public PlanoCargosCargo getPlanoCargosCargo() {
        return this.planoCargosCargo;
    }

    public void setPlanoCargosCargo(PlanoCargosCargo idplanocargoscargo) {
        this.planoCargosCargoId = idplanocargoscargo != null ? idplanocargoscargo.getId() : null;
        this.planoCargosCargo = idplanocargoscargo;
    }

    public Integer getPlanoCargosCargoId() {
        return this.planoCargosCargoId;
    }

    public void setPlanoCargosCargoId(Integer planoCargosCargoCodigo) {
        this.planoCargosCargoId = planoCargosCargoCodigo;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidade) {
        this.entidadeCodigo = entidade;
    }

    public String getSalarioCodigo() {
        return this.salarioCodigo;
    }

    public void setSalarioCodigo(String salarioCodigo) {
        this.salarioCodigo = salarioCodigo;
    }

    @Override
    public String getHashId() {
        if (this.getCargoSalarioId() == null) {
            if (this.salario != null) {
                return Integer.toString(this.salario.hashCode());
            }
            return null;
        }
        return this.getCargoSalarioId().toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cargoSalarioId == null ? 0 : this.cargoSalarioId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CargoSalario other = (CargoSalario)obj;
        return !(this.cargoSalarioId == null ? other.cargoSalarioId != null : !this.cargoSalarioId.equals(other.cargoSalarioId));
    }

    public String toString() {
        return "CargoSalario [cargoSalarioId=" + this.cargoSalarioId + "]";
    }
}

