/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import java.util.Arrays;
import java.util.List;

public enum CargoNatureza {
    EFETIVO("1", "Efetivo"),
    COMISSAO("2", "Comiss\u00e3o"),
    TEMPORARIO("3", "Tempor\u00e1rio"),
    EMPREGO_PUBLICO("4", "Emprego P\u00fablico"),
    FUNCAO_DE_CONFIANCA("5", "Fun\u00e7\u00e3o de Confian\u00e7a"),
    ESTAGIARIO("6", "Est\u00e1gio"),
    CONSELHEIRO("7", "Conselheiro"),
    FUNCAO_GRATIFICADA("8", "Fun\u00e7\u00e3o Gratificada"),
    OUTROS("9", "Outros"),
    EMPREGO_QUADRO_SUPLEMENTAR("10", "Emprego Quadro Suplementar"),
    CARGO_QUADRO_SUPLEMENTAR("11", "Cargo Quadro Suplementar"),
    ESTAVEL("12", "Est\u00e1vel");

    private final String codigo;
    private final String descricao;

    private CargoNatureza(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static final CargoNatureza get(String value) {
        for (CargoNatureza cn : CargoNatureza.values()) {
            if (!cn.getCodigo().equals(value)) continue;
            return cn;
        }
        return OUTROS;
    }

    public static List<CargoNatureza> getListToOutraOcupacao() {
        return Arrays.asList(ESTAGIARIO, CONSELHEIRO, OUTROS);
    }

    public boolean isEstagio() {
        return this == ESTAGIARIO;
    }

    public boolean isEfetivo() {
        return this == EFETIVO;
    }

    public boolean isComissao() {
        return this == COMISSAO;
    }

    public boolean isTemporario() {
        return this == TEMPORARIO;
    }

    public boolean isEmpregoPublico() {
        return this == EMPREGO_PUBLICO;
    }

    public boolean isFuncaoDeComfianca() {
        return this == FUNCAO_DE_CONFIANCA;
    }
}

