/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.VeiculoPublicacao;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;

@Embeddable
public class CargoExtincao
implements Serializable,
Documento {
    private static final long serialVersionUID = 1L;
    @Column(name="DTEXTINCAO")
    @Temporal(value=TemporalType.DATE)
    private Date data;
    @Size(max=16)
    @Column(name="NUMDOC_EXTINCAO")
    private String numeroDocumento;
    @Size(max=512)
    @Column(name="OBS_EXTINCAO")
    private String observacao;
    @Column(name="VEICULO_PUBLICACAO_EXTINCAO")
    private Integer veiculoPublicacaoCodigo;
    @JoinColumn(name="VEICULO_PUBLICACAO_EXTINCAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private VeiculoPublicacao veiculoPublicacao;
    @Column(name="TIPOLEGAL_EXTINCAO")
    private Integer tipoLegalCodigo;
    @JoinColumn(name="TIPOLEGAL_EXTINCAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;

    @Override
    public Date getData() {
        return this.data;
    }

    @Override
    public void setData(Date dtextincao) {
        this.data = dtextincao;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public void setNumeroDocumento(String numdocExtincao) {
        this.numeroDocumento = numdocExtincao;
    }

    public VeiculoPublicacao getVeiculoPublicacao() {
        return this.veiculoPublicacao;
    }

    public void setVeiculoPublicacao(VeiculoPublicacao veiculoPublicacaoExtincao) {
        this.veiculoPublicacao = veiculoPublicacaoExtincao;
        this.veiculoPublicacaoCodigo = veiculoPublicacaoExtincao != null ? veiculoPublicacaoExtincao.getCodigo() : null;
    }

    public final String getObservacao() {
        return this.observacao;
    }

    public final void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal tipoLegalExtincao) {
        this.tipoLegal = tipoLegalExtincao;
        this.tipoLegalCodigo = tipoLegalExtincao != null ? tipoLegalExtincao.getCodigo() : null;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    public void setTipoLegalCodigo(Integer tipoLegalExtincaoCodigo) {
        this.tipoLegalCodigo = tipoLegalExtincaoCodigo;
    }

    public Integer getVeiculoPublicacaoCodigo() {
        return this.veiculoPublicacaoCodigo;
    }

    public void setVeiculoPublicacaoCodigo(Integer veiculoPublicacaoExtincaoCodigo) {
        this.veiculoPublicacaoCodigo = veiculoPublicacaoExtincaoCodigo;
    }

    public boolean isEmpty() {
        return this.data == null && SIPUtil.isEmptyWithSpace((String)this.numeroDocumento) != false && SIPUtil.isEmptyWithSpace((String)this.observacao) != false && this.tipoLegalCodigo == null && this.veiculoPublicacaoCodigo == null;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    public String toString() {
        return "Tipo: " + this.tipoLegalCodigo + ", n\u00famero: " + this.numeroDocumento + ", data: " + this.data;
    }
}

