/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.CargoAlteracao;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.VeiculoPublicacao;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Parent;

@Embeddable
public class CargoCriacao
implements Serializable,
Documento {
    private static final long serialVersionUID = 1L;
    @Parent
    private Cargo cargo;
    @Column(name="DTCRIACAO")
    @Temporal(value=TemporalType.DATE)
    private Date data;
    @Size(max=16)
    @Column(name="NUMDOC_CRIACAO")
    private String numeroDocumento;
    @Size(max=512)
    @Column(name="OBS_CRIACAO")
    private String observacao;
    @Column(name="VEICULO_PUBLICACAO_CRIACAO")
    private Integer veiculoPublicacaoCodigo;
    @JoinColumn(name="VEICULO_PUBLICACAO_CRIACAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private VeiculoPublicacao veiculoPublicacao;
    @Column(name="TIPOLEGAL_CRIACAO")
    private Integer tipoLegalCodigo;
    @JoinColumn(name="TIPOLEGAL_CRIACAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;

    @Override
    public Date getData() {
        return this.data;
    }

    @Override
    public void setData(Date dtcriacao) {
        this.data = dtcriacao;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public void setNumeroDocumento(String numdocCriacao) {
        this.numeroDocumento = numdocCriacao;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String obsCriacao) {
        this.observacao = obsCriacao;
    }

    public VeiculoPublicacao getVeiculoPublicacao() {
        return this.veiculoPublicacao;
    }

    public void setVeiculoPublicacao(VeiculoPublicacao veiculoPublicacaoCriacao) {
        this.veiculoPublicacao = veiculoPublicacaoCriacao;
        this.veiculoPublicacaoCodigo = veiculoPublicacaoCriacao != null ? veiculoPublicacaoCriacao.getCodigo() : null;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal tipoLegalCriacao) {
        this.tipoLegal = tipoLegalCriacao;
        this.tipoLegalCodigo = tipoLegalCriacao != null ? tipoLegalCriacao.getCodigo() : null;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    public void setTipoLegalCodigo(Integer tipoLegalCriacaoCodigo) {
        this.tipoLegalCodigo = tipoLegalCriacaoCodigo;
    }

    public Integer getVeiculoPublicacaoCodigo() {
        return this.veiculoPublicacaoCodigo;
    }

    public void setVeiculoPublicacaoCodigo(Integer veiculoPublicacaoCriacaoCodigo) {
        this.veiculoPublicacaoCodigo = veiculoPublicacaoCriacaoCodigo;
    }

    public CargoCriacao() {
    }

    public CargoCriacao(Cargo cargo) {
        this.cargo = cargo;
    }

    public boolean isEmpty() {
        return this.data == null && SIPUtil.isEmptyWithSpace((String)this.numeroDocumento) != false && SIPUtil.isEmptyWithSpace((String)this.observacao) != false && this.tipoLegalCodigo == null && this.veiculoPublicacaoCodigo == null;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    public Integer getVagasTotalParaAudesp() {
        Integer saldo = this.cargo.getVagaTotalCargoAudesp();
        if (this.cargo.getAlteracoes() != null) {
            for (CargoAlteracao a : this.cargo.getAlteracoes()) {
                if (!a.getTipo().isVagaParaAudesp().booleanValue()) continue;
                Integer signum = a.getQuantidade().signum();
                if (signum == 1) {
                    signum = -1;
                }
                saldo = saldo + a.getQuantidade().intValue() * signum;
            }
        }
        return saldo;
    }

    public Cargo getCargo() {
        return this.cargo;
    }

    public void setCargo(Cargo cargo) {
        this.cargo = cargo;
    }

    public String toString() {
        return "Tipo: " + this.tipoLegalCodigo + ", n\u00famero: " + this.numeroDocumento + ", data: " + this.data;
    }
}

