/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.CargoAlteracaoTipo;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.VeiculoPublicacao;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="CARGOS_ALTERACAO")
@Audited
public class CargoAlteracao
implements Serializable,
Documento {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_CARGOALTERACAO";
    @Id
    private int id;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidade;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=4)
    @Column(name="CARGO")
    private String cargoCodigo;
    @Basic(optional=false)
    @NotNull
    @Column(name="DATA")
    @Temporal(value=TemporalType.DATE)
    private Date data;
    @Size(max=16)
    @Column(name="NUMDOC")
    private String numeroDocumento;
    @Size(max=512)
    @Column(name="OBS")
    private String obs;
    @Column(name="CODIGO_TCEPR")
    private Integer codigoTCEPR;
    @Enumerated
    @Column(name="TIPO")
    private CargoAlteracaoTipo tipo;
    @Column(name="VEICULO_PUBLICACAO")
    private Integer veiculoPublicacaoCodigo;
    @JoinColumn(name="VEICULO_PUBLICACAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private VeiculoPublicacao veiculoPublicacao;
    @Column(name="TIPOLEGAL")
    private Integer tipoLegalCodigo;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;
    @Column(name="QUANTIDADE")
    private Double quantidade;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CARGO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Cargo cargo;

    public CargoAlteracao() {
    }

    public CargoAlteracao(int id) {
        this.id = id;
    }

    public final int getId() {
        return this.id;
    }

    public final void setId(int id) {
        this.id = id;
    }

    public final String getEntidade() {
        return this.entidade;
    }

    public final void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public final String getCargoCodigo() {
        return this.cargoCodigo;
    }

    public final void setCargoCodigo(String cargoCodigo) {
        this.cargoCodigo = cargoCodigo;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public void setNumeroDocumento(String numdoc) {
        this.numeroDocumento = numdoc;
    }

    public String getObs() {
        return this.obs;
    }

    public void setObs(String obs) {
        this.obs = obs;
    }

    public Integer getCodigoTCEPR() {
        return this.codigoTCEPR;
    }

    public void setCodigoTCEPR(Integer codigoTcepr) {
        this.codigoTCEPR = codigoTcepr;
    }

    public CargoAlteracaoTipo getTipo() {
        if (this.tipo == null) {
            return CargoAlteracaoTipo.NENHUM;
        }
        return this.tipo;
    }

    public void setTipo(CargoAlteracaoTipo tipo) {
        this.tipo = tipo;
    }

    public VeiculoPublicacao getVeiculoPublicacao() {
        return this.veiculoPublicacao;
    }

    public void setVeiculoPublicacao(VeiculoPublicacao veiculoPublicacao) {
        this.veiculoPublicacao = veiculoPublicacao;
        this.veiculoPublicacaoCodigo = veiculoPublicacao != null ? veiculoPublicacao.getCodigo() : null;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal tipolegal) {
        this.tipoLegal = tipolegal;
        this.tipoLegalCodigo = tipolegal != null ? tipolegal.getCodigo() : null;
    }

    public String toString() {
        return "Tipo: " + this.tipoLegalCodigo + ", n\u00famero: " + this.numeroDocumento + ", data: " + this.data;
    }

    public Integer getVeiculoPublicacaoCodigo() {
        return this.veiculoPublicacaoCodigo;
    }

    public void setVeiculoPublicacaoCodigo(Integer veiculoPublicacaoCodigo) {
        this.veiculoPublicacaoCodigo = veiculoPublicacaoCodigo;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    public void setTipoLegalCodigo(Integer tipoLegalCodigo) {
        this.tipoLegalCodigo = tipoLegalCodigo;
    }

    @Override
    public Date getData() {
        return this.data;
    }

    @Override
    public void setData(Date data) {
        this.data = data;
    }

    public BigDecimal getQuantidade() {
        if (this.quantidade == null) {
            return null;
        }
        return BigDecimal.valueOf(this.quantidade);
    }

    public void setQuantidade(BigDecimal quantidade) {
        this.quantidade = quantidade == null ? null : Double.valueOf(quantidade.doubleValue());
    }

    public void setCargo(Cargo cargo) {
        if (cargo != null) {
            this.entidade = cargo.getCargoPK().getEntidade();
            this.cargoCodigo = cargo.getCargoPK().getCodigo();
        }
        this.cargo = cargo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CargoAlteracao other = (CargoAlteracao)obj;
        return this.id == other.id;
    }
}

