/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.AtividadeCargo;
import br.com.fiorilli.sip.persistence.entity.CargoAlteracao;
import br.com.fiorilli.sip.persistence.entity.CargoCriacao;
import br.com.fiorilli.sip.persistence.entity.CargoExtincao;
import br.com.fiorilli.sip.persistence.entity.CargoIR;
import br.com.fiorilli.sip.persistence.entity.CargoNatureza;
import br.com.fiorilli.sip.persistence.entity.CargoPK;
import br.com.fiorilli.sip.persistence.entity.CargoSIPREVAposentadoriaEspecial;
import br.com.fiorilli.sip.persistence.entity.CargoSIPREVTipoCargo;
import br.com.fiorilli.sip.persistence.entity.Carreira;
import br.com.fiorilli.sip.persistence.entity.ClassificacaoCargoAgentePolitico;
import br.com.fiorilli.sip.persistence.entity.Cnae;
import br.com.fiorilli.sip.persistence.entity.ConselhoRegional;
import br.com.fiorilli.sip.persistence.entity.DivisaoCargoAudesp;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.EventoCargo;
import br.com.fiorilli.sip.persistence.entity.Instrucao;
import br.com.fiorilli.sip.persistence.entity.PericiaNova;
import br.com.fiorilli.sip.persistence.entity.RegimeJuridico;
import br.com.fiorilli.sip.persistence.entity.SipAmCargos;
import br.com.fiorilli.sip.persistence.entity.SipMsCargo;
import br.com.fiorilli.sip.persistence.entity.SipMtCargosDiaria;
import br.com.fiorilli.sip.persistence.entity.SipmtCargos;
import br.com.fiorilli.sip.persistence.entity.SiprjCargos;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.gov.mg.tce.persistence.entity.SipMgCargo;
import br.gov.sp.tce.persistence.entity.FormaProvimentoCargoAudesp;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.math.NumberUtils;
import org.hibernate.annotations.Type;

@FilterConfigType
@Entity
@Table(name="CARGOS", uniqueConstraints={@UniqueConstraint(name="UNQ_IDCARGOS", columnNames={"ID"})})
@Audited
public class Cargo
implements Serializable,
GenericEntity,
Filterable {
    public static final String FIND_FOR_FILTER = "SELECT c FROM Cargo c WHERE UPPER(concat(c.cargoPK.codigo, c.nome)) LIKE UPPER('%'||:param||'%') AND c.cargoPK.entidade = :entidadeCodigo ORDER BY c.nome";
    public static final String CBO_CONSELHO_TUTELAR = "515320";
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected CargoPK cargoPK = new CargoPK();
    @Column(name="CODIGO", insertable=false, updatable=false)
    private String codigo;
    @Basic(optional=false)
    @NotNull
    @Column(name="ID")
    private int id;
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Size(max=6)
    @Column(name="CBO")
    private String cbo;
    @Column(name="VAGACARGO")
    private Short vagaCargo;
    @Column(name="VAGAFUNCAO")
    private Short vagaFuncao;
    @Column(name="VAGAEMPREGO")
    private Short vagaEmprego;
    @Column(name="VAGACONTRATO")
    private Short vagaContrato;
    @Embedded
    private CargoCriacao criacao;
    @Embedded
    private CargoExtincao extincao;
    @Type(type="BooleanTypeSip")
    @Column(name="SIPREV")
    private Boolean siprev;
    @Type(type="BooleanTypeSip")
    @Column(name="MUDAREFSAL")
    private Boolean mudarSalarioAutomaticamente;
    @Column(name="TEMPOANOS")
    private Double tempoAnos;
    @Column(name="TEMPOANOS_CARENCIA")
    private Double tempoAnosCarencia;
    @Column(name="HORASMES")
    private Double horasMes;
    @Column(name="HORASEMANAL")
    private Double horasSemanal;
    @Column(name="DIASSEMANA")
    private Double diasSemana;
    @Column(name="HORAS_EFETIVAS")
    private Double horasEfetivas;
    @Column(name="MUDAREFSAL_DTDOC")
    @Temporal(value=TemporalType.DATE)
    private Date mudarefsalDtdoc;
    @Size(max=16)
    @Column(name="MUDAREFSAL_NUMDOC")
    private String mudarefsalNumdoc;
    @Type(type="BooleanTypeSip")
    @Column(name="HORISTAS_MEDIA_FERIAS_13SAL")
    private Boolean horistasMediaFerias13Salario;
    @Column(name="SIPREV_TIPOAPOS")
    private Integer siprevTipoAposentadoria;
    @Type(type="BooleanTypeSip")
    @Column(name="SIPREV_ACUMULA")
    private Boolean siprevAcumula;
    @Enumerated
    @Column(name="TIPO_TCESP")
    private ClassificacaoCargoAgentePolitico classificacaoAgentePolitico;
    @Size(max=16)
    @Column(name="NUMERO_SELECAO")
    private String numeroSelecao;
    @Size(max=16)
    @Column(name="LEI_AUTORIZADORA_SELECAO")
    private String leiAutorizadoraSelecao;
    @Column(name="PRAZO_DIAS_SELECAO")
    private Integer prazoDiasSelecao;
    @Size(max=255)
    @Column(name="NOMECURSO_SUPERIOR")
    private String nomecursoSuperior;
    @Size(max=8)
    @Column(name="CODIGO_TCEPB")
    private String codigoTcepb;
    @Type(type="BooleanTypeSip")
    @Column(name="TECNICO_CIENTIFICO")
    private Boolean tecnicoCientifico;
    @Column(name="SIPREV_ACUMULA_TIPOCARGO")
    private Integer siprevAcumulaTipoCargo;
    @Size(max=3)
    @Column(name="CODIGO_TCEPR")
    private String codigoTcepr;
    @Column(name="CODIGOINT")
    private Integer codigoInt;
    @Type(type="BooleanTypeSip")
    @Column(name="MEDIA13SAL")
    private Boolean mediaAdiantamento13Salario;
    @Type(type="BooleanTypeSip")
    @Column(name="DEDICACAO_EXCLUSIVA")
    private Boolean dedicacaoExclusiva;
    @Size(max=10)
    @Column(name="CODIGO_TCEPR_ENTIDADE")
    private String codigoTceprEntidade;
    @Column
    @Type(type="NaturezaCargo")
    private CargoNatureza natureza;
    @JoinColumn(name="MUDAREFSAL_TIPOLEGAL", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal mudarefsalTipolegal;
    @Size(min=1, max=2)
    @Column(name="INSTRUCAO")
    private String instrucaoExigidaCodigo;
    @JoinColumn(name="INSTRUCAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Instrucao instrucaoExigida;
    @Column(name="CONSELHO_REGIONAL")
    private Integer conselhoRegionalCodigo;
    @JoinColumn(name="CONSELHO_REGIONAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private ConselhoRegional conselhoRegional;
    @Size(min=1, max=7)
    @Column(name="CNAE")
    private String cnaeCodigo;
    @JoinColumn(name="CNAE", referencedColumnName="COCNAE", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Cnae cnae;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Entidade entidade;
    @Column(name="CARREIRA")
    private Integer carreiraCodigo;
    @JoinColumn(name="CARREIRA", referencedColumnName="CODIGOCARREIRA", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Carreira carreira;
    @Size(min=1, max=3)
    @Column(name="CARGOIR")
    private String cargoIRCodigo;
    @JoinColumn(name="CARGOIR", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private CargoIR cargoIR;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="cargo", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CargoAlteracao> alteracoes;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="cargo", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EventoCargo> eventoCargoList;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="cargo", cascade={CascadeType.MERGE})
    private List<DivisaoCargoAudesp> divisaoAudespList;
    @Column(name="FORMA_PROVIMENTO")
    @Enumerated
    private FormaProvimentoCargoAudesp formaProvimento;
    @Enumerated
    @Column(name="REGIME_JURIDICO")
    private RegimeJuridico regimeJuridico;
    @Type(type="BooleanTypeSip")
    @Column(name="ENVIAR_AUDESP")
    private Boolean enviarParaAudesp;
    @Column(name="CARGO_TCESP")
    private String cargoAudesp;
    @Size(min=1, max=512)
    @Column(name="OBS")
    private String observacoes;
    @Type(type="BooleanTypeSip")
    @Column(name="NAO_ENV_QUADROPESSOAL_AUDESP")
    private Boolean naoEnviarQuadroPessoalAudesp;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="cargo", cascade={CascadeType.ALL}, orphanRemoval=true)
    private SipMgCargo tceMg;
    @OneToMany(mappedBy="cargos", fetch=FetchType.LAZY, orphanRemoval=true)
    private List<SipMtCargosDiaria> sipMtCargoDiaria;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CODIGO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private SipmtCargos sipmtCargo;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="cargoAtual")
    private List<Trabalhador> trabalhadorCargoAtual;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="cargoInicial")
    private List<Trabalhador> trabalhadorCargoInicial;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="cargo", cascade={CascadeType.ALL})
    private List<SipMsCargo> tceMs = new ArrayList<SipMsCargo>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="cargos", cascade={CascadeType.ALL})
    private List<SiprjCargos> tceRj = new ArrayList<SiprjCargos>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="cargos", cascade={CascadeType.ALL})
    private List<SipAmCargos> tceAm = new ArrayList<SipAmCargos>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="cargo", cascade={CascadeType.ALL})
    private List<PericiaNova> pericias = new ArrayList<PericiaNova>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="cargo", cascade={CascadeType.ALL})
    private List<AtividadeCargo> atividadesCargo = new ArrayList<AtividadeCargo>();

    public Cargo() {
    }

    public Cargo(CargoPK cargosPK) {
        this.cargoPK = cargosPK;
    }

    public Cargo(CargoPK cargosPK, int id) {
        this.cargoPK = cargosPK;
        this.id = id;
    }

    public Cargo(String entidade, String codigo) {
        this.cargoPK = new CargoPK(entidade, codigo);
    }

    public boolean isRadiologista() {
        if (!NumberUtils.isNumber((String)this.getCbo())) {
            return false;
        }
        return this.getCbo().equals("225320") || this.getCbo().equals("324115") || this.getCbo().equals("324120") || this.getCbo().equals("766420");
    }

    public boolean isProfessor() {
        if (!NumberUtils.isNumber((String)this.getCbo()) || this.getCbo().length() < 3) {
            return false;
        }
        Integer subgrupo = Integer.valueOf(this.getCbo().substring(0, 3));
        return subgrupo >= 231 && subgrupo <= 234 || subgrupo == 239 || subgrupo >= 331 && subgrupo <= 333;
    }

    public boolean isMilitar() {
        if (!NumberUtils.isNumber((String)this.getCbo())) {
            return false;
        }
        return this.getCbo().substring(0, 1).equals("0");
    }

    public boolean isProfissionalSaude() {
        if (!NumberUtils.isNumber((String)this.getCbo()) || this.getCbo().length() < 3) {
            return false;
        }
        Integer subgrupo = Integer.valueOf(this.getCbo().substring(0, 3));
        return subgrupo >= 223 && subgrupo <= 226;
    }

    public boolean isAgentePolitico() {
        if (!NumberUtils.isNumber((String)this.getCbo())) {
            return false;
        }
        return this.cbo != null && (this.cbo.equals("111250") || this.cbo.equals("111255") || this.cbo.equals("111220") || this.cbo.equals("111120") || this.cbo.startsWith("1114")) || this.getClassificacaoAgentePolitico() != null && ClassificacaoCargoAgentePolitico.NAO_AGENTE_POLITICO != this.getClassificacaoAgentePolitico();
    }

    public CargoPK getCargoPK() {
        if (this.cargoPK == null) {
            this.cargoPK = new CargoPK();
        }
        return this.cargoPK;
    }

    public void setCargoPK(CargoPK cargoPK) {
        this.cargoPK = cargoPK;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getCbo() {
        return this.cbo;
    }

    public void setCbo(String cbo) {
        this.cbo = cbo;
    }

    public Short getVagaCargo() {
        return this.vagaCargo;
    }

    public void setVagaCargo(Short vagacargo) {
        this.vagaCargo = vagacargo;
    }

    public Short getVagaFuncao() {
        return this.vagaFuncao;
    }

    public void setVagaFuncao(Short vagafuncao) {
        this.vagaFuncao = vagafuncao;
    }

    public Short getVagaEmprego() {
        return this.vagaEmprego;
    }

    public void setVagaEmprego(Short vagaemprego) {
        this.vagaEmprego = vagaemprego;
    }

    public Double getTempoAnos() {
        return this.tempoAnos;
    }

    public void setTempoAnos(Double tempoanos) {
        this.tempoAnos = tempoanos;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Integer getConselhoRegionalCodigo() {
        return this.conselhoRegionalCodigo;
    }

    public void setConselhoRegionalCodigo(Integer conselhoRegional) {
        this.conselhoRegionalCodigo = conselhoRegional;
    }

    public Double getHorasMes() {
        return this.horasMes;
    }

    public void setHorasMes(Double horasmes) {
        this.horasMes = horasmes;
    }

    public Double getHorasSemanal() {
        return this.horasSemanal;
    }

    public void setHorasSemanal(Double horasemanal) {
        this.horasSemanal = horasemanal;
    }

    public Double getDiasSemana() {
        return this.diasSemana;
    }

    public void setDiasSemana(Double diassemana) {
        this.diasSemana = diassemana;
    }

    public Double getHorasEfetivas() {
        return this.horasEfetivas;
    }

    public void setHorasEfetivas(Double horasEfetivas) {
        this.horasEfetivas = horasEfetivas;
    }

    public Date getMudarefsalDtdoc() {
        return this.mudarefsalDtdoc;
    }

    public void setMudarefsalDtdoc(Date mudarefsalDtdoc) {
        this.mudarefsalDtdoc = mudarefsalDtdoc;
    }

    public String getMudarefsalNumdoc() {
        return this.mudarefsalNumdoc;
    }

    public void setMudarefsalNumdoc(String mudarefsalNumdoc) {
        this.mudarefsalNumdoc = mudarefsalNumdoc;
    }

    public CargoSIPREVAposentadoriaEspecial getSiprevTipoAposentadoria() {
        return CargoSIPREVAposentadoriaEspecial.get(this.siprevTipoAposentadoria);
    }

    public void setSiprevTipoAposentadoria(CargoSIPREVAposentadoriaEspecial siprevTipoapos) {
        this.siprevTipoAposentadoria = siprevTipoapos != null ? siprevTipoapos.getCodigo() : null;
    }

    public Boolean getSiprevAcumula() {
        return this.siprevAcumula;
    }

    public void setSiprevAcumula(Boolean siprevAcumula) {
        this.siprevAcumula = siprevAcumula;
    }

    public ClassificacaoCargoAgentePolitico getClassificacaoAgentePolitico() {
        return this.classificacaoAgentePolitico;
    }

    public void setClassificacaoAgentePolitico(ClassificacaoCargoAgentePolitico tipoTcesp) {
        this.classificacaoAgentePolitico = tipoTcesp;
    }

    public String getNumeroSelecao() {
        return this.numeroSelecao;
    }

    public void setNumeroSelecao(String numeroSelecao) {
        this.numeroSelecao = numeroSelecao;
    }

    public String getLeiAutorizadoraSelecao() {
        return this.leiAutorizadoraSelecao;
    }

    public void setLeiAutorizadoraSelecao(String leiAutorizadoraSelecao) {
        this.leiAutorizadoraSelecao = leiAutorizadoraSelecao;
    }

    public Integer getPrazoDiasSelecao() {
        return this.prazoDiasSelecao;
    }

    public void setPrazoDiasSelecao(Integer prazoDiasSelecao) {
        this.prazoDiasSelecao = prazoDiasSelecao;
    }

    public String getNomecursoSuperior() {
        return this.nomecursoSuperior;
    }

    public void setNomecursoSuperior(String nomecursoSuperior) {
        this.nomecursoSuperior = nomecursoSuperior;
    }

    public String getCodigoTcepb() {
        return this.codigoTcepb;
    }

    public void setCodigoTcepb(String codigoTcepb) {
        this.codigoTcepb = codigoTcepb;
    }

    public CargoSIPREVTipoCargo getSiprevAcumulaTipoCargo() {
        return CargoSIPREVTipoCargo.get(this.siprevAcumulaTipoCargo);
    }

    public void setSiprevAcumulaTipoCargo(CargoSIPREVTipoCargo siprevAcumulaTipocargo) {
        this.siprevAcumulaTipoCargo = siprevAcumulaTipocargo != null ? Integer.valueOf(siprevAcumulaTipocargo.getCodigo()) : null;
    }

    public String getCodigoTcepr() {
        return this.codigoTcepr;
    }

    public void setCodigoTcepr(String codigoTcepr) {
        this.codigoTcepr = codigoTcepr;
    }

    public Integer getCodigoInt() {
        return this.codigoInt;
    }

    public void setCodigoInt(Integer codigoint) {
        this.codigoInt = codigoint;
    }

    public Short getVagaContrato() {
        return this.vagaContrato;
    }

    public void setVagaContrato(Short vagacontrato) {
        this.vagaContrato = vagacontrato;
    }

    public Integer getVagaTotalCargoAudesp() {
        Integer total = 0;
        if (this.vagaCargo != null) {
            total = total + this.vagaCargo;
        }
        if (this.vagaFuncao != null) {
            total = total + this.vagaFuncao;
        }
        if (this.vagaEmprego != null) {
            total = total + this.vagaEmprego;
        }
        return total;
    }

    public String getCodigoTceprEntidade() {
        return this.codigoTceprEntidade;
    }

    public void setCodigoTceprEntidade(String codigoTceprEntidade) {
        this.codigoTceprEntidade = codigoTceprEntidade;
    }

    public TipoDocumentoLegal getMudarefsalTipolegal() {
        return this.mudarefsalTipolegal;
    }

    public void setMudarefsalTipolegal(TipoDocumentoLegal mudarefsalTipolegal) {
        this.mudarefsalTipolegal = mudarefsalTipolegal;
    }

    public CargoNatureza getNatureza() {
        return this.natureza;
    }

    public Instrucao getInstrucaoExigida() {
        return this.instrucaoExigida;
    }

    public void setInstrucaoExigida(Instrucao instrucao) {
        this.instrucaoExigidaCodigo = instrucao != null ? instrucao.getCodigo() : null;
        this.instrucaoExigida = instrucao;
    }

    public Cnae getCnae() {
        return this.cnae;
    }

    public void setCnae(Cnae cnae) {
        this.cnaeCodigo = cnae != null ? cnae.getCodigo() : null;
        this.cnae = cnae;
    }

    public Entidade getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Entidade entidade1) {
        this.entidade = entidade1;
    }

    public Carreira getCarreira() {
        return this.carreira;
    }

    public void setCarreira(Carreira carreira) {
        this.carreira = carreira;
        this.carreiraCodigo = carreira != null ? carreira.getCodigo() : null;
    }

    public String getCargoIRCodigo() {
        return this.cargoIRCodigo;
    }

    public void setCargoIRCodigo(String cargoIRCodigo) {
        this.cargoIRCodigo = cargoIRCodigo;
    }

    public void setCargoIR(CargoIR cargoIR) {
        this.cargoIR = cargoIR;
        this.cargoIRCodigo = cargoIR != null ? cargoIR.getCodigo() : null;
    }

    public CargoIR getCargoIR() {
        return this.cargoIR;
    }

    public Boolean getSiprev() {
        return this.siprev;
    }

    public void setSiprev(Boolean siprev) {
        this.siprev = siprev;
    }

    public Boolean getMudarSalarioAutomaticamente() {
        return this.mudarSalarioAutomaticamente;
    }

    public void setMudarSalarioAutomaticamente(Boolean mudarefsal) {
        this.mudarSalarioAutomaticamente = mudarefsal;
    }

    public Boolean getHoristasMediaFerias13Salario() {
        return this.horistasMediaFerias13Salario;
    }

    public void setHoristasMediaFerias13Salario(Boolean horistasMediaFerias13sal) {
        this.horistasMediaFerias13Salario = horistasMediaFerias13sal;
    }

    public Boolean getTecnicoCientifico() {
        return this.tecnicoCientifico;
    }

    public void setTecnicoCientifico(Boolean tecnicoCientifico) {
        this.tecnicoCientifico = tecnicoCientifico;
    }

    public Boolean getMediaAdiantamento13Salario() {
        return this.mediaAdiantamento13Salario;
    }

    public void setMediaAdiantamento13Salario(Boolean media13sal) {
        this.mediaAdiantamento13Salario = media13sal;
    }

    public Boolean getDedicacaoExclusiva() {
        return this.dedicacaoExclusiva;
    }

    public void setDedicacaoExclusiva(Boolean dedicacaoExclusiva) {
        this.dedicacaoExclusiva = dedicacaoExclusiva;
    }

    public void setNatureza(CargoNatureza natureza) {
        this.natureza = natureza;
    }

    public List<AtividadeCargo> getAtividadesCargo() {
        return this.atividadesCargo;
    }

    public void setAtividadesCargo(List<AtividadeCargo> atividadesCargo) {
        this.atividadesCargo = atividadesCargo;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.cargoPK != null ? this.cargoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Cargo)) {
            return false;
        }
        Cargo other = (Cargo)object;
        return (this.cargoPK != null || other.cargoPK == null) && (this.cargoPK == null || this.cargoPK.equals(other.cargoPK));
    }

    public String toString() {
        return "Cargo " + this.cargoPK.toString();
    }

    public String getCnaeCodigo() {
        return this.cnaeCodigo;
    }

    public void setCnaeCodigo(String cnaeCodigo) {
        this.cnaeCodigo = cnaeCodigo;
    }

    public ConselhoRegional getConselhoRegional() {
        return this.conselhoRegional;
    }

    public void setConselhoRegional(ConselhoRegional conselhoRegional) {
        this.conselhoRegional = conselhoRegional;
        this.conselhoRegionalCodigo = conselhoRegional != null ? conselhoRegional.getCodigo() : null;
    }

    public Integer getCarreiraCodigo() {
        return this.carreiraCodigo;
    }

    public void setCarreiraCodigo(Integer carreiraCodigo) {
        this.carreiraCodigo = carreiraCodigo;
    }

    public List<EventoCargo> getEventoCargoList() {
        return this.eventoCargoList;
    }

    public void setEventoCargoList(List<EventoCargo> eventoCargoList) {
        this.eventoCargoList = eventoCargoList;
    }

    public List<CargoAlteracao> getAlteracoes() {
        return this.alteracoes;
    }

    public void setAlteracoes(List<CargoAlteracao> cargoAlteracoes) {
        this.alteracoes = cargoAlteracoes;
    }

    public String getInstrucaoExigidaCodigo() {
        return this.instrucaoExigidaCodigo;
    }

    public void setInstrucaoExigidaCodigo(String instrucaoCodigo) {
        this.instrucaoExigidaCodigo = instrucaoCodigo;
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.hashCode());
    }

    public String getItemId() {
        return this.cargoPK.getCodigo();
    }

    public String getItemLabel() {
        return this.nome;
    }

    public FormaProvimentoCargoAudesp getFormaProvimento() {
        return this.formaProvimento;
    }

    public void setFormaProvimento(FormaProvimentoCargoAudesp formaProvimento) {
        this.formaProvimento = formaProvimento;
    }

    public RegimeJuridico getRegimeJuridico() {
        return this.regimeJuridico;
    }

    public void setRegimeJuridico(RegimeJuridico regimeJuridico) {
        this.regimeJuridico = regimeJuridico;
    }

    public final Boolean getEnviarParaAudesp() {
        return this.enviarParaAudesp;
    }

    public final void setEnviarParaAudesp(Boolean enviarParaAudesp) {
        this.enviarParaAudesp = enviarParaAudesp;
    }

    public final CargoCriacao getCriacaoNotNull() {
        if (this.criacao == null) {
            this.criacao = new CargoCriacao(this);
        }
        return this.criacao;
    }

    public final CargoCriacao getCriacao() {
        if (this.criacao == null) {
            this.criacao = new CargoCriacao();
        }
        return this.criacao;
    }

    public final void setCriacao(CargoCriacao criacao) {
        this.criacao = criacao;
    }

    public final CargoExtincao getExtincaoNotNull() {
        if (this.extincao == null) {
            this.extincao = new CargoExtincao();
        }
        return this.extincao;
    }

    public CargoExtincao getExtincao() {
        if (this.extincao == null) {
            this.extincao = new CargoExtincao();
        }
        return this.extincao;
    }

    public final void setExtincao(CargoExtincao extincao) {
        this.extincao = extincao;
    }

    public final Boolean isCriacaoEmpty() {
        return this.criacao == null || this.criacao != null && this.criacao.isEmpty();
    }

    public final Boolean isExtincaoEmpty() {
        return this.extincao == null || this.extincao != null && this.extincao.isEmpty();
    }

    public boolean isMotoristaCNH() {
        List<String> codigos = Arrays.asList("782305", "782310", "782315", "782405", "782410", "782415", "782505", "782510", "782515");
        for (String c : codigos) {
            if (!c.equals(this.cbo)) continue;
            return true;
        }
        return false;
    }

    public void setTceMg(SipMgCargo tceMg) {
        this.tceMg = tceMg;
    }

    public SipMgCargo getTceMg() {
        if (this.tceMg == null) {
            this.tceMg = new SipMgCargo();
        }
        return this.tceMg;
    }

    public List<Trabalhador> getTrabalhadorCargoAtual() {
        return this.trabalhadorCargoAtual;
    }

    public void setTrabalhadorCargoAtual(List<Trabalhador> trabalhadorCargoAtual) {
        this.trabalhadorCargoAtual = trabalhadorCargoAtual;
    }

    public List<Trabalhador> getTrabalhadorCargoInicial() {
        return this.trabalhadorCargoInicial;
    }

    public void setTrabalhadorCargoInicial(List<Trabalhador> trabalhadorCargoInicial) {
        this.trabalhadorCargoInicial = trabalhadorCargoInicial;
    }

    public String getObservacoes() {
        return this.observacoes;
    }

    public void setObservacoes(String observacoes) {
        this.observacoes = observacoes;
    }

    public List<SipMtCargosDiaria> getSipMtCargoDiaria() {
        return this.sipMtCargoDiaria;
    }

    public void setSipMtCargoDiaria(List<SipMtCargosDiaria> sipMtCargoDiaria) {
        this.sipMtCargoDiaria = sipMtCargoDiaria;
    }

    public SipmtCargos getSipmtCargo() {
        if (this.sipmtCargo == null) {
            this.sipmtCargo = new SipmtCargos();
        }
        return this.sipmtCargo;
    }

    public void setSipmtCargo(SipmtCargos sipmtCargo) {
        this.sipmtCargo = sipmtCargo;
    }

    public List<DivisaoCargoAudesp> getDivisaoAudespList() {
        return this.divisaoAudespList;
    }

    public static Cargo of(String cbo, ClassificacaoCargoAgentePolitico classificacaoAgentePublico) {
        Cargo c = new Cargo();
        c.setCbo(cbo);
        c.setClassificacaoAgentePolitico(classificacaoAgentePublico);
        return c;
    }

    public Double getTempoAnosCarencia() {
        return this.tempoAnosCarencia;
    }

    public void setTempoAnosCarencia(Double tempoAnosCarencia) {
        this.tempoAnosCarencia = tempoAnosCarencia;
    }

    public List<SipMsCargo> getTceMs() {
        return this.tceMs;
    }

    public void setTceMs(List<SipMsCargo> tceMs) {
        this.tceMs = tceMs;
    }

    public List<SiprjCargos> getTceRj() {
        return this.tceRj;
    }

    public void setTceRj(List<SiprjCargos> tceRj) {
        this.tceRj = tceRj;
    }

    public List<SipAmCargos> getTceAm() {
        return this.tceAm;
    }

    public void setTceAm(List<SipAmCargos> tceAm) {
        this.tceAm = tceAm;
    }

    public String getCargoAudesp() {
        return this.cargoAudesp;
    }

    public void setCargoAudesp(String cargoAudesp) {
        this.cargoAudesp = cargoAudesp;
    }

    public List<PericiaNova> getPericias() {
        return this.pericias;
    }

    public void setPericias(List<PericiaNova> pericias) {
        this.pericias = pericias;
    }

    public boolean isTemporario() {
        return this.natureza != null && this.natureza.isTemporario();
    }

    public Boolean getNaoEnviarQuadroPessoalAudesp() {
        return this.naoEnviarQuadroPessoalAudesp;
    }

    public void setNaoEnviarQuadroPessoalAudesp(Boolean naoEnviarQuadroPessoalAudesp) {
        this.naoEnviarQuadroPessoalAudesp = naoEnviarQuadroPessoalAudesp;
    }
}

