/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.LicencaPremioMovimento;
import br.com.fiorilli.sip.persistence.entity.SiplogAction;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.TipoGozo;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import br.com.fiorilli.sipweb.vo.TipoAusencia;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="CANCELA_LICENCAPREMIO")
@Audited
public class CancelaLicencaPremio
implements Serializable,
Documento {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_CANCELALICENCAPREMIO";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Column(name="DTRETORNO")
    @Temporal(value=TemporalType.DATE)
    private Date dtretorno;
    @Column(name="DIAS_GOZADOS")
    private Short diasGozados;
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date datadoc;
    @Size(max=16)
    @Column(name="NUMDOC")
    private String numdoc;
    @Column(name="OBS")
    private String obs;
    @Column(name="DHACAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dhacao;
    @Column(name="TIPO")
    private Character tipo;
    @Column(name="DIAS_RESTANTES")
    private Short diasRestantes;
    @JoinColumn(name="USUARIO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Usuario usuario;
    @Column(name="USUARIO")
    private Integer usuarioCodigo;
    @Column(name="TIPOLEGAL")
    private Integer tipoLegalCodigo;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipolegal;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false), @JoinColumn(name="LICENCAPREMIO", referencedColumnName="LICENCAPREMIO", insertable=false, updatable=false), @JoinColumn(name="ITEMLICENCAPREMIO", referencedColumnName="ITEM", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private LicencaPremioMovimento movtolicencapremio;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidade;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @Basic(optional=false)
    @NotNull
    @Column(name="LICENCAPREMIO")
    private Short licencapremio;
    @Basic(optional=false)
    @NotNull
    @Column(name="ITEMLICENCAPREMIO")
    private Short itemLicencaPremio;

    public CancelaLicencaPremio() {
    }

    public CancelaLicencaPremio(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public Date getDtretorno() {
        return this.dtretorno;
    }

    public void setDtretorno(Date dtretorno) {
        this.dtretorno = dtretorno;
    }

    public Short getDiasGozados() {
        return this.diasGozados;
    }

    public void setDiasGozados(Short diasGozados) {
        this.diasGozados = diasGozados;
    }

    public Date getDatadoc() {
        return this.datadoc;
    }

    public void setDatadoc(Date datadoc) {
        this.datadoc = datadoc;
    }

    public String getNumdoc() {
        return this.numdoc;
    }

    public void setNumdoc(String numdoc) {
        this.numdoc = numdoc;
    }

    public String getObs() {
        return this.obs;
    }

    public void setObs(String obs) {
        this.obs = obs;
    }

    public Date getDhacao() {
        return this.dhacao;
    }

    public void setDhacao(Date dhacao) {
        this.dhacao = dhacao;
    }

    public TipoGozo getTipo() {
        if (this.tipo == null) {
            this.tipo = TipoGozo.CANCELADO.getCodigo();
        }
        return TipoGozo.getEntity(this.tipo.charValue());
    }

    public void setTipo(TipoGozo tipo) {
        this.tipo = tipo.getCodigo();
    }

    public Short getDiasRestantes() {
        return this.diasRestantes;
    }

    public void setDiasRestantes(Short diasRestantes) {
        this.diasRestantes = diasRestantes;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public LicencaPremioMovimento getMovtolicencapremio() {
        return this.movtolicencapremio;
    }

    public void setMovtolicencapremio(LicencaPremioMovimento movtolicencapremio) {
        this.movtolicencapremio = movtolicencapremio;
        if (movtolicencapremio != null) {
            this.setRegistro(this.movtolicencapremio.getLicencaPremioMovimentoPK().getRegistro());
            this.setEntidade(this.movtolicencapremio.getLicencaPremioMovimentoPK().getEntidade());
            this.setItemLicencaPremio(this.movtolicencapremio.getLicencaPremioMovimentoPK().getItem());
            this.setLicencapremio(this.movtolicencapremio.getLicencaPremioMovimentoPK().getLicencapremio());
        } else {
            this.setRegistro(null);
            this.setEntidade(null);
            this.setItemLicencaPremio(null);
            this.setLicencapremio(null);
        }
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CancelaLicencaPremio)) {
            return false;
        }
        CancelaLicencaPremio other = (CancelaLicencaPremio)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "CancelaLicencaPremio{codigo=" + this.codigo + '}';
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public Short getLicencapremio() {
        return this.licencapremio;
    }

    public void setLicencapremio(Short licencapremio) {
        this.licencapremio = licencapremio;
    }

    public Short getItemLicencaPremio() {
        return this.itemLicencaPremio;
    }

    public void setItemLicencaPremio(Short itemLicencaPremio) {
        this.itemLicencaPremio = itemLicencaPremio;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipolegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal value) {
        this.tipoLegalCodigo = this.tipolegal != null ? value.getCodigo() : null;
        this.tipolegal = value;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numdoc;
    }

    @Override
    public void setNumeroDocumento(String value) {
        this.numdoc = value;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numdoc);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numdoc);
    }

    @Override
    public Date getData() {
        return this.datadoc;
    }

    @Override
    public void setData(Date value) {
        this.datadoc = value;
    }

    public Integer getUsuarioCodigo() {
        return this.usuarioCodigo;
    }

    public void setUsuarioCodigo(Integer usuarioCodigo) {
        this.usuarioCodigo = usuarioCodigo;
    }

    public static String getSqlNativeLicencaConvocadaByPeriod() {
        String sql = "SELECT COALESCE(m1.EMPRESA, m2.EMPRESA), COALESCE(m1.REGISTRO, m2.REGISTRO), COALESCE(m1.GOZOINI, m2.GOZOINI), case sl.ACTIONID WHEN " + SiplogAction.EXCLUIU.ordinal() + " THEN COALESCE(m1.GOZOFIM, m2.GOZOFIM) ELSE COALESCE(c1.DTRETORNO, c2.DTRETORNO) END, " + "'" + TipoAusencia.LICENCA_PREMIO.getId() + "', " + "(COALESCE(m1.EMPRESA, m2.EMPRESA) || '-' || COALESCE(m1.LICENCAPREMIO, m2.LICENCAPREMIO) || '-' || COALESCE(m1.ITEM, m2.ITEM) || '-' || COALESCE(m1.REGISTRO, m2.REGISTRO)), " + "t.MATRICULA, t.CONTRATO, t.CPF, " + "sl.LOGDATE, '' AS LOGTEXT, sl.LOGHOUR " + "FROM SIPLOG sl " + "INNER JOIN SIPLOG_TABLE st ON st.CODIGO = sl.TABLEID ";
        sql = sql + "LEFT JOIN CANCELA_LICENCAPREMIO c1 ON c1.CODIGO = sl.CHAVE LEFT JOIN CANCELA_LICENCAPREMIO c2 ON REPLACE(SL.LOGTEXT, ASCII_CHAR(13) || ASCII_CHAR(10), '')  LIKE '%EMPRESA=' || c2.EMPRESA || 'REGISTRO=' || c2.REGISTRO  || 'LICENCAPREMIO=' || c2.LICENCAPREMIO || 'ITEMLICENCAPREMIO=' || c2.ITEMLICENCAPREMIO || 'D%' LEFT JOIN MOVTOLICENCAPREMIO m1 ON m1.EMPRESA = COALESCE(c1.EMPRESA, c2.EMPRESA) AND m1.REGISTRO = COALESCE(c1.REGISTRO, c2.REGISTRO)  AND m1.LICENCAPREMIO = COALESCE(c1.LICENCAPREMIO, c2.LICENCAPREMIO) AND m1.ITEM = COALESCE(c1.ITEMLICENCAPREMIO, c2.ITEMLICENCAPREMIO) ";
        sql = sql + "LEFT JOIN MOVTOLICENCAPREMIO m2 ON REPLACE(SL.LOGTEXT, ASCII_CHAR(13) || ASCII_CHAR(10), '')  LIKE '%EMPRESA=' || m2.EMPRESA || 'REGISTRO=' || m2.REGISTRO  || 'LICENCAPREMIO=' || m2.LICENCAPREMIO || 'ITEMLICENCAPREMIO=' || m2.ITEM || 'D%' ";
        sql = sql + "INNER JOIN TRABALHADOR t ON t.EMPRESA = COALESCE(m1.EMPRESA, m2.EMPRESA) AND t.REGISTRO = COALESCE(m1.REGISTRO, m2.REGISTRO) WHERE sl.LOGTEXT LIKE '%EMPRESA=' || :entidadeCodigo || '%'  AND sl.LOGDATE BETWEEN :dataInicial AND :dataFinal  AND sl.ACTIONID IN (" + SiplogAction.INCLUIU.ordinal() + "," + SiplogAction.EXCLUIU.ordinal() + ") " + " AND st.NOME = 'CANCELA_LICENCAPREMIO' " + " AND sl.LOGTEXT LIKE '%TIPO=' || " + TipoGozo.CONVOCADO.getCodigo() + " || '%' ";
        return sql;
    }

    public static String getSqlNativeLicencaCanceladaByPeriod(SiplogAction action) {
        String sql = "SELECT DISTINCT m.EMPRESA, m.REGISTRO, m.GOZOINI, m.GOZOFIM, '" + TipoAusencia.LICENCA_PREMIO.getId() + "', " + "(m.EMPRESA || '-' || m.LICENCAPREMIO || '-' || m.ITEM || '-' || m.REGISTRO), " + "t.MATRICULA, t.CONTRATO, t.CPF, " + "sl.LOGDATE, '' AS LOGTEXT, sl.LOGHOUR " + "FROM SIPLOG sl " + "INNER JOIN SIPLOG_TABLE st ON st.CODIGO = sl.TABLEID ";
        sql = action.equals((Object)SiplogAction.EXCLUIU) ? sql + "INNER JOIN MOVTOLICENCAPREMIO m ON REPLACE(SL.LOGTEXT, ASCII_CHAR(13) || ASCII_CHAR(10), '')  LIKE '%EMPRESA=' || m.EMPRESA || 'REGISTRO=' || m.REGISTRO  || 'LICENCAPREMIO=' || m.LICENCAPREMIO || 'ITEMLICENCAPREMIO=' || m.ITEM || 'D%' " : sql + "INNER JOIN CANCELA_LICENCAPREMIO c ON c.CODIGO = sl.CHAVE INNER JOIN MOVTOLICENCAPREMIO m ON m.EMPRESA = c.EMPRESA AND m.REGISTRO = c.REGISTRO  AND m.LICENCAPREMIO = c.LICENCAPREMIO AND m.ITEM = c.ITEMLICENCAPREMIO ";
        sql = sql + "INNER JOIN TRABALHADOR t ON t.EMPRESA = m.EMPRESA AND t.REGISTRO = m.REGISTRO WHERE sl.LOGTEXT LIKE '%EMPRESA=' || :entidadeCodigo || '%'  AND sl.LOGDATE BETWEEN :dataInicial AND :dataFinal  AND sl.ACTIONID = " + action.ordinal() + " " + " AND st.NOME = 'CANCELA_LICENCAPREMIO' " + " AND sl.LOGTEXT LIKE '%TIPO=' || " + TipoGozo.CANCELADO.getCodigo() + " || '%' ";
        return sql;
    }
}

