/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.FeriasMovimento;
import br.com.fiorilli.sip.persistence.entity.SiplogAction;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.TipoGozo;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import br.com.fiorilli.sipweb.vo.TipoAusencia;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CANCELA_FERIAS")
@Audited
public class CancelaFerias
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Column(name="DTRETORNO")
    @Temporal(value=TemporalType.DATE)
    private Date dataRetorno;
    @Column(name="DIAS_GOZADOS")
    private Short diasGozados;
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date datadoc;
    @Size(max=16)
    @Column(name="NUMDOC")
    private String numdoc;
    @Lob
    @Column(name="OBS")
    private byte[] obs;
    @Column(name="DHACAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dhacao;
    @Column(name="TIPO", updatable=false, insertable=false)
    private Character tipo;
    @Enumerated
    @Type(type="TipoGozo")
    @Column(name="TIPO")
    private TipoGozo tipoGozo;
    @Column(name="DIAS_RESTANTES")
    private Short diasRestantes;
    @JoinColumn(name="USUARIO", referencedColumnName="CODIGO")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Usuario usuario;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipolegal;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA"), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO"), @JoinColumn(name="FERIAS", referencedColumnName="FERIAS"), @JoinColumn(name="ITEMFERIAS", referencedColumnName="ITEM")})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private FeriasMovimento feriasMovimento;

    public CancelaFerias() {
    }

    public CancelaFerias(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public Date getDataRetorno() {
        return this.dataRetorno;
    }

    public void setDataRetorno(Date dtretorno) {
        this.dataRetorno = dtretorno;
    }

    public Short getDiasGozados() {
        return this.diasGozados;
    }

    public void setDiasGozados(Short diasGozados) {
        this.diasGozados = diasGozados;
    }

    public Date getDatadoc() {
        return this.datadoc;
    }

    public void setDatadoc(Date datadoc) {
        this.datadoc = datadoc;
    }

    public String getNumdoc() {
        return this.numdoc;
    }

    public void setNumdoc(String numdoc) {
        this.numdoc = numdoc;
    }

    public byte[] getObs() {
        return this.obs;
    }

    public void setObs(byte[] obs) {
        this.obs = obs;
    }

    public Date getDhacao() {
        return this.dhacao;
    }

    public void setDhacao(Date dhacao) {
        this.dhacao = dhacao;
    }

    public TipoGozo getTipo() {
        return TipoGozo.getEntity(this.tipo.charValue());
    }

    public void setTipo(TipoGozo tipo) {
        this.tipo = tipo.getCodigo();
    }

    public Short getDiasRestantes() {
        return this.diasRestantes;
    }

    public void setDiasRestantes(Short diasRestantes) {
        this.diasRestantes = diasRestantes;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public TipoDocumentoLegal getTipolegal() {
        return this.tipolegal;
    }

    public void setTipolegal(TipoDocumentoLegal tipolegal) {
        this.tipolegal = tipolegal;
    }

    public FeriasMovimento getMovimentoFerias() {
        return this.feriasMovimento;
    }

    public void setMovimentoFerias(FeriasMovimento movtoferias) {
        this.feriasMovimento = movtoferias;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CancelaFerias)) {
            return false;
        }
        CancelaFerias other = (CancelaFerias)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.CancelaFerias[ codigo=" + this.codigo + " ]";
    }

    public TipoGozo getTipoGozo() {
        return this.tipoGozo;
    }

    public void setTipoGozo(TipoGozo tipoGozo) {
        this.tipoGozo = tipoGozo;
    }

    public static String getSqlNativeFeriasConvocadasByPeriod(SiplogAction action) {
        String sql = "SELECT DISTINCT m.EMPRESA, m.REGISTRO, m.GOZOINI, " + (action.equals((Object)SiplogAction.EXCLUIU) ? "m.GOZOFIM" : "c.DTRETORNO") + ", " + "'" + TipoAusencia.FERIAS.getId() + "', " + "(m.EMPRESA || '-' || m.FERIAS || '-' || m.ITEM || '-' || m.REGISTRO), " + "t.MATRICULA, t.CONTRATO, t.CPF, " + "sl.LOGDATE, '' AS LOGTEXT, sl.LOGHOUR " + "FROM SIPLOG sl " + "INNER JOIN SIPLOG_TABLE st ON st.CODIGO = sl.TABLEID ";
        sql = action.equals((Object)SiplogAction.EXCLUIU) ? sql + "INNER JOIN MOVTOFERIAS m ON REPLACE(SL.LOGTEXT, ASCII_CHAR(13) || ASCII_CHAR(10), '')  LIKE '%EMPRESA=' || m.EMPRESA || 'REGISTRO=' || m.REGISTRO  || 'FERIAS=' || m.FERIAS || 'ITEMFERIAS=' || m.ITEM || 'D%'" : sql + "INNER JOIN CANCELA_FERIAS c ON c.CODIGO = sl.CHAVE INNER JOIN MOVTOFERIAS m ON m.EMPRESA = c.EMPRESA  AND m.REGISTRO = c.REGISTRO AND m.FERIAS = c.FERIAS AND m.ITEM = c.ITEMFERIAS ";
        sql = sql + "INNER JOIN TRABALHADOR t ON t.EMPRESA = m.EMPRESA AND t.REGISTRO = m.REGISTRO WHERE sl.LOGTEXT LIKE '%EMPRESA=' || :entidadeCodigo || '%'  AND sl.LOGDATE BETWEEN :dataInicial AND :dataFinal  AND sl.ACTIONID = " + action.ordinal() + " " + " AND st.NOME = 'CANCELA_FERIAS' " + " AND sl.LOGTEXT LIKE '%TIPO=' || " + TipoGozo.CONVOCADO.getCodigo() + " || '%' ";
        return sql;
    }

    public static String getSqlNativeFeriasCanceladasByPeriod(SiplogAction action) {
        String sql = "SELECT DISTINCT m.EMPRESA, m.REGISTRO, m.GOZOINI, m.GOZOFIM, '" + TipoAusencia.FERIAS.getId() + "', " + "(m.EMPRESA || '-' || m.FERIAS || '-' || m.ITEM || '-' || m.REGISTRO), " + "t.MATRICULA, t.CONTRATO, t.CPF, " + "sl.LOGDATE, '' AS LOGTEXT, sl.LOGHOUR " + "FROM SIPLOG sl " + "INNER JOIN SIPLOG_TABLE st ON st.CODIGO = sl.TABLEID ";
        sql = action.equals((Object)SiplogAction.EXCLUIU) ? sql + "INNER JOIN MOVTOFERIAS m ON REPLACE(SL.LOGTEXT, ASCII_CHAR(13) || ASCII_CHAR(10), '')  LIKE '%EMPRESA=' || m.EMPRESA || 'REGISTRO=' || m.REGISTRO  || 'FERIAS=' || m.FERIAS || 'ITEMFERIAS=' || m.ITEM || 'D%'" : sql + "INNER JOIN CANCELA_FERIAS c ON c.CODIGO = sl.CHAVE INNER JOIN MOVTOFERIAS m ON m.EMPRESA = c.EMPRESA  AND m.REGISTRO = c.REGISTRO AND m.FERIAS = c.FERIAS AND m.ITEM = c.ITEMFERIAS ";
        sql = sql + "INNER JOIN TRABALHADOR t ON t.EMPRESA = m.EMPRESA AND t.REGISTRO = m.REGISTRO WHERE sl.LOGTEXT LIKE '%EMPRESA=' || :entidadeCodigo || '%'  AND sl.LOGDATE BETWEEN :dataInicial AND :dataFinal  AND sl.ACTIONID = " + action.ordinal() + " " + " AND st.NOME = 'CANCELA_FERIAS' " + " AND sl.LOGTEXT LIKE '%TIPO=' || " + TipoGozo.CANCELADO.getCodigo() + " || '%' ";
        return sql;
    }
}

