/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.CagedPK;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="CAGED")
@Audited
public class Caged
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected CagedPK cagedPK;
    @FilterConfig(label="Admitidos", order=3, inputType=FilterInputType.NUMBER)
    @Column(name="ADMITIDOS")
    private Short admitidos;
    @FilterConfig(label="Demitidos", order=4, inputType=FilterInputType.NUMBER)
    @Column(name="DEMITIDOS")
    private Short demitidos;
    @FilterConfig(label="Saldo Anterior", order=5, inputType=FilterInputType.NUMBER)
    @Column(name="SALDO_ANTERIOR")
    private Short saldoAnterior;
    @FilterConfig(label="Saldo Atual", order=6, inputType=FilterInputType.NUMBER)
    @Column(name="SALDO_ATUAL")
    private Short saldoAtual;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Entidade entidade1;

    public Caged() {
    }

    public Caged(CagedPK cagedPK) {
        this.cagedPK = cagedPK;
    }

    public Caged(String entidade, String ano, String mes) {
        this.cagedPK = new CagedPK(entidade, ano, mes);
    }

    public CagedPK getCagedPK() {
        if (this.cagedPK == null) {
            this.cagedPK = new CagedPK();
        }
        return this.cagedPK;
    }

    public void setCagedPK(CagedPK cagedPK) {
        this.cagedPK = cagedPK;
    }

    public Short getAdmitidos() {
        return this.admitidos;
    }

    public void setAdmitidos(Short admitidos) {
        this.admitidos = admitidos;
    }

    public Short getDemitidos() {
        return this.demitidos;
    }

    public void setDemitidos(Short demitidos) {
        this.demitidos = demitidos;
    }

    public Short getSaldoAnterior() {
        return this.saldoAnterior;
    }

    public void setSaldoAnterior(Short saldoAnterior) {
        this.saldoAnterior = saldoAnterior;
    }

    public Short getSaldoAtual() {
        return this.saldoAtual;
    }

    public void setSaldoAtual(Short saldoAtual) {
        this.saldoAtual = saldoAtual;
    }

    public Entidade getEntidade1() {
        return this.entidade1;
    }

    public void setEntidade1(Entidade entidade1) {
        this.entidade1 = entidade1;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.cagedPK != null ? this.cagedPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Caged)) {
            return false;
        }
        Caged other = (Caged)object;
        return (this.cagedPK != null || other.cagedPK == null) && (this.cagedPK == null || this.cagedPK.equals(other.cagedPK));
    }

    public String toString() {
        return "entity.Caged[ cagedPK=" + this.cagedPK + " ]";
    }
}

